# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200601


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RuleSummaryReport(object):
    """
    A summary count of detection rules.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new RuleSummaryReport object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param total_count:
            The value to assign to the total_count property of this RuleSummaryReport.
        :type total_count: int

        :param ingest_time_rules_count:
            The value to assign to the ingest_time_rules_count property of this RuleSummaryReport.
        :type ingest_time_rules_count: int

        :param saved_search_rules_count:
            The value to assign to the saved_search_rules_count property of this RuleSummaryReport.
        :type saved_search_rules_count: int

        """
        self.swagger_types = {
            'total_count': 'int',
            'ingest_time_rules_count': 'int',
            'saved_search_rules_count': 'int'
        }

        self.attribute_map = {
            'total_count': 'totalCount',
            'ingest_time_rules_count': 'ingestTimeRulesCount',
            'saved_search_rules_count': 'savedSearchRulesCount'
        }

        self._total_count = None
        self._ingest_time_rules_count = None
        self._saved_search_rules_count = None

    @property
    def total_count(self):
        """
        **[Required]** Gets the total_count of this RuleSummaryReport.
        The total count of detection rules.


        :return: The total_count of this RuleSummaryReport.
        :rtype: int
        """
        return self._total_count

    @total_count.setter
    def total_count(self, total_count):
        """
        Sets the total_count of this RuleSummaryReport.
        The total count of detection rules.


        :param total_count: The total_count of this RuleSummaryReport.
        :type: int
        """
        self._total_count = total_count

    @property
    def ingest_time_rules_count(self):
        """
        **[Required]** Gets the ingest_time_rules_count of this RuleSummaryReport.
        The count of ingest time rules.


        :return: The ingest_time_rules_count of this RuleSummaryReport.
        :rtype: int
        """
        return self._ingest_time_rules_count

    @ingest_time_rules_count.setter
    def ingest_time_rules_count(self, ingest_time_rules_count):
        """
        Sets the ingest_time_rules_count of this RuleSummaryReport.
        The count of ingest time rules.


        :param ingest_time_rules_count: The ingest_time_rules_count of this RuleSummaryReport.
        :type: int
        """
        self._ingest_time_rules_count = ingest_time_rules_count

    @property
    def saved_search_rules_count(self):
        """
        **[Required]** Gets the saved_search_rules_count of this RuleSummaryReport.
        The count of saved search rules.


        :return: The saved_search_rules_count of this RuleSummaryReport.
        :rtype: int
        """
        return self._saved_search_rules_count

    @saved_search_rules_count.setter
    def saved_search_rules_count(self, saved_search_rules_count):
        """
        Sets the saved_search_rules_count of this RuleSummaryReport.
        The count of saved search rules.


        :param saved_search_rules_count: The saved_search_rules_count of this RuleSummaryReport.
        :type: int
        """
        self._saved_search_rules_count = saved_search_rules_count

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
