# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200601


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PropertyMetadataSummary(object):
    """
    Summary of property metadata details.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PropertyMetadataSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this PropertyMetadataSummary.
        :type name: str

        :param display_name:
            The value to assign to the display_name property of this PropertyMetadataSummary.
        :type display_name: str

        :param description:
            The value to assign to the description property of this PropertyMetadataSummary.
        :type description: str

        :param default_value:
            The value to assign to the default_value property of this PropertyMetadataSummary.
        :type default_value: str

        :param levels:
            The value to assign to the levels property of this PropertyMetadataSummary.
        :type levels: list[oci.log_analytics.models.Level]

        """
        self.swagger_types = {
            'name': 'str',
            'display_name': 'str',
            'description': 'str',
            'default_value': 'str',
            'levels': 'list[Level]'
        }

        self.attribute_map = {
            'name': 'name',
            'display_name': 'displayName',
            'description': 'description',
            'default_value': 'defaultValue',
            'levels': 'levels'
        }

        self._name = None
        self._display_name = None
        self._description = None
        self._default_value = None
        self._levels = None

    @property
    def name(self):
        """
        Gets the name of this PropertyMetadataSummary.
        The property name.


        :return: The name of this PropertyMetadataSummary.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this PropertyMetadataSummary.
        The property name.


        :param name: The name of this PropertyMetadataSummary.
        :type: str
        """
        self._name = name

    @property
    def display_name(self):
        """
        Gets the display_name of this PropertyMetadataSummary.
        The property display name.


        :return: The display_name of this PropertyMetadataSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this PropertyMetadataSummary.
        The property display name.


        :param display_name: The display_name of this PropertyMetadataSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this PropertyMetadataSummary.
        The property description.


        :return: The description of this PropertyMetadataSummary.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this PropertyMetadataSummary.
        The property description.


        :param description: The description of this PropertyMetadataSummary.
        :type: str
        """
        self._description = description

    @property
    def default_value(self):
        """
        Gets the default_value of this PropertyMetadataSummary.
        The default property value.


        :return: The default_value of this PropertyMetadataSummary.
        :rtype: str
        """
        return self._default_value

    @default_value.setter
    def default_value(self, default_value):
        """
        Sets the default_value of this PropertyMetadataSummary.
        The default property value.


        :param default_value: The default_value of this PropertyMetadataSummary.
        :type: str
        """
        self._default_value = default_value

    @property
    def levels(self):
        """
        Gets the levels of this PropertyMetadataSummary.
        A list of levels at which the property could be defined.


        :return: The levels of this PropertyMetadataSummary.
        :rtype: list[oci.log_analytics.models.Level]
        """
        return self._levels

    @levels.setter
    def levels(self, levels):
        """
        Sets the levels of this PropertyMetadataSummary.
        A list of levels at which the property could be defined.


        :param levels: The levels of this PropertyMetadataSummary.
        :type: list[oci.log_analytics.models.Level]
        """
        self._levels = levels

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
