# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210610


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GenerateAgentInstallerConfigurationDetails(object):
    """
    Attributes to generate agent installer parameters for a fleet.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new GenerateAgentInstallerConfigurationDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param install_key_id:
            The value to assign to the install_key_id property of this GenerateAgentInstallerConfigurationDetails.
        :type install_key_id: str

        :param fleet_id:
            The value to assign to the fleet_id property of this GenerateAgentInstallerConfigurationDetails.
        :type fleet_id: str

        """
        self.swagger_types = {
            'install_key_id': 'str',
            'fleet_id': 'str'
        }

        self.attribute_map = {
            'install_key_id': 'installKeyId',
            'fleet_id': 'fleetId'
        }

        self._install_key_id = None
        self._fleet_id = None

    @property
    def install_key_id(self):
        """
        **[Required]** Gets the install_key_id of this GenerateAgentInstallerConfigurationDetails.
        The `OCID`__ of the install key for which to generate the configuration file.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The install_key_id of this GenerateAgentInstallerConfigurationDetails.
        :rtype: str
        """
        return self._install_key_id

    @install_key_id.setter
    def install_key_id(self, install_key_id):
        """
        Sets the install_key_id of this GenerateAgentInstallerConfigurationDetails.
        The `OCID`__ of the install key for which to generate the configuration file.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param install_key_id: The install_key_id of this GenerateAgentInstallerConfigurationDetails.
        :type: str
        """
        self._install_key_id = install_key_id

    @property
    def fleet_id(self):
        """
        **[Required]** Gets the fleet_id of this GenerateAgentInstallerConfigurationDetails.
        The `OCID`__ of the fleet for which to generate the configuration file.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The fleet_id of this GenerateAgentInstallerConfigurationDetails.
        :rtype: str
        """
        return self._fleet_id

    @fleet_id.setter
    def fleet_id(self, fleet_id):
        """
        Sets the fleet_id of this GenerateAgentInstallerConfigurationDetails.
        The `OCID`__ of the fleet for which to generate the configuration file.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param fleet_id: The fleet_id of this GenerateAgentInstallerConfigurationDetails.
        :type: str
        """
        self._fleet_id = fleet_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
