# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: v1


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AppObjectClasses(object):
    """
    Object classes

    **SCIM++ Properties:**
    - idcsCompositeKey: [value]
    - idcsSearchable: true
    - multiValued: true
    - mutability: readOnly
    - required: false
    - returned: default
    - type: complex
    - uniqueness: none
    """

    #: A constant which can be used with the type property of a AppObjectClasses.
    #: This constant has a value of "AccountObjectClass"
    TYPE_ACCOUNT_OBJECT_CLASS = "AccountObjectClass"

    #: A constant which can be used with the type property of a AppObjectClasses.
    #: This constant has a value of "ManagedObjectClass"
    TYPE_MANAGED_OBJECT_CLASS = "ManagedObjectClass"

    def __init__(self, **kwargs):
        """
        Initializes a new AppObjectClasses object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param value:
            The value to assign to the value property of this AppObjectClasses.
        :type value: str

        :param ref:
            The value to assign to the ref property of this AppObjectClasses.
        :type ref: str

        :param display:
            The value to assign to the display property of this AppObjectClasses.
        :type display: str

        :param resource_type:
            The value to assign to the resource_type property of this AppObjectClasses.
        :type resource_type: str

        :param is_account_object_class:
            The value to assign to the is_account_object_class property of this AppObjectClasses.
        :type is_account_object_class: bool

        :param type:
            The value to assign to the type property of this AppObjectClasses.
            Allowed values for this property are: "AccountObjectClass", "ManagedObjectClass", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        """
        self.swagger_types = {
            'value': 'str',
            'ref': 'str',
            'display': 'str',
            'resource_type': 'str',
            'is_account_object_class': 'bool',
            'type': 'str'
        }

        self.attribute_map = {
            'value': 'value',
            'ref': '$ref',
            'display': 'display',
            'resource_type': 'resourceType',
            'is_account_object_class': 'isAccountObjectClass',
            'type': 'type'
        }

        self._value = None
        self._ref = None
        self._display = None
        self._resource_type = None
        self._is_account_object_class = None
        self._type = None

    @property
    def value(self):
        """
        **[Required]** Gets the value of this AppObjectClasses.
        Object class template identifier

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :return: The value of this AppObjectClasses.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this AppObjectClasses.
        Object class template identifier

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :param value: The value of this AppObjectClasses.
        :type: str
        """
        self._value = value

    @property
    def ref(self):
        """
        Gets the ref of this AppObjectClasses.
        Object class URI

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: reference
         - uniqueness: none


        :return: The ref of this AppObjectClasses.
        :rtype: str
        """
        return self._ref

    @ref.setter
    def ref(self, ref):
        """
        Sets the ref of this AppObjectClasses.
        Object class URI

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: reference
         - uniqueness: none


        :param ref: The ref of this AppObjectClasses.
        :type: str
        """
        self._ref = ref

    @property
    def display(self):
        """
        Gets the display of this AppObjectClasses.
        Object class display name

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The display of this AppObjectClasses.
        :rtype: str
        """
        return self._display

    @display.setter
    def display(self, display):
        """
        Sets the display of this AppObjectClasses.
        Object class display name

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param display: The display of this AppObjectClasses.
        :type: str
        """
        self._display = display

    @property
    def resource_type(self):
        """
        Gets the resource_type of this AppObjectClasses.
        Object class resource type

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The resource_type of this AppObjectClasses.
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """
        Sets the resource_type of this AppObjectClasses.
        Object class resource type

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param resource_type: The resource_type of this AppObjectClasses.
        :type: str
        """
        self._resource_type = resource_type

    @property
    def is_account_object_class(self):
        """
        Gets the is_account_object_class of this AppObjectClasses.
        If true, the object class represents an account. The isAccountObjectClass attribute value 'true' MUST appear no more than once.

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The is_account_object_class of this AppObjectClasses.
        :rtype: bool
        """
        return self._is_account_object_class

    @is_account_object_class.setter
    def is_account_object_class(self, is_account_object_class):
        """
        Sets the is_account_object_class of this AppObjectClasses.
        If true, the object class represents an account. The isAccountObjectClass attribute value 'true' MUST appear no more than once.

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param is_account_object_class: The is_account_object_class of this AppObjectClasses.
        :type: bool
        """
        self._is_account_object_class = is_account_object_class

    @property
    def type(self):
        """
        **[Required]** Gets the type of this AppObjectClasses.
        Object Class type. Allowed values are AccountObjectClass, ManagedObjectClass.

        **Added In:** 18.1.6

        **SCIM++ Properties:**
         - caseExact: true
         - idcsDefaultValue: AccountObjectClass
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: true
         - returned: default
         - type: string
         - uniqueness: none

        Allowed values for this property are: "AccountObjectClass", "ManagedObjectClass", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this AppObjectClasses.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this AppObjectClasses.
        Object Class type. Allowed values are AccountObjectClass, ManagedObjectClass.

        **Added In:** 18.1.6

        **SCIM++ Properties:**
         - caseExact: true
         - idcsDefaultValue: AccountObjectClass
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :param type: The type of this AppObjectClasses.
        :type: str
        """
        allowed_values = ["AccountObjectClass", "ManagedObjectClass"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
