# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ModelMetrics(object):
    """
    Model metrics during the creation of a new model.
    """

    #: A constant which can be used with the model_metrics_type property of a ModelMetrics.
    #: This constant has a value of "TEXT_GENERATION_MODEL_METRICS"
    MODEL_METRICS_TYPE_TEXT_GENERATION_MODEL_METRICS = "TEXT_GENERATION_MODEL_METRICS"

    #: A constant which can be used with the model_metrics_type property of a ModelMetrics.
    #: This constant has a value of "CHAT_MODEL_METRICS"
    MODEL_METRICS_TYPE_CHAT_MODEL_METRICS = "CHAT_MODEL_METRICS"

    def __init__(self, **kwargs):
        """
        Initializes a new ModelMetrics object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.generative_ai.models.TextGenerationModelMetrics`
        * :class:`~oci.generative_ai.models.ChatModelMetrics`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param model_metrics_type:
            The value to assign to the model_metrics_type property of this ModelMetrics.
            Allowed values for this property are: "TEXT_GENERATION_MODEL_METRICS", "CHAT_MODEL_METRICS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type model_metrics_type: str

        """
        self.swagger_types = {
            'model_metrics_type': 'str'
        }

        self.attribute_map = {
            'model_metrics_type': 'modelMetricsType'
        }

        self._model_metrics_type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['modelMetricsType']

        if type == 'TEXT_GENERATION_MODEL_METRICS':
            return 'TextGenerationModelMetrics'

        if type == 'CHAT_MODEL_METRICS':
            return 'ChatModelMetrics'
        else:
            return 'ModelMetrics'

    @property
    def model_metrics_type(self):
        """
        **[Required]** Gets the model_metrics_type of this ModelMetrics.
        The type of the model metrics. Each type of model can expect a different set of model metrics.

        Allowed values for this property are: "TEXT_GENERATION_MODEL_METRICS", "CHAT_MODEL_METRICS", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The model_metrics_type of this ModelMetrics.
        :rtype: str
        """
        return self._model_metrics_type

    @model_metrics_type.setter
    def model_metrics_type(self, model_metrics_type):
        """
        Sets the model_metrics_type of this ModelMetrics.
        The type of the model metrics. Each type of model can expect a different set of model metrics.


        :param model_metrics_type: The model_metrics_type of this ModelMetrics.
        :type: str
        """
        allowed_values = ["TEXT_GENERATION_MODEL_METRICS", "CHAT_MODEL_METRICS"]
        if not value_allowed_none_or_none_sentinel(model_metrics_type, allowed_values):
            model_metrics_type = 'UNKNOWN_ENUM_VALUE'
        self._model_metrics_type = model_metrics_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
