# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230831

from .credential_details import CredentialDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class VaultSecretCredentialDetails(CredentialDetails):
    """
    Secret details.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new VaultSecretCredentialDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_apps_management.models.VaultSecretCredentialDetails.credential_type` attribute
        of this class is ``VAULT_SECRET`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param credential_type:
            The value to assign to the credential_type property of this VaultSecretCredentialDetails.
            Allowed values for this property are: "PLAIN_TEXT", "VAULT_SECRET", "KEY_ENCRYPTION"
        :type credential_type: str

        :param secret_id:
            The value to assign to the secret_id property of this VaultSecretCredentialDetails.
        :type secret_id: str

        :param secret_version:
            The value to assign to the secret_version property of this VaultSecretCredentialDetails.
        :type secret_version: str

        """
        self.swagger_types = {
            'credential_type': 'str',
            'secret_id': 'str',
            'secret_version': 'str'
        }

        self.attribute_map = {
            'credential_type': 'credentialType',
            'secret_id': 'secretId',
            'secret_version': 'secretVersion'
        }

        self._credential_type = None
        self._secret_id = None
        self._secret_version = None
        self._credential_type = 'VAULT_SECRET'

    @property
    def secret_id(self):
        """
        **[Required]** Gets the secret_id of this VaultSecretCredentialDetails.
        The `OCID`__ of the secret.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The secret_id of this VaultSecretCredentialDetails.
        :rtype: str
        """
        return self._secret_id

    @secret_id.setter
    def secret_id(self, secret_id):
        """
        Sets the secret_id of this VaultSecretCredentialDetails.
        The `OCID`__ of the secret.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param secret_id: The secret_id of this VaultSecretCredentialDetails.
        :type: str
        """
        self._secret_id = secret_id

    @property
    def secret_version(self):
        """
        Gets the secret_version of this VaultSecretCredentialDetails.
        The secret version.


        :return: The secret_version of this VaultSecretCredentialDetails.
        :rtype: str
        """
        return self._secret_version

    @secret_version.setter
    def secret_version(self, secret_version):
        """
        Sets the secret_version of this VaultSecretCredentialDetails.
        The secret version.


        :param secret_version: The secret_version of this VaultSecretCredentialDetails.
        :type: str
        """
        self._secret_version = secret_version

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
