# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230831


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateOnboardingDetails(object):
    """
    The information about updating onboarding.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateOnboardingDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param is_fams_tag_enabled:
            The value to assign to the is_fams_tag_enabled property of this UpdateOnboardingDetails.
        :type is_fams_tag_enabled: bool

        :param is_cost_tracking_tag_enabled:
            The value to assign to the is_cost_tracking_tag_enabled property of this UpdateOnboardingDetails.
        :type is_cost_tracking_tag_enabled: bool

        """
        self.swagger_types = {
            'is_fams_tag_enabled': 'bool',
            'is_cost_tracking_tag_enabled': 'bool'
        }

        self.attribute_map = {
            'is_fams_tag_enabled': 'isFamsTagEnabled',
            'is_cost_tracking_tag_enabled': 'isCostTrackingTagEnabled'
        }

        self._is_fams_tag_enabled = None
        self._is_cost_tracking_tag_enabled = None

    @property
    def is_fams_tag_enabled(self):
        """
        Gets the is_fams_tag_enabled of this UpdateOnboardingDetails.
        A value determining Fleet Application Management tag is enabled or not


        :return: The is_fams_tag_enabled of this UpdateOnboardingDetails.
        :rtype: bool
        """
        return self._is_fams_tag_enabled

    @is_fams_tag_enabled.setter
    def is_fams_tag_enabled(self, is_fams_tag_enabled):
        """
        Sets the is_fams_tag_enabled of this UpdateOnboardingDetails.
        A value determining Fleet Application Management tag is enabled or not


        :param is_fams_tag_enabled: The is_fams_tag_enabled of this UpdateOnboardingDetails.
        :type: bool
        """
        self._is_fams_tag_enabled = is_fams_tag_enabled

    @property
    def is_cost_tracking_tag_enabled(self):
        """
        Gets the is_cost_tracking_tag_enabled of this UpdateOnboardingDetails.
        A value determining if cost tracking tag is enabled or not


        :return: The is_cost_tracking_tag_enabled of this UpdateOnboardingDetails.
        :rtype: bool
        """
        return self._is_cost_tracking_tag_enabled

    @is_cost_tracking_tag_enabled.setter
    def is_cost_tracking_tag_enabled(self, is_cost_tracking_tag_enabled):
        """
        Sets the is_cost_tracking_tag_enabled of this UpdateOnboardingDetails.
        A value determining if cost tracking tag is enabled or not


        :param is_cost_tracking_tag_enabled: The is_cost_tracking_tag_enabled of this UpdateOnboardingDetails.
        :type: bool
        """
        self._is_cost_tracking_tag_enabled = is_cost_tracking_tag_enabled

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
