# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230831


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateFleetDetails(object):
    """
    The information to be updated.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateFleetDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this UpdateFleetDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this UpdateFleetDetails.
        :type description: str

        :param notification_preferences:
            The value to assign to the notification_preferences property of this UpdateFleetDetails.
        :type notification_preferences: oci.fleet_apps_management.models.NotificationPreferences

        :param rule_selection_criteria:
            The value to assign to the rule_selection_criteria property of this UpdateFleetDetails.
        :type rule_selection_criteria: oci.fleet_apps_management.models.SelectionCriteria

        :param is_target_auto_confirm:
            The value to assign to the is_target_auto_confirm property of this UpdateFleetDetails.
        :type is_target_auto_confirm: bool

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateFleetDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateFleetDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'description': 'str',
            'notification_preferences': 'NotificationPreferences',
            'rule_selection_criteria': 'SelectionCriteria',
            'is_target_auto_confirm': 'bool',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'display_name': 'displayName',
            'description': 'description',
            'notification_preferences': 'notificationPreferences',
            'rule_selection_criteria': 'ruleSelectionCriteria',
            'is_target_auto_confirm': 'isTargetAutoConfirm',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }

        self._display_name = None
        self._description = None
        self._notification_preferences = None
        self._rule_selection_criteria = None
        self._is_target_auto_confirm = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        Gets the display_name of this UpdateFleetDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Example: `My new resource`


        :return: The display_name of this UpdateFleetDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UpdateFleetDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Example: `My new resource`


        :param display_name: The display_name of this UpdateFleetDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this UpdateFleetDetails.
        A user-friendly description. To provide some insight about the resource.
        Avoid entering confidential information.


        :return: The description of this UpdateFleetDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this UpdateFleetDetails.
        A user-friendly description. To provide some insight about the resource.
        Avoid entering confidential information.


        :param description: The description of this UpdateFleetDetails.
        :type: str
        """
        self._description = description

    @property
    def notification_preferences(self):
        """
        Gets the notification_preferences of this UpdateFleetDetails.

        :return: The notification_preferences of this UpdateFleetDetails.
        :rtype: oci.fleet_apps_management.models.NotificationPreferences
        """
        return self._notification_preferences

    @notification_preferences.setter
    def notification_preferences(self, notification_preferences):
        """
        Sets the notification_preferences of this UpdateFleetDetails.

        :param notification_preferences: The notification_preferences of this UpdateFleetDetails.
        :type: oci.fleet_apps_management.models.NotificationPreferences
        """
        self._notification_preferences = notification_preferences

    @property
    def rule_selection_criteria(self):
        """
        Gets the rule_selection_criteria of this UpdateFleetDetails.

        :return: The rule_selection_criteria of this UpdateFleetDetails.
        :rtype: oci.fleet_apps_management.models.SelectionCriteria
        """
        return self._rule_selection_criteria

    @rule_selection_criteria.setter
    def rule_selection_criteria(self, rule_selection_criteria):
        """
        Sets the rule_selection_criteria of this UpdateFleetDetails.

        :param rule_selection_criteria: The rule_selection_criteria of this UpdateFleetDetails.
        :type: oci.fleet_apps_management.models.SelectionCriteria
        """
        self._rule_selection_criteria = rule_selection_criteria

    @property
    def is_target_auto_confirm(self):
        """
        Gets the is_target_auto_confirm of this UpdateFleetDetails.
        A value that represents if auto-confirming of the targets can be enabled.
        This will allow targets to be auto-confirmed in the fleet without manual intervention.


        :return: The is_target_auto_confirm of this UpdateFleetDetails.
        :rtype: bool
        """
        return self._is_target_auto_confirm

    @is_target_auto_confirm.setter
    def is_target_auto_confirm(self, is_target_auto_confirm):
        """
        Sets the is_target_auto_confirm of this UpdateFleetDetails.
        A value that represents if auto-confirming of the targets can be enabled.
        This will allow targets to be auto-confirmed in the fleet without manual intervention.


        :param is_target_auto_confirm: The is_target_auto_confirm of this UpdateFleetDetails.
        :type: bool
        """
        self._is_target_auto_confirm = is_target_auto_confirm

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateFleetDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this UpdateFleetDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateFleetDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this UpdateFleetDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateFleetDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this UpdateFleetDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateFleetDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this UpdateFleetDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
