# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230831


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class TargetResource(object):
    """
    Resource Information for the Target.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new TargetResource object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param resource_id:
            The value to assign to the resource_id property of this TargetResource.
        :type resource_id: str

        :param resource_display_name:
            The value to assign to the resource_display_name property of this TargetResource.
        :type resource_display_name: str

        """
        self.swagger_types = {
            'resource_id': 'str',
            'resource_display_name': 'str'
        }

        self.attribute_map = {
            'resource_id': 'resourceId',
            'resource_display_name': 'resourceDisplayName'
        }

        self._resource_id = None
        self._resource_display_name = None

    @property
    def resource_id(self):
        """
        Gets the resource_id of this TargetResource.
        The OCID of the resource.


        :return: The resource_id of this TargetResource.
        :rtype: str
        """
        return self._resource_id

    @resource_id.setter
    def resource_id(self, resource_id):
        """
        Sets the resource_id of this TargetResource.
        The OCID of the resource.


        :param resource_id: The resource_id of this TargetResource.
        :type: str
        """
        self._resource_id = resource_id

    @property
    def resource_display_name(self):
        """
        Gets the resource_display_name of this TargetResource.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Example: `My new resource`


        :return: The resource_display_name of this TargetResource.
        :rtype: str
        """
        return self._resource_display_name

    @resource_display_name.setter
    def resource_display_name(self, resource_display_name):
        """
        Sets the resource_display_name of this TargetResource.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Example: `My new resource`


        :param resource_display_name: The resource_display_name of this TargetResource.
        :type: str
        """
        self._resource_display_name = resource_display_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
