# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230831


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ScheduledFleetSummary(object):
    """
    Summary of Fleet part of the Schedule.
    """

    #: A constant which can be used with the action_group_types property of a ScheduledFleetSummary.
    #: This constant has a value of "PRODUCT"
    ACTION_GROUP_TYPES_PRODUCT = "PRODUCT"

    #: A constant which can be used with the action_group_types property of a ScheduledFleetSummary.
    #: This constant has a value of "ENVIRONMENT"
    ACTION_GROUP_TYPES_ENVIRONMENT = "ENVIRONMENT"

    def __init__(self, **kwargs):
        """
        Initializes a new ScheduledFleetSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this ScheduledFleetSummary.
        :type id: str

        :param tenancy_id:
            The value to assign to the tenancy_id property of this ScheduledFleetSummary.
        :type tenancy_id: str

        :param display_name:
            The value to assign to the display_name property of this ScheduledFleetSummary.
        :type display_name: str

        :param count_of_affected_resources:
            The value to assign to the count_of_affected_resources property of this ScheduledFleetSummary.
        :type count_of_affected_resources: int

        :param count_of_affected_targets:
            The value to assign to the count_of_affected_targets property of this ScheduledFleetSummary.
        :type count_of_affected_targets: int

        :param action_group_types:
            The value to assign to the action_group_types property of this ScheduledFleetSummary.
            Allowed values for items in this list are: "PRODUCT", "ENVIRONMENT", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type action_group_types: list[str]

        :param application_types:
            The value to assign to the application_types property of this ScheduledFleetSummary.
        :type application_types: list[str]

        :param system_tags:
            The value to assign to the system_tags property of this ScheduledFleetSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'tenancy_id': 'str',
            'display_name': 'str',
            'count_of_affected_resources': 'int',
            'count_of_affected_targets': 'int',
            'action_group_types': 'list[str]',
            'application_types': 'list[str]',
            'system_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'id': 'id',
            'tenancy_id': 'tenancyId',
            'display_name': 'displayName',
            'count_of_affected_resources': 'countOfAffectedResources',
            'count_of_affected_targets': 'countOfAffectedTargets',
            'action_group_types': 'actionGroupTypes',
            'application_types': 'applicationTypes',
            'system_tags': 'systemTags'
        }

        self._id = None
        self._tenancy_id = None
        self._display_name = None
        self._count_of_affected_resources = None
        self._count_of_affected_targets = None
        self._action_group_types = None
        self._application_types = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this ScheduledFleetSummary.
        The OCID of the resource.


        :return: The id of this ScheduledFleetSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ScheduledFleetSummary.
        The OCID of the resource.


        :param id: The id of this ScheduledFleetSummary.
        :type: str
        """
        self._id = id

    @property
    def tenancy_id(self):
        """
        Gets the tenancy_id of this ScheduledFleetSummary.
        OCID of the tenancy to which the resource belongs to.


        :return: The tenancy_id of this ScheduledFleetSummary.
        :rtype: str
        """
        return self._tenancy_id

    @tenancy_id.setter
    def tenancy_id(self, tenancy_id):
        """
        Sets the tenancy_id of this ScheduledFleetSummary.
        OCID of the tenancy to which the resource belongs to.


        :param tenancy_id: The tenancy_id of this ScheduledFleetSummary.
        :type: str
        """
        self._tenancy_id = tenancy_id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this ScheduledFleetSummary.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Example: `My new resource`


        :return: The display_name of this ScheduledFleetSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this ScheduledFleetSummary.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Example: `My new resource`


        :param display_name: The display_name of this ScheduledFleetSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def count_of_affected_resources(self):
        """
        Gets the count_of_affected_resources of this ScheduledFleetSummary.
        Count of Resources affected by the Schedule


        :return: The count_of_affected_resources of this ScheduledFleetSummary.
        :rtype: int
        """
        return self._count_of_affected_resources

    @count_of_affected_resources.setter
    def count_of_affected_resources(self, count_of_affected_resources):
        """
        Sets the count_of_affected_resources of this ScheduledFleetSummary.
        Count of Resources affected by the Schedule


        :param count_of_affected_resources: The count_of_affected_resources of this ScheduledFleetSummary.
        :type: int
        """
        self._count_of_affected_resources = count_of_affected_resources

    @property
    def count_of_affected_targets(self):
        """
        Gets the count_of_affected_targets of this ScheduledFleetSummary.
        Count of Targets affected by the Schedule


        :return: The count_of_affected_targets of this ScheduledFleetSummary.
        :rtype: int
        """
        return self._count_of_affected_targets

    @count_of_affected_targets.setter
    def count_of_affected_targets(self, count_of_affected_targets):
        """
        Sets the count_of_affected_targets of this ScheduledFleetSummary.
        Count of Targets affected by the Schedule


        :param count_of_affected_targets: The count_of_affected_targets of this ScheduledFleetSummary.
        :type: int
        """
        self._count_of_affected_targets = count_of_affected_targets

    @property
    def action_group_types(self):
        """
        Gets the action_group_types of this ScheduledFleetSummary.
        All ActionGroup Types part of the schedule.

        Allowed values for items in this list are: "PRODUCT", "ENVIRONMENT", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The action_group_types of this ScheduledFleetSummary.
        :rtype: list[str]
        """
        return self._action_group_types

    @action_group_types.setter
    def action_group_types(self, action_group_types):
        """
        Sets the action_group_types of this ScheduledFleetSummary.
        All ActionGroup Types part of the schedule.


        :param action_group_types: The action_group_types of this ScheduledFleetSummary.
        :type: list[str]
        """
        allowed_values = ["PRODUCT", "ENVIRONMENT"]
        if action_group_types:
            action_group_types[:] = ['UNKNOWN_ENUM_VALUE' if not value_allowed_none_or_none_sentinel(x, allowed_values) else x for x in action_group_types]
        self._action_group_types = action_group_types

    @property
    def application_types(self):
        """
        Gets the application_types of this ScheduledFleetSummary.
        All application types part of the schedule.


        :return: The application_types of this ScheduledFleetSummary.
        :rtype: list[str]
        """
        return self._application_types

    @application_types.setter
    def application_types(self, application_types):
        """
        Sets the application_types of this ScheduledFleetSummary.
        All application types part of the schedule.


        :param application_types: The application_types of this ScheduledFleetSummary.
        :type: list[str]
        """
        self._application_types = application_types

    @property
    def system_tags(self):
        """
        Gets the system_tags of this ScheduledFleetSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this ScheduledFleetSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this ScheduledFleetSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this ScheduledFleetSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
