# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230831


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OperationRunbook(object):
    """
    Runbook
    """

    def __init__(self, **kwargs):
        """
        Initializes a new OperationRunbook object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this OperationRunbook.
        :type id: str

        :param input_parameters:
            The value to assign to the input_parameters property of this OperationRunbook.
        :type input_parameters: list[oci.fleet_apps_management.models.InputParameter]

        """
        self.swagger_types = {
            'id': 'str',
            'input_parameters': 'list[InputParameter]'
        }

        self.attribute_map = {
            'id': 'id',
            'input_parameters': 'inputParameters'
        }

        self._id = None
        self._input_parameters = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this OperationRunbook.
        The ID of the Runbook


        :return: The id of this OperationRunbook.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this OperationRunbook.
        The ID of the Runbook


        :param id: The id of this OperationRunbook.
        :type: str
        """
        self._id = id

    @property
    def input_parameters(self):
        """
        Gets the input_parameters of this OperationRunbook.
        Input Parameters for the Task


        :return: The input_parameters of this OperationRunbook.
        :rtype: list[oci.fleet_apps_management.models.InputParameter]
        """
        return self._input_parameters

    @input_parameters.setter
    def input_parameters(self, input_parameters):
        """
        Sets the input_parameters of this OperationRunbook.
        Input Parameters for the Task


        :param input_parameters: The input_parameters of this OperationRunbook.
        :type: list[oci.fleet_apps_management.models.InputParameter]
        """
        self._input_parameters = input_parameters

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
