# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230831


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class JobActivity(object):
    """
    Activity details including status corresponding to an Action Group.
    """

    #: A constant which can be used with the status property of a JobActivity.
    #: This constant has a value of "ACCEPTED"
    STATUS_ACCEPTED = "ACCEPTED"

    #: A constant which can be used with the status property of a JobActivity.
    #: This constant has a value of "WAITING"
    STATUS_WAITING = "WAITING"

    #: A constant which can be used with the status property of a JobActivity.
    #: This constant has a value of "IN_PROGRESS"
    STATUS_IN_PROGRESS = "IN_PROGRESS"

    #: A constant which can be used with the status property of a JobActivity.
    #: This constant has a value of "FAILED"
    STATUS_FAILED = "FAILED"

    #: A constant which can be used with the status property of a JobActivity.
    #: This constant has a value of "SUCCEEDED"
    STATUS_SUCCEEDED = "SUCCEEDED"

    #: A constant which can be used with the status property of a JobActivity.
    #: This constant has a value of "CANCELED"
    STATUS_CANCELED = "CANCELED"

    #: A constant which can be used with the status property of a JobActivity.
    #: This constant has a value of "SKIPPED"
    STATUS_SKIPPED = "SKIPPED"

    #: A constant which can be used with the status property of a JobActivity.
    #: This constant has a value of "IGNORED"
    STATUS_IGNORED = "IGNORED"

    #: A constant which can be used with the status property of a JobActivity.
    #: This constant has a value of "NOT_APPLICABLE"
    STATUS_NOT_APPLICABLE = "NOT_APPLICABLE"

    #: A constant which can be used with the status property of a JobActivity.
    #: This constant has a value of "ABORTED"
    STATUS_ABORTED = "ABORTED"

    #: A constant which can be used with the status property of a JobActivity.
    #: This constant has a value of "TIMED_OUT"
    STATUS_TIMED_OUT = "TIMED_OUT"

    #: A constant which can be used with the status property of a JobActivity.
    #: This constant has a value of "PAUSED"
    STATUS_PAUSED = "PAUSED"

    def __init__(self, **kwargs):
        """
        Initializes a new JobActivity object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this JobActivity.
        :type id: str

        :param status:
            The value to assign to the status property of this JobActivity.
            Allowed values for this property are: "ACCEPTED", "WAITING", "IN_PROGRESS", "FAILED", "SUCCEEDED", "CANCELED", "SKIPPED", "IGNORED", "NOT_APPLICABLE", "ABORTED", "TIMED_OUT", "PAUSED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type status: str

        :param time_started:
            The value to assign to the time_started property of this JobActivity.
        :type time_started: datetime

        :param time_ended:
            The value to assign to the time_ended property of this JobActivity.
        :type time_ended: datetime

        :param runbook_id:
            The value to assign to the runbook_id property of this JobActivity.
        :type runbook_id: str

        :param runbook_name:
            The value to assign to the runbook_name property of this JobActivity.
        :type runbook_name: str

        :param description:
            The value to assign to the description property of this JobActivity.
        :type description: str

        :param resource_level_executions:
            The value to assign to the resource_level_executions property of this JobActivity.
        :type resource_level_executions: list[oci.fleet_apps_management.models.EntityExecutionDetails]

        """
        self.swagger_types = {
            'id': 'str',
            'status': 'str',
            'time_started': 'datetime',
            'time_ended': 'datetime',
            'runbook_id': 'str',
            'runbook_name': 'str',
            'description': 'str',
            'resource_level_executions': 'list[EntityExecutionDetails]'
        }

        self.attribute_map = {
            'id': 'id',
            'status': 'status',
            'time_started': 'timeStarted',
            'time_ended': 'timeEnded',
            'runbook_id': 'runbookId',
            'runbook_name': 'runbookName',
            'description': 'description',
            'resource_level_executions': 'resourceLevelExecutions'
        }

        self._id = None
        self._status = None
        self._time_started = None
        self._time_ended = None
        self._runbook_id = None
        self._runbook_name = None
        self._description = None
        self._resource_level_executions = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this JobActivity.
        Unique activity id at the action group level.
        In most cases, this would be a generated ActionGroupId.


        :return: The id of this JobActivity.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this JobActivity.
        Unique activity id at the action group level.
        In most cases, this would be a generated ActionGroupId.


        :param id: The id of this JobActivity.
        :type: str
        """
        self._id = id

    @property
    def status(self):
        """
        **[Required]** Gets the status of this JobActivity.
        Status of the Job at Action Group Level.

        Allowed values for this property are: "ACCEPTED", "WAITING", "IN_PROGRESS", "FAILED", "SUCCEEDED", "CANCELED", "SKIPPED", "IGNORED", "NOT_APPLICABLE", "ABORTED", "TIMED_OUT", "PAUSED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The status of this JobActivity.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this JobActivity.
        Status of the Job at Action Group Level.


        :param status: The status of this JobActivity.
        :type: str
        """
        allowed_values = ["ACCEPTED", "WAITING", "IN_PROGRESS", "FAILED", "SUCCEEDED", "CANCELED", "SKIPPED", "IGNORED", "NOT_APPLICABLE", "ABORTED", "TIMED_OUT", "PAUSED"]
        if not value_allowed_none_or_none_sentinel(status, allowed_values):
            status = 'UNKNOWN_ENUM_VALUE'
        self._status = status

    @property
    def time_started(self):
        """
        Gets the time_started of this JobActivity.
        The time the execution for the Action Group started. An RFC3339 formatted datetime string.


        :return: The time_started of this JobActivity.
        :rtype: datetime
        """
        return self._time_started

    @time_started.setter
    def time_started(self, time_started):
        """
        Sets the time_started of this JobActivity.
        The time the execution for the Action Group started. An RFC3339 formatted datetime string.


        :param time_started: The time_started of this JobActivity.
        :type: datetime
        """
        self._time_started = time_started

    @property
    def time_ended(self):
        """
        Gets the time_ended of this JobActivity.
        The time the execution for the Action Group ended. An RFC3339 formatted datetime string


        :return: The time_ended of this JobActivity.
        :rtype: datetime
        """
        return self._time_ended

    @time_ended.setter
    def time_ended(self, time_ended):
        """
        Sets the time_ended of this JobActivity.
        The time the execution for the Action Group ended. An RFC3339 formatted datetime string


        :param time_ended: The time_ended of this JobActivity.
        :type: datetime
        """
        self._time_ended = time_ended

    @property
    def runbook_id(self):
        """
        Gets the runbook_id of this JobActivity.
        OCID of the runbook associated with the Action Group.


        :return: The runbook_id of this JobActivity.
        :rtype: str
        """
        return self._runbook_id

    @runbook_id.setter
    def runbook_id(self, runbook_id):
        """
        Sets the runbook_id of this JobActivity.
        OCID of the runbook associated with the Action Group.


        :param runbook_id: The runbook_id of this JobActivity.
        :type: str
        """
        self._runbook_id = runbook_id

    @property
    def runbook_name(self):
        """
        Gets the runbook_name of this JobActivity.
        Name of the runbook associated with the Action Group.


        :return: The runbook_name of this JobActivity.
        :rtype: str
        """
        return self._runbook_name

    @runbook_name.setter
    def runbook_name(self, runbook_name):
        """
        Sets the runbook_name of this JobActivity.
        Name of the runbook associated with the Action Group.


        :param runbook_name: The runbook_name of this JobActivity.
        :type: str
        """
        self._runbook_name = runbook_name

    @property
    def description(self):
        """
        Gets the description of this JobActivity.
        A description of the Job Activity status.
        If there are any errors, this can also include a short error message.


        :return: The description of this JobActivity.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this JobActivity.
        A description of the Job Activity status.
        If there are any errors, this can also include a short error message.


        :param description: The description of this JobActivity.
        :type: str
        """
        self._description = description

    @property
    def resource_level_executions(self):
        """
        Gets the resource_level_executions of this JobActivity.
        List of Resource executions associated with the Action Group.


        :return: The resource_level_executions of this JobActivity.
        :rtype: list[oci.fleet_apps_management.models.EntityExecutionDetails]
        """
        return self._resource_level_executions

    @resource_level_executions.setter
    def resource_level_executions(self, resource_level_executions):
        """
        Sets the resource_level_executions of this JobActivity.
        List of Resource executions associated with the Action Group.


        :param resource_level_executions: The resource_level_executions of this JobActivity.
        :type: list[oci.fleet_apps_management.models.EntityExecutionDetails]
        """
        self._resource_level_executions = resource_level_executions

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
