# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230831


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class InputParameter(object):
    """
    Input Parameters for the Task
    """

    def __init__(self, **kwargs):
        """
        Initializes a new InputParameter object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param step_name:
            The value to assign to the step_name property of this InputParameter.
        :type step_name: str

        :param arguments:
            The value to assign to the arguments property of this InputParameter.
        :type arguments: list[oci.fleet_apps_management.models.TaskArgument]

        """
        self.swagger_types = {
            'step_name': 'str',
            'arguments': 'list[TaskArgument]'
        }

        self.attribute_map = {
            'step_name': 'stepName',
            'arguments': 'arguments'
        }

        self._step_name = None
        self._arguments = None

    @property
    def step_name(self):
        """
        **[Required]** Gets the step_name of this InputParameter.
        stepName for which the input parameters are provided


        :return: The step_name of this InputParameter.
        :rtype: str
        """
        return self._step_name

    @step_name.setter
    def step_name(self, step_name):
        """
        Sets the step_name of this InputParameter.
        stepName for which the input parameters are provided


        :param step_name: The step_name of this InputParameter.
        :type: str
        """
        self._step_name = step_name

    @property
    def arguments(self):
        """
        Gets the arguments of this InputParameter.
        Arguments for the Task


        :return: The arguments of this InputParameter.
        :rtype: list[oci.fleet_apps_management.models.TaskArgument]
        """
        return self._arguments

    @arguments.setter
    def arguments(self, arguments):
        """
        Sets the arguments of this InputParameter.
        Arguments for the Task


        :param arguments: The arguments of this InputParameter.
        :type: list[oci.fleet_apps_management.models.TaskArgument]
        """
        self._arguments = arguments

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
