# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230831


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GenerateComplianceReportDetails(object):
    """
    Request to generate compliance report for the fleet.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new GenerateComplianceReportDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param are_details_required:
            The value to assign to the are_details_required property of this GenerateComplianceReportDetails.
        :type are_details_required: str

        """
        self.swagger_types = {
            'are_details_required': 'str'
        }

        self.attribute_map = {
            'are_details_required': 'areDetailsRequired'
        }

        self._are_details_required = None

    @property
    def are_details_required(self):
        """
        Gets the are_details_required of this GenerateComplianceReportDetails.
        A value that specifies if compliance details are required at the target level also?
        Allowed values are N and Y.


        :return: The are_details_required of this GenerateComplianceReportDetails.
        :rtype: str
        """
        return self._are_details_required

    @are_details_required.setter
    def are_details_required(self, are_details_required):
        """
        Sets the are_details_required of this GenerateComplianceReportDetails.
        A value that specifies if compliance details are required at the target level also?
        Allowed values are N and Y.


        :param are_details_required: The are_details_required of this GenerateComplianceReportDetails.
        :type: str
        """
        self._are_details_required = are_details_required

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
