# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230831


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ExecutionDetails(object):
    """
    Execution details.
    """

    #: A constant which can be used with the execution_type property of a ExecutionDetails.
    #: This constant has a value of "SCRIPT"
    EXECUTION_TYPE_SCRIPT = "SCRIPT"

    #: A constant which can be used with the execution_type property of a ExecutionDetails.
    #: This constant has a value of "API"
    EXECUTION_TYPE_API = "API"

    def __init__(self, **kwargs):
        """
        Initializes a new ExecutionDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.fleet_apps_management.models.ScriptBasedExecutionDetails`
        * :class:`~oci.fleet_apps_management.models.ApiBasedExecutionDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param execution_type:
            The value to assign to the execution_type property of this ExecutionDetails.
            Allowed values for this property are: "SCRIPT", "API", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type execution_type: str

        """
        self.swagger_types = {
            'execution_type': 'str'
        }

        self.attribute_map = {
            'execution_type': 'executionType'
        }

        self._execution_type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['executionType']

        if type == 'SCRIPT':
            return 'ScriptBasedExecutionDetails'

        if type == 'API':
            return 'ApiBasedExecutionDetails'
        else:
            return 'ExecutionDetails'

    @property
    def execution_type(self):
        """
        **[Required]** Gets the execution_type of this ExecutionDetails.
        The action type of the task

        Allowed values for this property are: "SCRIPT", "API", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The execution_type of this ExecutionDetails.
        :rtype: str
        """
        return self._execution_type

    @execution_type.setter
    def execution_type(self, execution_type):
        """
        Sets the execution_type of this ExecutionDetails.
        The action type of the task


        :param execution_type: The execution_type of this ExecutionDetails.
        :type: str
        """
        allowed_values = ["SCRIPT", "API"]
        if not value_allowed_none_or_none_sentinel(execution_type, allowed_values):
            execution_type = 'UNKNOWN_ENUM_VALUE'
        self._execution_type = execution_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
