# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230831


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class EntityExecutionDetails(object):
    """
    Resource level execution status and target associations.
    """

    #: A constant which can be used with the status property of a EntityExecutionDetails.
    #: This constant has a value of "ACCEPTED"
    STATUS_ACCEPTED = "ACCEPTED"

    #: A constant which can be used with the status property of a EntityExecutionDetails.
    #: This constant has a value of "WAITING"
    STATUS_WAITING = "WAITING"

    #: A constant which can be used with the status property of a EntityExecutionDetails.
    #: This constant has a value of "IN_PROGRESS"
    STATUS_IN_PROGRESS = "IN_PROGRESS"

    #: A constant which can be used with the status property of a EntityExecutionDetails.
    #: This constant has a value of "FAILED"
    STATUS_FAILED = "FAILED"

    #: A constant which can be used with the status property of a EntityExecutionDetails.
    #: This constant has a value of "SUCCEEDED"
    STATUS_SUCCEEDED = "SUCCEEDED"

    #: A constant which can be used with the status property of a EntityExecutionDetails.
    #: This constant has a value of "CANCELED"
    STATUS_CANCELED = "CANCELED"

    #: A constant which can be used with the status property of a EntityExecutionDetails.
    #: This constant has a value of "SKIPPED"
    STATUS_SKIPPED = "SKIPPED"

    #: A constant which can be used with the status property of a EntityExecutionDetails.
    #: This constant has a value of "IGNORED"
    STATUS_IGNORED = "IGNORED"

    #: A constant which can be used with the status property of a EntityExecutionDetails.
    #: This constant has a value of "NOT_APPLICABLE"
    STATUS_NOT_APPLICABLE = "NOT_APPLICABLE"

    #: A constant which can be used with the status property of a EntityExecutionDetails.
    #: This constant has a value of "ABORTED"
    STATUS_ABORTED = "ABORTED"

    #: A constant which can be used with the status property of a EntityExecutionDetails.
    #: This constant has a value of "TIMED_OUT"
    STATUS_TIMED_OUT = "TIMED_OUT"

    #: A constant which can be used with the status property of a EntityExecutionDetails.
    #: This constant has a value of "PAUSED"
    STATUS_PAUSED = "PAUSED"

    def __init__(self, **kwargs):
        """
        Initializes a new EntityExecutionDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param resource_id:
            The value to assign to the resource_id property of this EntityExecutionDetails.
        :type resource_id: str

        :param resource_display_name:
            The value to assign to the resource_display_name property of this EntityExecutionDetails.
        :type resource_display_name: str

        :param description:
            The value to assign to the description property of this EntityExecutionDetails.
        :type description: str

        :param sequence:
            The value to assign to the sequence property of this EntityExecutionDetails.
        :type sequence: str

        :param targets:
            The value to assign to the targets property of this EntityExecutionDetails.
        :type targets: list[oci.fleet_apps_management.models.ActivityResourceTarget]

        :param status:
            The value to assign to the status property of this EntityExecutionDetails.
            Allowed values for this property are: "ACCEPTED", "WAITING", "IN_PROGRESS", "FAILED", "SUCCEEDED", "CANCELED", "SKIPPED", "IGNORED", "NOT_APPLICABLE", "ABORTED", "TIMED_OUT", "PAUSED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type status: str

        :param time_started:
            The value to assign to the time_started property of this EntityExecutionDetails.
        :type time_started: datetime

        :param time_ended:
            The value to assign to the time_ended property of this EntityExecutionDetails.
        :type time_ended: datetime

        """
        self.swagger_types = {
            'resource_id': 'str',
            'resource_display_name': 'str',
            'description': 'str',
            'sequence': 'str',
            'targets': 'list[ActivityResourceTarget]',
            'status': 'str',
            'time_started': 'datetime',
            'time_ended': 'datetime'
        }

        self.attribute_map = {
            'resource_id': 'resourceId',
            'resource_display_name': 'resourceDisplayName',
            'description': 'description',
            'sequence': 'sequence',
            'targets': 'targets',
            'status': 'status',
            'time_started': 'timeStarted',
            'time_ended': 'timeEnded'
        }

        self._resource_id = None
        self._resource_display_name = None
        self._description = None
        self._sequence = None
        self._targets = None
        self._status = None
        self._time_started = None
        self._time_ended = None

    @property
    def resource_id(self):
        """
        **[Required]** Gets the resource_id of this EntityExecutionDetails.
        Resource Identifier associated with the Work Request.


        :return: The resource_id of this EntityExecutionDetails.
        :rtype: str
        """
        return self._resource_id

    @resource_id.setter
    def resource_id(self, resource_id):
        """
        Sets the resource_id of this EntityExecutionDetails.
        Resource Identifier associated with the Work Request.


        :param resource_id: The resource_id of this EntityExecutionDetails.
        :type: str
        """
        self._resource_id = resource_id

    @property
    def resource_display_name(self):
        """
        Gets the resource_display_name of this EntityExecutionDetails.
        Resource Display Name.


        :return: The resource_display_name of this EntityExecutionDetails.
        :rtype: str
        """
        return self._resource_display_name

    @resource_display_name.setter
    def resource_display_name(self, resource_display_name):
        """
        Sets the resource_display_name of this EntityExecutionDetails.
        Resource Display Name.


        :param resource_display_name: The resource_display_name of this EntityExecutionDetails.
        :type: str
        """
        self._resource_display_name = resource_display_name

    @property
    def description(self):
        """
        Gets the description of this EntityExecutionDetails.
        Description of the Resource Execution status.
        If there are any errors, this can also include a short error message.


        :return: The description of this EntityExecutionDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this EntityExecutionDetails.
        Description of the Resource Execution status.
        If there are any errors, this can also include a short error message.


        :param description: The description of this EntityExecutionDetails.
        :type: str
        """
        self._description = description

    @property
    def sequence(self):
        """
        Gets the sequence of this EntityExecutionDetails.
        The sequence of the Resource.


        :return: The sequence of this EntityExecutionDetails.
        :rtype: str
        """
        return self._sequence

    @sequence.setter
    def sequence(self, sequence):
        """
        Sets the sequence of this EntityExecutionDetails.
        The sequence of the Resource.


        :param sequence: The sequence of this EntityExecutionDetails.
        :type: str
        """
        self._sequence = sequence

    @property
    def targets(self):
        """
        Gets the targets of this EntityExecutionDetails.
        Targets associated with the resource.


        :return: The targets of this EntityExecutionDetails.
        :rtype: list[oci.fleet_apps_management.models.ActivityResourceTarget]
        """
        return self._targets

    @targets.setter
    def targets(self, targets):
        """
        Sets the targets of this EntityExecutionDetails.
        Targets associated with the resource.


        :param targets: The targets of this EntityExecutionDetails.
        :type: list[oci.fleet_apps_management.models.ActivityResourceTarget]
        """
        self._targets = targets

    @property
    def status(self):
        """
        **[Required]** Gets the status of this EntityExecutionDetails.
        Status of the Job at Resource Level.

        Allowed values for this property are: "ACCEPTED", "WAITING", "IN_PROGRESS", "FAILED", "SUCCEEDED", "CANCELED", "SKIPPED", "IGNORED", "NOT_APPLICABLE", "ABORTED", "TIMED_OUT", "PAUSED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The status of this EntityExecutionDetails.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this EntityExecutionDetails.
        Status of the Job at Resource Level.


        :param status: The status of this EntityExecutionDetails.
        :type: str
        """
        allowed_values = ["ACCEPTED", "WAITING", "IN_PROGRESS", "FAILED", "SUCCEEDED", "CANCELED", "SKIPPED", "IGNORED", "NOT_APPLICABLE", "ABORTED", "TIMED_OUT", "PAUSED"]
        if not value_allowed_none_or_none_sentinel(status, allowed_values):
            status = 'UNKNOWN_ENUM_VALUE'
        self._status = status

    @property
    def time_started(self):
        """
        Gets the time_started of this EntityExecutionDetails.
        The time the task started for the resource. An RFC3339 formatted datetime string


        :return: The time_started of this EntityExecutionDetails.
        :rtype: datetime
        """
        return self._time_started

    @time_started.setter
    def time_started(self, time_started):
        """
        Sets the time_started of this EntityExecutionDetails.
        The time the task started for the resource. An RFC3339 formatted datetime string


        :param time_started: The time_started of this EntityExecutionDetails.
        :type: datetime
        """
        self._time_started = time_started

    @property
    def time_ended(self):
        """
        Gets the time_ended of this EntityExecutionDetails.
        The time the task ended for the resource. An RFC3339 formatted datetime string


        :return: The time_ended of this EntityExecutionDetails.
        :rtype: datetime
        """
        return self._time_ended

    @time_ended.setter
    def time_ended(self, time_ended):
        """
        Sets the time_ended of this EntityExecutionDetails.
        The time the task ended for the resource. An RFC3339 formatted datetime string


        :param time_ended: The time_ended of this EntityExecutionDetails.
        :type: datetime
        """
        self._time_ended = time_ended

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
