# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230831


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreatePlatformConfigurationDetails(object):
    """
    The information about new PlatformConfiguration.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreatePlatformConfigurationDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this CreatePlatformConfigurationDetails.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this CreatePlatformConfigurationDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this CreatePlatformConfigurationDetails.
        :type description: str

        :param config_category_details:
            The value to assign to the config_category_details property of this CreatePlatformConfigurationDetails.
        :type config_category_details: oci.fleet_apps_management.models.ConfigCategoryDetails

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'display_name': 'str',
            'description': 'str',
            'config_category_details': 'ConfigCategoryDetails'
        }

        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'description': 'description',
            'config_category_details': 'configCategoryDetails'
        }

        self._compartment_id = None
        self._display_name = None
        self._description = None
        self._config_category_details = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreatePlatformConfigurationDetails.
        Tenancy OCID


        :return: The compartment_id of this CreatePlatformConfigurationDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreatePlatformConfigurationDetails.
        Tenancy OCID


        :param compartment_id: The compartment_id of this CreatePlatformConfigurationDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def display_name(self):
        """
        Gets the display_name of this CreatePlatformConfigurationDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Example: `My new resource`


        :return: The display_name of this CreatePlatformConfigurationDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreatePlatformConfigurationDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Example: `My new resource`


        :param display_name: The display_name of this CreatePlatformConfigurationDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this CreatePlatformConfigurationDetails.
        A user-friendly description. To provide some insight about the resource.
        Avoid entering confidential information.


        :return: The description of this CreatePlatformConfigurationDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreatePlatformConfigurationDetails.
        A user-friendly description. To provide some insight about the resource.
        Avoid entering confidential information.


        :param description: The description of this CreatePlatformConfigurationDetails.
        :type: str
        """
        self._description = description

    @property
    def config_category_details(self):
        """
        **[Required]** Gets the config_category_details of this CreatePlatformConfigurationDetails.

        :return: The config_category_details of this CreatePlatformConfigurationDetails.
        :rtype: oci.fleet_apps_management.models.ConfigCategoryDetails
        """
        return self._config_category_details

    @config_category_details.setter
    def config_category_details(self, config_category_details):
        """
        Sets the config_category_details of this CreatePlatformConfigurationDetails.

        :param config_category_details: The config_category_details of this CreatePlatformConfigurationDetails.
        :type: oci.fleet_apps_management.models.ConfigCategoryDetails
        """
        self._config_category_details = config_category_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
