# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230831


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Condition(object):
    """
    Rule condition
    """

    def __init__(self, **kwargs):
        """
        Initializes a new Condition object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param attr_group:
            The value to assign to the attr_group property of this Condition.
        :type attr_group: str

        :param attr_key:
            The value to assign to the attr_key property of this Condition.
        :type attr_key: str

        :param attr_value:
            The value to assign to the attr_value property of this Condition.
        :type attr_value: str

        """
        self.swagger_types = {
            'attr_group': 'str',
            'attr_key': 'str',
            'attr_value': 'str'
        }

        self.attribute_map = {
            'attr_group': 'attrGroup',
            'attr_key': 'attrKey',
            'attr_value': 'attrValue'
        }

        self._attr_group = None
        self._attr_key = None
        self._attr_value = None

    @property
    def attr_group(self):
        """
        **[Required]** Gets the attr_group of this Condition.
        Attribute Group. Provide a Tag namespace if the rule is based on a tag.
        Provide resource type if the rule is based on a resource property.


        :return: The attr_group of this Condition.
        :rtype: str
        """
        return self._attr_group

    @attr_group.setter
    def attr_group(self, attr_group):
        """
        Sets the attr_group of this Condition.
        Attribute Group. Provide a Tag namespace if the rule is based on a tag.
        Provide resource type if the rule is based on a resource property.


        :param attr_group: The attr_group of this Condition.
        :type: str
        """
        self._attr_group = attr_group

    @property
    def attr_key(self):
        """
        **[Required]** Gets the attr_key of this Condition.
        Attribute Key.Provide Tag key if the rule is based on a tag.
        Provide resource property name if the rule is based on a resource property.


        :return: The attr_key of this Condition.
        :rtype: str
        """
        return self._attr_key

    @attr_key.setter
    def attr_key(self, attr_key):
        """
        Sets the attr_key of this Condition.
        Attribute Key.Provide Tag key if the rule is based on a tag.
        Provide resource property name if the rule is based on a resource property.


        :param attr_key: The attr_key of this Condition.
        :type: str
        """
        self._attr_key = attr_key

    @property
    def attr_value(self):
        """
        **[Required]** Gets the attr_value of this Condition.
        Attribute Value.Provide Tag value if the rule is based on a tag.
        Provide resource property value if the rule is based on a resource property.


        :return: The attr_value of this Condition.
        :rtype: str
        """
        return self._attr_value

    @attr_value.setter
    def attr_value(self, attr_value):
        """
        Sets the attr_value of this Condition.
        Attribute Value.Provide Tag value if the rule is based on a tag.
        Provide resource property value if the rule is based on a resource property.


        :param attr_value: The attr_value of this Condition.
        :type: str
        """
        self._attr_value = attr_value

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
