# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230831


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ComplianceReport(object):
    """
    Compliance details for a fleet in Fleet Application Management.
    """

    #: A constant which can be used with the compliance_state property of a ComplianceReport.
    #: This constant has a value of "UNKNOWN"
    COMPLIANCE_STATE_UNKNOWN = "UNKNOWN"

    #: A constant which can be used with the compliance_state property of a ComplianceReport.
    #: This constant has a value of "COMPLIANT"
    COMPLIANCE_STATE_COMPLIANT = "COMPLIANT"

    #: A constant which can be used with the compliance_state property of a ComplianceReport.
    #: This constant has a value of "NON_COMPLIANT"
    COMPLIANCE_STATE_NON_COMPLIANT = "NON_COMPLIANT"

    #: A constant which can be used with the compliance_state property of a ComplianceReport.
    #: This constant has a value of "WARNING"
    COMPLIANCE_STATE_WARNING = "WARNING"

    def __init__(self, **kwargs):
        """
        Initializes a new ComplianceReport object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this ComplianceReport.
        :type id: str

        :param fleet_id:
            The value to assign to the fleet_id property of this ComplianceReport.
        :type fleet_id: str

        :param compliance_state:
            The value to assign to the compliance_state property of this ComplianceReport.
            Allowed values for this property are: "UNKNOWN", "COMPLIANT", "NON_COMPLIANT", "WARNING", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type compliance_state: str

        :param resources:
            The value to assign to the resources property of this ComplianceReport.
        :type resources: list[oci.fleet_apps_management.models.ComplianceReportResource]

        """
        self.swagger_types = {
            'id': 'str',
            'fleet_id': 'str',
            'compliance_state': 'str',
            'resources': 'list[ComplianceReportResource]'
        }

        self.attribute_map = {
            'id': 'id',
            'fleet_id': 'fleetId',
            'compliance_state': 'complianceState',
            'resources': 'resources'
        }

        self._id = None
        self._fleet_id = None
        self._compliance_state = None
        self._resources = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this ComplianceReport.
        Compliance Report Identifier


        :return: The id of this ComplianceReport.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ComplianceReport.
        Compliance Report Identifier


        :param id: The id of this ComplianceReport.
        :type: str
        """
        self._id = id

    @property
    def fleet_id(self):
        """
        **[Required]** Gets the fleet_id of this ComplianceReport.
        The fleet OCID.


        :return: The fleet_id of this ComplianceReport.
        :rtype: str
        """
        return self._fleet_id

    @fleet_id.setter
    def fleet_id(self, fleet_id):
        """
        Sets the fleet_id of this ComplianceReport.
        The fleet OCID.


        :param fleet_id: The fleet_id of this ComplianceReport.
        :type: str
        """
        self._fleet_id = fleet_id

    @property
    def compliance_state(self):
        """
        **[Required]** Gets the compliance_state of this ComplianceReport.
        The last known compliance state of the fleet.

        Allowed values for this property are: "UNKNOWN", "COMPLIANT", "NON_COMPLIANT", "WARNING", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The compliance_state of this ComplianceReport.
        :rtype: str
        """
        return self._compliance_state

    @compliance_state.setter
    def compliance_state(self, compliance_state):
        """
        Sets the compliance_state of this ComplianceReport.
        The last known compliance state of the fleet.


        :param compliance_state: The compliance_state of this ComplianceReport.
        :type: str
        """
        allowed_values = ["UNKNOWN", "COMPLIANT", "NON_COMPLIANT", "WARNING"]
        if not value_allowed_none_or_none_sentinel(compliance_state, allowed_values):
            compliance_state = 'UNKNOWN_ENUM_VALUE'
        self._compliance_state = compliance_state

    @property
    def resources(self):
        """
        Gets the resources of this ComplianceReport.
        Resources associated with the Fleet.


        :return: The resources of this ComplianceReport.
        :rtype: list[oci.fleet_apps_management.models.ComplianceReportResource]
        """
        return self._resources

    @resources.setter
    def resources(self, resources):
        """
        Sets the resources of this ComplianceReport.
        Resources associated with the Fleet.


        :param resources: The resources of this ComplianceReport.
        :type: list[oci.fleet_apps_management.models.ComplianceReportResource]
        """
        self._resources = resources

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
