# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230831


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AnnouncementSummary(object):
    """
    A summary of announcements for Fleet Application Management.
    """

    #: A constant which can be used with the lifecycle_state property of a AnnouncementSummary.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a AnnouncementSummary.
    #: This constant has a value of "INACTIVE"
    LIFECYCLE_STATE_INACTIVE = "INACTIVE"

    #: A constant which can be used with the lifecycle_state property of a AnnouncementSummary.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a AnnouncementSummary.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new AnnouncementSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this AnnouncementSummary.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this AnnouncementSummary.
        :type compartment_id: str

        :param resource_region:
            The value to assign to the resource_region property of this AnnouncementSummary.
        :type resource_region: str

        :param display_name:
            The value to assign to the display_name property of this AnnouncementSummary.
        :type display_name: str

        :param description:
            The value to assign to the description property of this AnnouncementSummary.
        :type description: str

        :param time_created:
            The value to assign to the time_created property of this AnnouncementSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this AnnouncementSummary.
        :type time_updated: datetime

        :param type:
            The value to assign to the type property of this AnnouncementSummary.
        :type type: str

        :param summary:
            The value to assign to the summary property of this AnnouncementSummary.
        :type summary: str

        :param details:
            The value to assign to the details property of this AnnouncementSummary.
        :type details: str

        :param url:
            The value to assign to the url property of this AnnouncementSummary.
        :type url: str

        :param announcement_start:
            The value to assign to the announcement_start property of this AnnouncementSummary.
        :type announcement_start: datetime

        :param announcement_end:
            The value to assign to the announcement_end property of this AnnouncementSummary.
        :type announcement_end: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this AnnouncementSummary.
            Allowed values for this property are: "ACTIVE", "INACTIVE", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this AnnouncementSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this AnnouncementSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this AnnouncementSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'resource_region': 'str',
            'display_name': 'str',
            'description': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'type': 'str',
            'summary': 'str',
            'details': 'str',
            'url': 'str',
            'announcement_start': 'datetime',
            'announcement_end': 'datetime',
            'lifecycle_state': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'resource_region': 'resourceRegion',
            'display_name': 'displayName',
            'description': 'description',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'type': 'type',
            'summary': 'summary',
            'details': 'details',
            'url': 'url',
            'announcement_start': 'announcementStart',
            'announcement_end': 'announcementEnd',
            'lifecycle_state': 'lifecycleState',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }

        self._id = None
        self._compartment_id = None
        self._resource_region = None
        self._display_name = None
        self._description = None
        self._time_created = None
        self._time_updated = None
        self._type = None
        self._summary = None
        self._details = None
        self._url = None
        self._announcement_start = None
        self._announcement_end = None
        self._lifecycle_state = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this AnnouncementSummary.
        The OCID of the resource.


        :return: The id of this AnnouncementSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this AnnouncementSummary.
        The OCID of the resource.


        :param id: The id of this AnnouncementSummary.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this AnnouncementSummary.
        Tenancy OCID


        :return: The compartment_id of this AnnouncementSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this AnnouncementSummary.
        Tenancy OCID


        :param compartment_id: The compartment_id of this AnnouncementSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def resource_region(self):
        """
        Gets the resource_region of this AnnouncementSummary.
        Associated region


        :return: The resource_region of this AnnouncementSummary.
        :rtype: str
        """
        return self._resource_region

    @resource_region.setter
    def resource_region(self, resource_region):
        """
        Sets the resource_region of this AnnouncementSummary.
        Associated region


        :param resource_region: The resource_region of this AnnouncementSummary.
        :type: str
        """
        self._resource_region = resource_region

    @property
    def display_name(self):
        """
        Gets the display_name of this AnnouncementSummary.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Example: `My new resource`


        :return: The display_name of this AnnouncementSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this AnnouncementSummary.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Example: `My new resource`


        :param display_name: The display_name of this AnnouncementSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this AnnouncementSummary.
        A user-friendly description. To provide some insight about the resource.
        Avoid entering confidential information.


        :return: The description of this AnnouncementSummary.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this AnnouncementSummary.
        A user-friendly description. To provide some insight about the resource.
        Avoid entering confidential information.


        :param description: The description of this AnnouncementSummary.
        :type: str
        """
        self._description = description

    @property
    def time_created(self):
        """
        Gets the time_created of this AnnouncementSummary.
        The time this resource was created. An RFC3339 formatted datetime string.


        :return: The time_created of this AnnouncementSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this AnnouncementSummary.
        The time this resource was created. An RFC3339 formatted datetime string.


        :param time_created: The time_created of this AnnouncementSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this AnnouncementSummary.
        The time this resource was last updated. An RFC3339 formatted datetime string.


        :return: The time_updated of this AnnouncementSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this AnnouncementSummary.
        The time this resource was last updated. An RFC3339 formatted datetime string.


        :param time_updated: The time_updated of this AnnouncementSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def type(self):
        """
        **[Required]** Gets the type of this AnnouncementSummary.
        Type of announcement.


        :return: The type of this AnnouncementSummary.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this AnnouncementSummary.
        Type of announcement.


        :param type: The type of this AnnouncementSummary.
        :type: str
        """
        self._type = type

    @property
    def summary(self):
        """
        **[Required]** Gets the summary of this AnnouncementSummary.
        Summary of the announcement.


        :return: The summary of this AnnouncementSummary.
        :rtype: str
        """
        return self._summary

    @summary.setter
    def summary(self, summary):
        """
        Sets the summary of this AnnouncementSummary.
        Summary of the announcement.


        :param summary: The summary of this AnnouncementSummary.
        :type: str
        """
        self._summary = summary

    @property
    def details(self):
        """
        Gets the details of this AnnouncementSummary.
        Announcement Details.


        :return: The details of this AnnouncementSummary.
        :rtype: str
        """
        return self._details

    @details.setter
    def details(self, details):
        """
        Sets the details of this AnnouncementSummary.
        Announcement Details.


        :param details: The details of this AnnouncementSummary.
        :type: str
        """
        self._details = details

    @property
    def url(self):
        """
        Gets the url of this AnnouncementSummary.
        URL to the announcement.


        :return: The url of this AnnouncementSummary.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """
        Sets the url of this AnnouncementSummary.
        URL to the announcement.


        :param url: The url of this AnnouncementSummary.
        :type: str
        """
        self._url = url

    @property
    def announcement_start(self):
        """
        **[Required]** Gets the announcement_start of this AnnouncementSummary.
        Announcement start date.


        :return: The announcement_start of this AnnouncementSummary.
        :rtype: datetime
        """
        return self._announcement_start

    @announcement_start.setter
    def announcement_start(self, announcement_start):
        """
        Sets the announcement_start of this AnnouncementSummary.
        Announcement start date.


        :param announcement_start: The announcement_start of this AnnouncementSummary.
        :type: datetime
        """
        self._announcement_start = announcement_start

    @property
    def announcement_end(self):
        """
        **[Required]** Gets the announcement_end of this AnnouncementSummary.
        Announcement end date


        :return: The announcement_end of this AnnouncementSummary.
        :rtype: datetime
        """
        return self._announcement_end

    @announcement_end.setter
    def announcement_end(self, announcement_end):
        """
        Sets the announcement_end of this AnnouncementSummary.
        Announcement end date


        :param announcement_end: The announcement_end of this AnnouncementSummary.
        :type: datetime
        """
        self._announcement_end = announcement_end

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this AnnouncementSummary.
        The lifecycle state of the announcement.

        Allowed values for this property are: "ACTIVE", "INACTIVE", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this AnnouncementSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this AnnouncementSummary.
        The lifecycle state of the announcement.


        :param lifecycle_state: The lifecycle_state of this AnnouncementSummary.
        :type: str
        """
        allowed_values = ["ACTIVE", "INACTIVE", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this AnnouncementSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this AnnouncementSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this AnnouncementSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this AnnouncementSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this AnnouncementSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this AnnouncementSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this AnnouncementSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this AnnouncementSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this AnnouncementSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this AnnouncementSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this AnnouncementSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this AnnouncementSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
