# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20171215

from .create_outbound_connector_details import CreateOutboundConnectorDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateLdapBindAccountDetails(CreateOutboundConnectorDetails):
    """
    Account details for the LDAP bind account to be used by mount targets that use this outbound connector.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateLdapBindAccountDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.file_storage.models.CreateLdapBindAccountDetails.connector_type` attribute
        of this class is ``LDAPBIND`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param availability_domain:
            The value to assign to the availability_domain property of this CreateLdapBindAccountDetails.
        :type availability_domain: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateLdapBindAccountDetails.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this CreateLdapBindAccountDetails.
        :type display_name: str

        :param connector_type:
            The value to assign to the connector_type property of this CreateLdapBindAccountDetails.
        :type connector_type: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateLdapBindAccountDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateLdapBindAccountDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param locks:
            The value to assign to the locks property of this CreateLdapBindAccountDetails.
        :type locks: list[oci.file_storage.models.ResourceLock]

        :param endpoints:
            The value to assign to the endpoints property of this CreateLdapBindAccountDetails.
        :type endpoints: list[oci.file_storage.models.Endpoint]

        :param bind_distinguished_name:
            The value to assign to the bind_distinguished_name property of this CreateLdapBindAccountDetails.
        :type bind_distinguished_name: str

        :param password_secret_id:
            The value to assign to the password_secret_id property of this CreateLdapBindAccountDetails.
        :type password_secret_id: str

        :param password_secret_version:
            The value to assign to the password_secret_version property of this CreateLdapBindAccountDetails.
        :type password_secret_version: int

        """
        self.swagger_types = {
            'availability_domain': 'str',
            'compartment_id': 'str',
            'display_name': 'str',
            'connector_type': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'locks': 'list[ResourceLock]',
            'endpoints': 'list[Endpoint]',
            'bind_distinguished_name': 'str',
            'password_secret_id': 'str',
            'password_secret_version': 'int'
        }

        self.attribute_map = {
            'availability_domain': 'availabilityDomain',
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'connector_type': 'connectorType',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'locks': 'locks',
            'endpoints': 'endpoints',
            'bind_distinguished_name': 'bindDistinguishedName',
            'password_secret_id': 'passwordSecretId',
            'password_secret_version': 'passwordSecretVersion'
        }

        self._availability_domain = None
        self._compartment_id = None
        self._display_name = None
        self._connector_type = None
        self._freeform_tags = None
        self._defined_tags = None
        self._locks = None
        self._endpoints = None
        self._bind_distinguished_name = None
        self._password_secret_id = None
        self._password_secret_version = None
        self._connector_type = 'LDAPBIND'

    @property
    def endpoints(self):
        """
        **[Required]** Gets the endpoints of this CreateLdapBindAccountDetails.
        Array of server endpoints to use when connecting with the LDAP bind account.


        :return: The endpoints of this CreateLdapBindAccountDetails.
        :rtype: list[oci.file_storage.models.Endpoint]
        """
        return self._endpoints

    @endpoints.setter
    def endpoints(self, endpoints):
        """
        Sets the endpoints of this CreateLdapBindAccountDetails.
        Array of server endpoints to use when connecting with the LDAP bind account.


        :param endpoints: The endpoints of this CreateLdapBindAccountDetails.
        :type: list[oci.file_storage.models.Endpoint]
        """
        self._endpoints = endpoints

    @property
    def bind_distinguished_name(self):
        """
        **[Required]** Gets the bind_distinguished_name of this CreateLdapBindAccountDetails.
        The LDAP Distinguished Name of the bind account.


        :return: The bind_distinguished_name of this CreateLdapBindAccountDetails.
        :rtype: str
        """
        return self._bind_distinguished_name

    @bind_distinguished_name.setter
    def bind_distinguished_name(self, bind_distinguished_name):
        """
        Sets the bind_distinguished_name of this CreateLdapBindAccountDetails.
        The LDAP Distinguished Name of the bind account.


        :param bind_distinguished_name: The bind_distinguished_name of this CreateLdapBindAccountDetails.
        :type: str
        """
        self._bind_distinguished_name = bind_distinguished_name

    @property
    def password_secret_id(self):
        """
        Gets the password_secret_id of this CreateLdapBindAccountDetails.
        The `OCID`__ of the password for the LDAP bind account in the Vault.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The password_secret_id of this CreateLdapBindAccountDetails.
        :rtype: str
        """
        return self._password_secret_id

    @password_secret_id.setter
    def password_secret_id(self, password_secret_id):
        """
        Sets the password_secret_id of this CreateLdapBindAccountDetails.
        The `OCID`__ of the password for the LDAP bind account in the Vault.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param password_secret_id: The password_secret_id of this CreateLdapBindAccountDetails.
        :type: str
        """
        self._password_secret_id = password_secret_id

    @property
    def password_secret_version(self):
        """
        Gets the password_secret_version of this CreateLdapBindAccountDetails.
        Version of the password secret in the Vault to use.


        :return: The password_secret_version of this CreateLdapBindAccountDetails.
        :rtype: int
        """
        return self._password_secret_version

    @password_secret_version.setter
    def password_secret_version(self, password_secret_version):
        """
        Sets the password_secret_version of this CreateLdapBindAccountDetails.
        Version of the password secret in the Vault to use.


        :param password_secret_version: The password_secret_version of this CreateLdapBindAccountDetails.
        :type: int
        """
        self._password_secret_version = password_secret_version

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
