# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220926


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Recipients(object):
    """
    The destination for the email, composed of To, CC, and BCC fields.
    NOTE: At least one of To, CC, and BCC must be provided. And max 50 recipients are allowed across the To:, CC: and BCC: fields.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new Recipients object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param to:
            The value to assign to the to property of this Recipients.
        :type to: list[oci.email_data_plane.models.EmailAddress]

        :param cc:
            The value to assign to the cc property of this Recipients.
        :type cc: list[oci.email_data_plane.models.EmailAddress]

        :param bcc:
            The value to assign to the bcc property of this Recipients.
        :type bcc: list[oci.email_data_plane.models.EmailAddress]

        """
        self.swagger_types = {
            'to': 'list[EmailAddress]',
            'cc': 'list[EmailAddress]',
            'bcc': 'list[EmailAddress]'
        }

        self.attribute_map = {
            'to': 'to',
            'cc': 'cc',
            'bcc': 'bcc'
        }

        self._to = None
        self._cc = None
        self._bcc = None

    @property
    def to(self):
        """
        Gets the to of this Recipients.
        Array of To address.


        :return: The to of this Recipients.
        :rtype: list[oci.email_data_plane.models.EmailAddress]
        """
        return self._to

    @to.setter
    def to(self, to):
        """
        Sets the to of this Recipients.
        Array of To address.


        :param to: The to of this Recipients.
        :type: list[oci.email_data_plane.models.EmailAddress]
        """
        self._to = to

    @property
    def cc(self):
        """
        Gets the cc of this Recipients.
        Array of CC address.


        :return: The cc of this Recipients.
        :rtype: list[oci.email_data_plane.models.EmailAddress]
        """
        return self._cc

    @cc.setter
    def cc(self, cc):
        """
        Sets the cc of this Recipients.
        Array of CC address.


        :param cc: The cc of this Recipients.
        :type: list[oci.email_data_plane.models.EmailAddress]
        """
        self._cc = cc

    @property
    def bcc(self):
        """
        Gets the bcc of this Recipients.
        Array of BCC address. Bcc headers can only be viewed by non bcc recipients.


        :return: The bcc of this Recipients.
        :rtype: list[oci.email_data_plane.models.EmailAddress]
        """
        return self._bcc

    @bcc.setter
    def bcc(self, bcc):
        """
        Sets the bcc of this Recipients.
        Array of BCC address. Bcc headers can only be viewed by non bcc recipients.


        :param bcc: The bcc of this Recipients.
        :type: list[oci.email_data_plane.models.EmailAddress]
        """
        self._bcc = bcc

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
