# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210630

from .stage_output import StageOutput
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class TestReportOutput(StageOutput):
    """
    Details of test report generated via pipeline run
    """

    def __init__(self, **kwargs):
        """
        Initializes a new TestReportOutput object with values from keyword arguments. The default value of the :py:attr:`~oci.devops.models.TestReportOutput.output_type` attribute
        of this class is ``TEST_REPORT`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param output_type:
            The value to assign to the output_type property of this TestReportOutput.
            Allowed values for this property are: "ARTIFACT", "TEST_REPORT"
        :type output_type: str

        :param step_name:
            The value to assign to the step_name property of this TestReportOutput.
        :type step_name: str

        :param id:
            The value to assign to the id property of this TestReportOutput.
        :type id: str

        """
        self.swagger_types = {
            'output_type': 'str',
            'step_name': 'str',
            'id': 'str'
        }

        self.attribute_map = {
            'output_type': 'outputType',
            'step_name': 'stepName',
            'id': 'id'
        }

        self._output_type = None
        self._step_name = None
        self._id = None
        self._output_type = 'TEST_REPORT'

    @property
    def id(self):
        """
        **[Required]** Gets the id of this TestReportOutput.
        The OCID of the test report.


        :return: The id of this TestReportOutput.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this TestReportOutput.
        The OCID of the test report.


        :param id: The id of this TestReportOutput.
        :type: str
        """
        self._id = id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
