# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class StageOutput(object):
    """
    Details of the generated artifact or report.
    """

    #: A constant which can be used with the output_type property of a StageOutput.
    #: This constant has a value of "ARTIFACT"
    OUTPUT_TYPE_ARTIFACT = "ARTIFACT"

    #: A constant which can be used with the output_type property of a StageOutput.
    #: This constant has a value of "TEST_REPORT"
    OUTPUT_TYPE_TEST_REPORT = "TEST_REPORT"

    def __init__(self, **kwargs):
        """
        Initializes a new StageOutput object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.devops.models.TestReportOutput`
        * :class:`~oci.devops.models.GenericArtifacts`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param output_type:
            The value to assign to the output_type property of this StageOutput.
            Allowed values for this property are: "ARTIFACT", "TEST_REPORT"
        :type output_type: str

        :param step_name:
            The value to assign to the step_name property of this StageOutput.
        :type step_name: str

        """
        self.swagger_types = {
            'output_type': 'str',
            'step_name': 'str'
        }

        self.attribute_map = {
            'output_type': 'outputType',
            'step_name': 'stepName'
        }

        self._output_type = None
        self._step_name = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['outputType']

        if type == 'TEST_REPORT':
            return 'TestReportOutput'

        if type == 'ARTIFACT':
            return 'GenericArtifacts'
        else:
            return 'StageOutput'

    @property
    def output_type(self):
        """
        **[Required]** Gets the output_type of this StageOutput.
        Type of output generated.

        Allowed values for this property are: "ARTIFACT", "TEST_REPORT"


        :return: The output_type of this StageOutput.
        :rtype: str
        """
        return self._output_type

    @output_type.setter
    def output_type(self, output_type):
        """
        Sets the output_type of this StageOutput.
        Type of output generated.


        :param output_type: The output_type of this StageOutput.
        :type: str
        """
        allowed_values = ["ARTIFACT", "TEST_REPORT"]
        if not value_allowed_none_or_none_sentinel(output_type, allowed_values):
            raise ValueError(
                f"Invalid value for `output_type`, must be None or one of {allowed_values}"
            )
        self._output_type = output_type

    @property
    def step_name(self):
        """
        **[Required]** Gets the step_name of this StageOutput.
        Name of stage step at which this output is generated.


        :return: The step_name of this StageOutput.
        :rtype: str
        """
        return self._step_name

    @step_name.setter
    def step_name(self, step_name):
        """
        Sets the step_name of this StageOutput.
        Name of stage step at which this output is generated.


        :param step_name: The step_name of this StageOutput.
        :type: str
        """
        self._step_name = step_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
