# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PullRequestNotificationPreference(object):
    """
    The notification preference of the pull request.
    """

    #: A constant which can be used with the notification_preference property of a PullRequestNotificationPreference.
    #: This constant has a value of "WATCH"
    NOTIFICATION_PREFERENCE_WATCH = "WATCH"

    #: A constant which can be used with the notification_preference property of a PullRequestNotificationPreference.
    #: This constant has a value of "IGNORE"
    NOTIFICATION_PREFERENCE_IGNORE = "IGNORE"

    #: A constant which can be used with the notification_preference property of a PullRequestNotificationPreference.
    #: This constant has a value of "MENTION"
    NOTIFICATION_PREFERENCE_MENTION = "MENTION"

    def __init__(self, **kwargs):
        """
        Initializes a new PullRequestNotificationPreference object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param pull_request_id:
            The value to assign to the pull_request_id property of this PullRequestNotificationPreference.
        :type pull_request_id: str

        :param user_id:
            The value to assign to the user_id property of this PullRequestNotificationPreference.
        :type user_id: str

        :param notification_preference:
            The value to assign to the notification_preference property of this PullRequestNotificationPreference.
            Allowed values for this property are: "WATCH", "IGNORE", "MENTION", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type notification_preference: str

        """
        self.swagger_types = {
            'pull_request_id': 'str',
            'user_id': 'str',
            'notification_preference': 'str'
        }

        self.attribute_map = {
            'pull_request_id': 'pullRequestId',
            'user_id': 'userId',
            'notification_preference': 'notificationPreference'
        }

        self._pull_request_id = None
        self._user_id = None
        self._notification_preference = None

    @property
    def pull_request_id(self):
        """
        **[Required]** Gets the pull_request_id of this PullRequestNotificationPreference.
        The ocid of pull request resource


        :return: The pull_request_id of this PullRequestNotificationPreference.
        :rtype: str
        """
        return self._pull_request_id

    @pull_request_id.setter
    def pull_request_id(self, pull_request_id):
        """
        Sets the pull_request_id of this PullRequestNotificationPreference.
        The ocid of pull request resource


        :param pull_request_id: The pull_request_id of this PullRequestNotificationPreference.
        :type: str
        """
        self._pull_request_id = pull_request_id

    @property
    def user_id(self):
        """
        **[Required]** Gets the user_id of this PullRequestNotificationPreference.
        The ocid of user.


        :return: The user_id of this PullRequestNotificationPreference.
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """
        Sets the user_id of this PullRequestNotificationPreference.
        The ocid of user.


        :param user_id: The user_id of this PullRequestNotificationPreference.
        :type: str
        """
        self._user_id = user_id

    @property
    def notification_preference(self):
        """
        **[Required]** Gets the notification_preference of this PullRequestNotificationPreference.
        The override value of pull request notification preference.

        Allowed values for this property are: "WATCH", "IGNORE", "MENTION", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The notification_preference of this PullRequestNotificationPreference.
        :rtype: str
        """
        return self._notification_preference

    @notification_preference.setter
    def notification_preference(self, notification_preference):
        """
        Sets the notification_preference of this PullRequestNotificationPreference.
        The override value of pull request notification preference.


        :param notification_preference: The notification_preference of this PullRequestNotificationPreference.
        :type: str
        """
        allowed_values = ["WATCH", "IGNORE", "MENTION"]
        if not value_allowed_none_or_none_sentinel(notification_preference, allowed_values):
            notification_preference = 'UNKNOWN_ENUM_VALUE'
        self._notification_preference = notification_preference

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
