# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PullRequestCommentSummary(object):
    """
    summary of a pullRequest comment
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PullRequestCommentSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this PullRequestCommentSummary.
        :type id: str

        :param pull_request_id:
            The value to assign to the pull_request_id property of this PullRequestCommentSummary.
        :type pull_request_id: str

        :param data:
            The value to assign to the data property of this PullRequestCommentSummary.
        :type data: str

        :param parent_id:
            The value to assign to the parent_id property of this PullRequestCommentSummary.
        :type parent_id: str

        :param file_path:
            The value to assign to the file_path property of this PullRequestCommentSummary.
        :type file_path: str

        :param commit_id:
            The value to assign to the commit_id property of this PullRequestCommentSummary.
        :type commit_id: str

        :param file_type:
            The value to assign to the file_type property of this PullRequestCommentSummary.
        :type file_type: str

        :param line_number:
            The value to assign to the line_number property of this PullRequestCommentSummary.
        :type line_number: int

        :param likes:
            The value to assign to the likes property of this PullRequestCommentSummary.
        :type likes: oci.devops.models.PullRequestCommentLikeCollection

        :param status:
            The value to assign to the status property of this PullRequestCommentSummary.
        :type status: str

        :param time_created:
            The value to assign to the time_created property of this PullRequestCommentSummary.
        :type time_created: datetime

        :param created_by:
            The value to assign to the created_by property of this PullRequestCommentSummary.
        :type created_by: oci.devops.models.PrincipalDetails

        :param time_updated:
            The value to assign to the time_updated property of this PullRequestCommentSummary.
        :type time_updated: datetime

        :param updated_by:
            The value to assign to the updated_by property of this PullRequestCommentSummary.
        :type updated_by: oci.devops.models.PrincipalDetails

        :param context_status:
            The value to assign to the context_status property of this PullRequestCommentSummary.
        :type context_status: str

        :param comment_context:
            The value to assign to the comment_context property of this PullRequestCommentSummary.
        :type comment_context: list[oci.devops.models.DiffLineDetails]

        """
        self.swagger_types = {
            'id': 'str',
            'pull_request_id': 'str',
            'data': 'str',
            'parent_id': 'str',
            'file_path': 'str',
            'commit_id': 'str',
            'file_type': 'str',
            'line_number': 'int',
            'likes': 'PullRequestCommentLikeCollection',
            'status': 'str',
            'time_created': 'datetime',
            'created_by': 'PrincipalDetails',
            'time_updated': 'datetime',
            'updated_by': 'PrincipalDetails',
            'context_status': 'str',
            'comment_context': 'list[DiffLineDetails]'
        }

        self.attribute_map = {
            'id': 'id',
            'pull_request_id': 'pullRequestId',
            'data': 'data',
            'parent_id': 'parentId',
            'file_path': 'filePath',
            'commit_id': 'commitId',
            'file_type': 'fileType',
            'line_number': 'lineNumber',
            'likes': 'likes',
            'status': 'status',
            'time_created': 'timeCreated',
            'created_by': 'createdBy',
            'time_updated': 'timeUpdated',
            'updated_by': 'updatedBy',
            'context_status': 'contextStatus',
            'comment_context': 'commentContext'
        }

        self._id = None
        self._pull_request_id = None
        self._data = None
        self._parent_id = None
        self._file_path = None
        self._commit_id = None
        self._file_type = None
        self._line_number = None
        self._likes = None
        self._status = None
        self._time_created = None
        self._created_by = None
        self._time_updated = None
        self._updated_by = None
        self._context_status = None
        self._comment_context = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this PullRequestCommentSummary.
        Unique identifier that is immutable on creation


        :return: The id of this PullRequestCommentSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this PullRequestCommentSummary.
        Unique identifier that is immutable on creation


        :param id: The id of this PullRequestCommentSummary.
        :type: str
        """
        self._id = id

    @property
    def pull_request_id(self):
        """
        **[Required]** Gets the pull_request_id of this PullRequestCommentSummary.
        OCID of the pull request that this comment belongs to


        :return: The pull_request_id of this PullRequestCommentSummary.
        :rtype: str
        """
        return self._pull_request_id

    @pull_request_id.setter
    def pull_request_id(self, pull_request_id):
        """
        Sets the pull_request_id of this PullRequestCommentSummary.
        OCID of the pull request that this comment belongs to


        :param pull_request_id: The pull_request_id of this PullRequestCommentSummary.
        :type: str
        """
        self._pull_request_id = pull_request_id

    @property
    def data(self):
        """
        **[Required]** Gets the data of this PullRequestCommentSummary.
        Content of the Comment.


        :return: The data of this PullRequestCommentSummary.
        :rtype: str
        """
        return self._data

    @data.setter
    def data(self, data):
        """
        Sets the data of this PullRequestCommentSummary.
        Content of the Comment.


        :param data: The data of this PullRequestCommentSummary.
        :type: str
        """
        self._data = data

    @property
    def parent_id(self):
        """
        Gets the parent_id of this PullRequestCommentSummary.
        ID of parent Comment


        :return: The parent_id of this PullRequestCommentSummary.
        :rtype: str
        """
        return self._parent_id

    @parent_id.setter
    def parent_id(self, parent_id):
        """
        Sets the parent_id of this PullRequestCommentSummary.
        ID of parent Comment


        :param parent_id: The parent_id of this PullRequestCommentSummary.
        :type: str
        """
        self._parent_id = parent_id

    @property
    def file_path(self):
        """
        Gets the file_path of this PullRequestCommentSummary.
        File path in the commit


        :return: The file_path of this PullRequestCommentSummary.
        :rtype: str
        """
        return self._file_path

    @file_path.setter
    def file_path(self, file_path):
        """
        Sets the file_path of this PullRequestCommentSummary.
        File path in the commit


        :param file_path: The file_path of this PullRequestCommentSummary.
        :type: str
        """
        self._file_path = file_path

    @property
    def commit_id(self):
        """
        Gets the commit_id of this PullRequestCommentSummary.
        Commit SHA


        :return: The commit_id of this PullRequestCommentSummary.
        :rtype: str
        """
        return self._commit_id

    @commit_id.setter
    def commit_id(self, commit_id):
        """
        Sets the commit_id of this PullRequestCommentSummary.
        Commit SHA


        :param commit_id: The commit_id of this PullRequestCommentSummary.
        :type: str
        """
        self._commit_id = commit_id

    @property
    def file_type(self):
        """
        Gets the file_type of this PullRequestCommentSummary.
        File path in the target commit


        :return: The file_type of this PullRequestCommentSummary.
        :rtype: str
        """
        return self._file_type

    @file_type.setter
    def file_type(self, file_type):
        """
        Sets the file_type of this PullRequestCommentSummary.
        File path in the target commit


        :param file_type: The file_type of this PullRequestCommentSummary.
        :type: str
        """
        self._file_type = file_type

    @property
    def line_number(self):
        """
        Gets the line_number of this PullRequestCommentSummary.
        Line number in the file


        :return: The line_number of this PullRequestCommentSummary.
        :rtype: int
        """
        return self._line_number

    @line_number.setter
    def line_number(self, line_number):
        """
        Sets the line_number of this PullRequestCommentSummary.
        Line number in the file


        :param line_number: The line_number of this PullRequestCommentSummary.
        :type: int
        """
        self._line_number = line_number

    @property
    def likes(self):
        """
        Gets the likes of this PullRequestCommentSummary.

        :return: The likes of this PullRequestCommentSummary.
        :rtype: oci.devops.models.PullRequestCommentLikeCollection
        """
        return self._likes

    @likes.setter
    def likes(self, likes):
        """
        Sets the likes of this PullRequestCommentSummary.

        :param likes: The likes of this PullRequestCommentSummary.
        :type: oci.devops.models.PullRequestCommentLikeCollection
        """
        self._likes = likes

    @property
    def status(self):
        """
        **[Required]** Gets the status of this PullRequestCommentSummary.
        Status of the Comment


        :return: The status of this PullRequestCommentSummary.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this PullRequestCommentSummary.
        Status of the Comment


        :param status: The status of this PullRequestCommentSummary.
        :type: str
        """
        self._status = status

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this PullRequestCommentSummary.
        Creation timestamp. Format defined by `RFC3339`__.

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :return: The time_created of this PullRequestCommentSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this PullRequestCommentSummary.
        Creation timestamp. Format defined by `RFC3339`__.

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :param time_created: The time_created of this PullRequestCommentSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def created_by(self):
        """
        **[Required]** Gets the created_by of this PullRequestCommentSummary.

        :return: The created_by of this PullRequestCommentSummary.
        :rtype: oci.devops.models.PrincipalDetails
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """
        Sets the created_by of this PullRequestCommentSummary.

        :param created_by: The created_by of this PullRequestCommentSummary.
        :type: oci.devops.models.PrincipalDetails
        """
        self._created_by = created_by

    @property
    def time_updated(self):
        """
        Gets the time_updated of this PullRequestCommentSummary.
        Latest update timestamp. Format defined by `RFC3339`__.

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :return: The time_updated of this PullRequestCommentSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this PullRequestCommentSummary.
        Latest update timestamp. Format defined by `RFC3339`__.

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :param time_updated: The time_updated of this PullRequestCommentSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def updated_by(self):
        """
        Gets the updated_by of this PullRequestCommentSummary.

        :return: The updated_by of this PullRequestCommentSummary.
        :rtype: oci.devops.models.PrincipalDetails
        """
        return self._updated_by

    @updated_by.setter
    def updated_by(self, updated_by):
        """
        Sets the updated_by of this PullRequestCommentSummary.

        :param updated_by: The updated_by of this PullRequestCommentSummary.
        :type: oci.devops.models.PrincipalDetails
        """
        self._updated_by = updated_by

    @property
    def context_status(self):
        """
        Gets the context_status of this PullRequestCommentSummary.
        Shows the status of an inline comments context


        :return: The context_status of this PullRequestCommentSummary.
        :rtype: str
        """
        return self._context_status

    @context_status.setter
    def context_status(self, context_status):
        """
        Sets the context_status of this PullRequestCommentSummary.
        Shows the status of an inline comments context


        :param context_status: The context_status of this PullRequestCommentSummary.
        :type: str
        """
        self._context_status = context_status

    @property
    def comment_context(self):
        """
        Gets the comment_context of this PullRequestCommentSummary.
        4 line snippet to be displayed as context for inline comments


        :return: The comment_context of this PullRequestCommentSummary.
        :rtype: list[oci.devops.models.DiffLineDetails]
        """
        return self._comment_context

    @comment_context.setter
    def comment_context(self, comment_context):
        """
        Sets the comment_context of this PullRequestCommentSummary.
        4 line snippet to be displayed as context for inline comments


        :param comment_context: The comment_context of this PullRequestCommentSummary.
        :type: list[oci.devops.models.DiffLineDetails]
        """
        self._comment_context = comment_context

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
