# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PullRequestCommentLikeCollection(object):
    """
    Abstract of Pull Request Comment likes.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PullRequestCommentLikeCollection object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param users:
            The value to assign to the users property of this PullRequestCommentLikeCollection.
        :type users: list[oci.devops.models.PrincipalDetails]

        :param total_likes:
            The value to assign to the total_likes property of this PullRequestCommentLikeCollection.
        :type total_likes: int

        """
        self.swagger_types = {
            'users': 'list[PrincipalDetails]',
            'total_likes': 'int'
        }

        self.attribute_map = {
            'users': 'users',
            'total_likes': 'totalLikes'
        }

        self._users = None
        self._total_likes = None

    @property
    def users(self):
        """
        **[Required]** Gets the users of this PullRequestCommentLikeCollection.
        List of liked users of whom liked the pull request comment (max size is 50).


        :return: The users of this PullRequestCommentLikeCollection.
        :rtype: list[oci.devops.models.PrincipalDetails]
        """
        return self._users

    @users.setter
    def users(self, users):
        """
        Sets the users of this PullRequestCommentLikeCollection.
        List of liked users of whom liked the pull request comment (max size is 50).


        :param users: The users of this PullRequestCommentLikeCollection.
        :type: list[oci.devops.models.PrincipalDetails]
        """
        self._users = users

    @property
    def total_likes(self):
        """
        **[Required]** Gets the total_likes of this PullRequestCommentLikeCollection.
        Total like counter


        :return: The total_likes of this PullRequestCommentLikeCollection.
        :rtype: int
        """
        return self._total_likes

    @total_likes.setter
    def total_likes(self, total_likes):
        """
        Sets the total_likes of this PullRequestCommentLikeCollection.
        Total like counter


        :param total_likes: The total_likes of this PullRequestCommentLikeCollection.
        :type: int
        """
        self._total_likes = total_likes

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
