# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PullRequestChangeSummaryMetrics(object):
    """
    Response object for obtaining summary metric of Pull Request changed files.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PullRequestChangeSummaryMetrics object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param changed_files_count:
            The value to assign to the changed_files_count property of this PullRequestChangeSummaryMetrics.
        :type changed_files_count: int

        :param added_lines_count:
            The value to assign to the added_lines_count property of this PullRequestChangeSummaryMetrics.
        :type added_lines_count: int

        :param deleted_lines_count:
            The value to assign to the deleted_lines_count property of this PullRequestChangeSummaryMetrics.
        :type deleted_lines_count: int

        """
        self.swagger_types = {
            'changed_files_count': 'int',
            'added_lines_count': 'int',
            'deleted_lines_count': 'int'
        }

        self.attribute_map = {
            'changed_files_count': 'changedFilesCount',
            'added_lines_count': 'addedLinesCount',
            'deleted_lines_count': 'deletedLinesCount'
        }

        self._changed_files_count = None
        self._added_lines_count = None
        self._deleted_lines_count = None

    @property
    def changed_files_count(self):
        """
        **[Required]** Gets the changed_files_count of this PullRequestChangeSummaryMetrics.
        The number of lines added in whole difference.


        :return: The changed_files_count of this PullRequestChangeSummaryMetrics.
        :rtype: int
        """
        return self._changed_files_count

    @changed_files_count.setter
    def changed_files_count(self, changed_files_count):
        """
        Sets the changed_files_count of this PullRequestChangeSummaryMetrics.
        The number of lines added in whole difference.


        :param changed_files_count: The changed_files_count of this PullRequestChangeSummaryMetrics.
        :type: int
        """
        self._changed_files_count = changed_files_count

    @property
    def added_lines_count(self):
        """
        **[Required]** Gets the added_lines_count of this PullRequestChangeSummaryMetrics.
        The number of lines added in whole difference.


        :return: The added_lines_count of this PullRequestChangeSummaryMetrics.
        :rtype: int
        """
        return self._added_lines_count

    @added_lines_count.setter
    def added_lines_count(self, added_lines_count):
        """
        Sets the added_lines_count of this PullRequestChangeSummaryMetrics.
        The number of lines added in whole difference.


        :param added_lines_count: The added_lines_count of this PullRequestChangeSummaryMetrics.
        :type: int
        """
        self._added_lines_count = added_lines_count

    @property
    def deleted_lines_count(self):
        """
        **[Required]** Gets the deleted_lines_count of this PullRequestChangeSummaryMetrics.
        The number of lines deleted in whole difference.


        :return: The deleted_lines_count of this PullRequestChangeSummaryMetrics.
        :rtype: int
        """
        return self._deleted_lines_count

    @deleted_lines_count.setter
    def deleted_lines_count(self, deleted_lines_count):
        """
        Sets the deleted_lines_count of this PullRequestChangeSummaryMetrics.
        The number of lines deleted in whole difference.


        :param deleted_lines_count: The deleted_lines_count of this PullRequestChangeSummaryMetrics.
        :type: int
        """
        self._deleted_lines_count = deleted_lines_count

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
