# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreatePullRequestCommentDetails(object):
    """
    The information about new Comment.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreatePullRequestCommentDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param data:
            The value to assign to the data property of this CreatePullRequestCommentDetails.
        :type data: str

        :param parent_id:
            The value to assign to the parent_id property of this CreatePullRequestCommentDetails.
        :type parent_id: str

        :param file_path:
            The value to assign to the file_path property of this CreatePullRequestCommentDetails.
        :type file_path: str

        :param commit_id:
            The value to assign to the commit_id property of this CreatePullRequestCommentDetails.
        :type commit_id: str

        :param file_type:
            The value to assign to the file_type property of this CreatePullRequestCommentDetails.
        :type file_type: str

        :param line_number:
            The value to assign to the line_number property of this CreatePullRequestCommentDetails.
        :type line_number: int

        """
        self.swagger_types = {
            'data': 'str',
            'parent_id': 'str',
            'file_path': 'str',
            'commit_id': 'str',
            'file_type': 'str',
            'line_number': 'int'
        }

        self.attribute_map = {
            'data': 'data',
            'parent_id': 'parentId',
            'file_path': 'filePath',
            'commit_id': 'commitId',
            'file_type': 'fileType',
            'line_number': 'lineNumber'
        }

        self._data = None
        self._parent_id = None
        self._file_path = None
        self._commit_id = None
        self._file_type = None
        self._line_number = None

    @property
    def data(self):
        """
        **[Required]** Gets the data of this CreatePullRequestCommentDetails.
        Content of the Comment.


        :return: The data of this CreatePullRequestCommentDetails.
        :rtype: str
        """
        return self._data

    @data.setter
    def data(self, data):
        """
        Sets the data of this CreatePullRequestCommentDetails.
        Content of the Comment.


        :param data: The data of this CreatePullRequestCommentDetails.
        :type: str
        """
        self._data = data

    @property
    def parent_id(self):
        """
        Gets the parent_id of this CreatePullRequestCommentDetails.
        ID of parent Comment


        :return: The parent_id of this CreatePullRequestCommentDetails.
        :rtype: str
        """
        return self._parent_id

    @parent_id.setter
    def parent_id(self, parent_id):
        """
        Sets the parent_id of this CreatePullRequestCommentDetails.
        ID of parent Comment


        :param parent_id: The parent_id of this CreatePullRequestCommentDetails.
        :type: str
        """
        self._parent_id = parent_id

    @property
    def file_path(self):
        """
        Gets the file_path of this CreatePullRequestCommentDetails.
        File path in the commit


        :return: The file_path of this CreatePullRequestCommentDetails.
        :rtype: str
        """
        return self._file_path

    @file_path.setter
    def file_path(self, file_path):
        """
        Sets the file_path of this CreatePullRequestCommentDetails.
        File path in the commit


        :param file_path: The file_path of this CreatePullRequestCommentDetails.
        :type: str
        """
        self._file_path = file_path

    @property
    def commit_id(self):
        """
        Gets the commit_id of this CreatePullRequestCommentDetails.
        Commit SHA


        :return: The commit_id of this CreatePullRequestCommentDetails.
        :rtype: str
        """
        return self._commit_id

    @commit_id.setter
    def commit_id(self, commit_id):
        """
        Sets the commit_id of this CreatePullRequestCommentDetails.
        Commit SHA


        :param commit_id: The commit_id of this CreatePullRequestCommentDetails.
        :type: str
        """
        self._commit_id = commit_id

    @property
    def file_type(self):
        """
        Gets the file_type of this CreatePullRequestCommentDetails.
        File path in the target commit


        :return: The file_type of this CreatePullRequestCommentDetails.
        :rtype: str
        """
        return self._file_type

    @file_type.setter
    def file_type(self, file_type):
        """
        Sets the file_type of this CreatePullRequestCommentDetails.
        File path in the target commit


        :param file_type: The file_type of this CreatePullRequestCommentDetails.
        :type: str
        """
        self._file_type = file_type

    @property
    def line_number(self):
        """
        Gets the line_number of this CreatePullRequestCommentDetails.
        Line number in the file


        :return: The line_number of this CreatePullRequestCommentDetails.
        :rtype: int
        """
        return self._line_number

    @line_number.setter
    def line_number(self, line_number):
        """
        Sets the line_number of this CreatePullRequestCommentDetails.
        Line number in the file


        :param line_number: The line_number of this CreatePullRequestCommentDetails.
        :type: int
        """
        self._line_number = line_number

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
