# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230801


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ServiceProviderInteractionSummary(object):
    """
    Summary of customer and operator conversation.
    """

    #: A constant which can be used with the user_type property of a ServiceProviderInteractionSummary.
    #: This constant has a value of "CUSTOMER"
    USER_TYPE_CUSTOMER = "CUSTOMER"

    #: A constant which can be used with the user_type property of a ServiceProviderInteractionSummary.
    #: This constant has a value of "OPERATOR"
    USER_TYPE_OPERATOR = "OPERATOR"

    def __init__(self, **kwargs):
        """
        Initializes a new ServiceProviderInteractionSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param message_identifier:
            The value to assign to the message_identifier property of this ServiceProviderInteractionSummary.
        :type message_identifier: str

        :param user_id:
            The value to assign to the user_id property of this ServiceProviderInteractionSummary.
        :type user_id: str

        :param user_name:
            The value to assign to the user_name property of this ServiceProviderInteractionSummary.
        :type user_name: str

        :param message:
            The value to assign to the message property of this ServiceProviderInteractionSummary.
        :type message: str

        :param user_type:
            The value to assign to the user_type property of this ServiceProviderInteractionSummary.
            Allowed values for this property are: "CUSTOMER", "OPERATOR", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type user_type: str

        :param timestamp:
            The value to assign to the timestamp property of this ServiceProviderInteractionSummary.
        :type timestamp: datetime

        """
        self.swagger_types = {
            'message_identifier': 'str',
            'user_id': 'str',
            'user_name': 'str',
            'message': 'str',
            'user_type': 'str',
            'timestamp': 'datetime'
        }

        self.attribute_map = {
            'message_identifier': 'messageIdentifier',
            'user_id': 'userId',
            'user_name': 'userName',
            'message': 'message',
            'user_type': 'userType',
            'timestamp': 'timestamp'
        }

        self._message_identifier = None
        self._user_id = None
        self._user_name = None
        self._message = None
        self._user_type = None
        self._timestamp = None

    @property
    def message_identifier(self):
        """
        Gets the message_identifier of this ServiceProviderInteractionSummary.
        The unique identifier of the message within the scope of the associated access request.


        :return: The message_identifier of this ServiceProviderInteractionSummary.
        :rtype: str
        """
        return self._message_identifier

    @message_identifier.setter
    def message_identifier(self, message_identifier):
        """
        Sets the message_identifier of this ServiceProviderInteractionSummary.
        The unique identifier of the message within the scope of the associated access request.


        :param message_identifier: The message_identifier of this ServiceProviderInteractionSummary.
        :type: str
        """
        self._message_identifier = message_identifier

    @property
    def user_id(self):
        """
        Gets the user_id of this ServiceProviderInteractionSummary.
        ID of the customer or operator who is part of this conversation. For operator, this field is null.


        :return: The user_id of this ServiceProviderInteractionSummary.
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """
        Sets the user_id of this ServiceProviderInteractionSummary.
        ID of the customer or operator who is part of this conversation. For operator, this field is null.


        :param user_id: The user_id of this ServiceProviderInteractionSummary.
        :type: str
        """
        self._user_id = user_id

    @property
    def user_name(self):
        """
        Gets the user_name of this ServiceProviderInteractionSummary.
        Name of the customer or operator who is part of this conversation. For operator, the name is \"Operator\".


        :return: The user_name of this ServiceProviderInteractionSummary.
        :rtype: str
        """
        return self._user_name

    @user_name.setter
    def user_name(self, user_name):
        """
        Sets the user_name of this ServiceProviderInteractionSummary.
        Name of the customer or operator who is part of this conversation. For operator, the name is \"Operator\".


        :param user_name: The user_name of this ServiceProviderInteractionSummary.
        :type: str
        """
        self._user_name = user_name

    @property
    def message(self):
        """
        Gets the message of this ServiceProviderInteractionSummary.
        The information exchanged between the customer and the operator.


        :return: The message of this ServiceProviderInteractionSummary.
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """
        Sets the message of this ServiceProviderInteractionSummary.
        The information exchanged between the customer and the operator.


        :param message: The message of this ServiceProviderInteractionSummary.
        :type: str
        """
        self._message = message

    @property
    def user_type(self):
        """
        Gets the user_type of this ServiceProviderInteractionSummary.
        Indicates whether the user is a customer or an operator.

        Allowed values for this property are: "CUSTOMER", "OPERATOR", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The user_type of this ServiceProviderInteractionSummary.
        :rtype: str
        """
        return self._user_type

    @user_type.setter
    def user_type(self, user_type):
        """
        Sets the user_type of this ServiceProviderInteractionSummary.
        Indicates whether the user is a customer or an operator.


        :param user_type: The user_type of this ServiceProviderInteractionSummary.
        :type: str
        """
        allowed_values = ["CUSTOMER", "OPERATOR"]
        if not value_allowed_none_or_none_sentinel(user_type, allowed_values):
            user_type = 'UNKNOWN_ENUM_VALUE'
        self._user_type = user_type

    @property
    def timestamp(self):
        """
        Gets the timestamp of this ServiceProviderInteractionSummary.
        Time when the conversation happened in `RFC 3339`__timestamp format, e.g. '2020-05-22T21:10:29.600Z'.

        __ https://tools.ietf.org/html/rfc3339


        :return: The timestamp of this ServiceProviderInteractionSummary.
        :rtype: datetime
        """
        return self._timestamp

    @timestamp.setter
    def timestamp(self, timestamp):
        """
        Sets the timestamp of this ServiceProviderInteractionSummary.
        Time when the conversation happened in `RFC 3339`__timestamp format, e.g. '2020-05-22T21:10:29.600Z'.

        __ https://tools.ietf.org/html/rfc3339


        :param timestamp: The timestamp of this ServiceProviderInteractionSummary.
        :type: datetime
        """
        self._timestamp = timestamp

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
