# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101

from .connector_details import ConnectorDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PrivateEndPointConnectorDetails(ConnectorDetails):
    """
    The private endpoint details required to connect to an Oracle cloud Database.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PrivateEndPointConnectorDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.database_management.models.PrivateEndPointConnectorDetails.connector_type` attribute
        of this class is ``PE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param connector_type:
            The value to assign to the connector_type property of this PrivateEndPointConnectorDetails.
            Allowed values for this property are: "PE", "MACS", "EXTERNAL", "DIRECT"
        :type connector_type: str

        :param private_end_point_id:
            The value to assign to the private_end_point_id property of this PrivateEndPointConnectorDetails.
        :type private_end_point_id: str

        """
        self.swagger_types = {
            'connector_type': 'str',
            'private_end_point_id': 'str'
        }

        self.attribute_map = {
            'connector_type': 'connectorType',
            'private_end_point_id': 'privateEndPointId'
        }

        self._connector_type = None
        self._private_end_point_id = None
        self._connector_type = 'PE'

    @property
    def private_end_point_id(self):
        """
        **[Required]** Gets the private_end_point_id of this PrivateEndPointConnectorDetails.
        The `OCID`__ of the private endpoint.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The private_end_point_id of this PrivateEndPointConnectorDetails.
        :rtype: str
        """
        return self._private_end_point_id

    @private_end_point_id.setter
    def private_end_point_id(self, private_end_point_id):
        """
        Sets the private_end_point_id of this PrivateEndPointConnectorDetails.
        The `OCID`__ of the private endpoint.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param private_end_point_id: The private_end_point_id of this PrivateEndPointConnectorDetails.
        :type: str
        """
        self._private_end_point_id = private_end_point_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
