# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SchedulingPolicySummary(object):
    """
    Details of a Scheduling Policy.
    """

    #: A constant which can be used with the lifecycle_state property of a SchedulingPolicySummary.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a SchedulingPolicySummary.
    #: This constant has a value of "NEEDS_ATTENTION"
    LIFECYCLE_STATE_NEEDS_ATTENTION = "NEEDS_ATTENTION"

    #: A constant which can be used with the lifecycle_state property of a SchedulingPolicySummary.
    #: This constant has a value of "AVAILABLE"
    LIFECYCLE_STATE_AVAILABLE = "AVAILABLE"

    #: A constant which can be used with the lifecycle_state property of a SchedulingPolicySummary.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a SchedulingPolicySummary.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the lifecycle_state property of a SchedulingPolicySummary.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a SchedulingPolicySummary.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the cadence property of a SchedulingPolicySummary.
    #: This constant has a value of "HALFYEARLY"
    CADENCE_HALFYEARLY = "HALFYEARLY"

    #: A constant which can be used with the cadence property of a SchedulingPolicySummary.
    #: This constant has a value of "QUARTERLY"
    CADENCE_QUARTERLY = "QUARTERLY"

    #: A constant which can be used with the cadence property of a SchedulingPolicySummary.
    #: This constant has a value of "MONTHLY"
    CADENCE_MONTHLY = "MONTHLY"

    def __init__(self, **kwargs):
        """
        Initializes a new SchedulingPolicySummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this SchedulingPolicySummary.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this SchedulingPolicySummary.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this SchedulingPolicySummary.
        :type display_name: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this SchedulingPolicySummary.
            Allowed values for this property are: "CREATING", "NEEDS_ATTENTION", "AVAILABLE", "UPDATING", "FAILED", "DELETING", "DELETED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this SchedulingPolicySummary.
        :type lifecycle_details: str

        :param time_created:
            The value to assign to the time_created property of this SchedulingPolicySummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this SchedulingPolicySummary.
        :type time_updated: datetime

        :param cadence:
            The value to assign to the cadence property of this SchedulingPolicySummary.
            Allowed values for this property are: "HALFYEARLY", "QUARTERLY", "MONTHLY", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type cadence: str

        :param cadence_start_month:
            The value to assign to the cadence_start_month property of this SchedulingPolicySummary.
        :type cadence_start_month: oci.database.models.Month

        :param time_next_window_starts:
            The value to assign to the time_next_window_starts property of this SchedulingPolicySummary.
        :type time_next_window_starts: datetime

        :param freeform_tags:
            The value to assign to the freeform_tags property of this SchedulingPolicySummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this SchedulingPolicySummary.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'display_name': 'str',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'cadence': 'str',
            'cadence_start_month': 'Month',
            'time_next_window_starts': 'datetime',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'cadence': 'cadence',
            'cadence_start_month': 'cadenceStartMonth',
            'time_next_window_starts': 'timeNextWindowStarts',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }

        self._id = None
        self._compartment_id = None
        self._display_name = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._time_created = None
        self._time_updated = None
        self._cadence = None
        self._cadence_start_month = None
        self._time_next_window_starts = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this SchedulingPolicySummary.
        The `OCID`__ of the Scheduling Policy.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The id of this SchedulingPolicySummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this SchedulingPolicySummary.
        The `OCID`__ of the Scheduling Policy.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param id: The id of this SchedulingPolicySummary.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this SchedulingPolicySummary.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this SchedulingPolicySummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this SchedulingPolicySummary.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this SchedulingPolicySummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this SchedulingPolicySummary.
        The user-friendly name for the Scheduling Policy. The name does not need to be unique.


        :return: The display_name of this SchedulingPolicySummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this SchedulingPolicySummary.
        The user-friendly name for the Scheduling Policy. The name does not need to be unique.


        :param display_name: The display_name of this SchedulingPolicySummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this SchedulingPolicySummary.
        The current state of the Scheduling Policy. Valid states are CREATING, NEEDS_ATTENTION, ACTIVE, UPDATING, FAILED, DELETING and DELETED.

        Allowed values for this property are: "CREATING", "NEEDS_ATTENTION", "AVAILABLE", "UPDATING", "FAILED", "DELETING", "DELETED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this SchedulingPolicySummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this SchedulingPolicySummary.
        The current state of the Scheduling Policy. Valid states are CREATING, NEEDS_ATTENTION, ACTIVE, UPDATING, FAILED, DELETING and DELETED.


        :param lifecycle_state: The lifecycle_state of this SchedulingPolicySummary.
        :type: str
        """
        allowed_values = ["CREATING", "NEEDS_ATTENTION", "AVAILABLE", "UPDATING", "FAILED", "DELETING", "DELETED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this SchedulingPolicySummary.
        Additional information about the current lifecycle state.


        :return: The lifecycle_details of this SchedulingPolicySummary.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this SchedulingPolicySummary.
        Additional information about the current lifecycle state.


        :param lifecycle_details: The lifecycle_details of this SchedulingPolicySummary.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def time_created(self):
        """
        Gets the time_created of this SchedulingPolicySummary.
        The date and time the Scheduling Policy was created.


        :return: The time_created of this SchedulingPolicySummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this SchedulingPolicySummary.
        The date and time the Scheduling Policy was created.


        :param time_created: The time_created of this SchedulingPolicySummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this SchedulingPolicySummary.
        The last date and time that the Scheduling Policy was updated.


        :return: The time_updated of this SchedulingPolicySummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this SchedulingPolicySummary.
        The last date and time that the Scheduling Policy was updated.


        :param time_updated: The time_updated of this SchedulingPolicySummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def cadence(self):
        """
        **[Required]** Gets the cadence of this SchedulingPolicySummary.
        The cadence period.

        Allowed values for this property are: "HALFYEARLY", "QUARTERLY", "MONTHLY", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The cadence of this SchedulingPolicySummary.
        :rtype: str
        """
        return self._cadence

    @cadence.setter
    def cadence(self, cadence):
        """
        Sets the cadence of this SchedulingPolicySummary.
        The cadence period.


        :param cadence: The cadence of this SchedulingPolicySummary.
        :type: str
        """
        allowed_values = ["HALFYEARLY", "QUARTERLY", "MONTHLY"]
        if not value_allowed_none_or_none_sentinel(cadence, allowed_values):
            cadence = 'UNKNOWN_ENUM_VALUE'
        self._cadence = cadence

    @property
    def cadence_start_month(self):
        """
        Gets the cadence_start_month of this SchedulingPolicySummary.
        Start of the month to be followed during the cadence period.


        :return: The cadence_start_month of this SchedulingPolicySummary.
        :rtype: oci.database.models.Month
        """
        return self._cadence_start_month

    @cadence_start_month.setter
    def cadence_start_month(self, cadence_start_month):
        """
        Sets the cadence_start_month of this SchedulingPolicySummary.
        Start of the month to be followed during the cadence period.


        :param cadence_start_month: The cadence_start_month of this SchedulingPolicySummary.
        :type: oci.database.models.Month
        """
        self._cadence_start_month = cadence_start_month

    @property
    def time_next_window_starts(self):
        """
        Gets the time_next_window_starts of this SchedulingPolicySummary.
        The date and time of the next scheduling window associated with the schedulingPolicy is planned to start.


        :return: The time_next_window_starts of this SchedulingPolicySummary.
        :rtype: datetime
        """
        return self._time_next_window_starts

    @time_next_window_starts.setter
    def time_next_window_starts(self, time_next_window_starts):
        """
        Sets the time_next_window_starts of this SchedulingPolicySummary.
        The date and time of the next scheduling window associated with the schedulingPolicy is planned to start.


        :param time_next_window_starts: The time_next_window_starts of this SchedulingPolicySummary.
        :type: datetime
        """
        self._time_next_window_starts = time_next_window_starts

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this SchedulingPolicySummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this SchedulingPolicySummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this SchedulingPolicySummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this SchedulingPolicySummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this SchedulingPolicySummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this SchedulingPolicySummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this SchedulingPolicySummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this SchedulingPolicySummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
