# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ReorderScheduledActionsDetails(object):
    """
    Describes the re-order parameters for the Scheduled Action resources.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ReorderScheduledActionsDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param scheduling_window_id:
            The value to assign to the scheduling_window_id property of this ReorderScheduledActionsDetails.
        :type scheduling_window_id: str

        :param scheduled_action_id_orders:
            The value to assign to the scheduled_action_id_orders property of this ReorderScheduledActionsDetails.
        :type scheduled_action_id_orders: list[oci.database.models.ActionOrderDetails]

        """
        self.swagger_types = {
            'scheduling_window_id': 'str',
            'scheduled_action_id_orders': 'list[ActionOrderDetails]'
        }

        self.attribute_map = {
            'scheduling_window_id': 'schedulingWindowId',
            'scheduled_action_id_orders': 'scheduledActionIdOrders'
        }

        self._scheduling_window_id = None
        self._scheduled_action_id_orders = None

    @property
    def scheduling_window_id(self):
        """
        **[Required]** Gets the scheduling_window_id of this ReorderScheduledActionsDetails.
        The `OCID`__ of the Scheduling Window.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The scheduling_window_id of this ReorderScheduledActionsDetails.
        :rtype: str
        """
        return self._scheduling_window_id

    @scheduling_window_id.setter
    def scheduling_window_id(self, scheduling_window_id):
        """
        Sets the scheduling_window_id of this ReorderScheduledActionsDetails.
        The `OCID`__ of the Scheduling Window.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param scheduling_window_id: The scheduling_window_id of this ReorderScheduledActionsDetails.
        :type: str
        """
        self._scheduling_window_id = scheduling_window_id

    @property
    def scheduled_action_id_orders(self):
        """
        **[Required]** Gets the scheduled_action_id_orders of this ReorderScheduledActionsDetails.
        List of action resources in a specific order.
        Example: [{actionOrder: 1, actionResourceId: \"resourceId1\"}, {actionOrder: 2, actionResourceId: \"resourceId2\"}]


        :return: The scheduled_action_id_orders of this ReorderScheduledActionsDetails.
        :rtype: list[oci.database.models.ActionOrderDetails]
        """
        return self._scheduled_action_id_orders

    @scheduled_action_id_orders.setter
    def scheduled_action_id_orders(self, scheduled_action_id_orders):
        """
        Sets the scheduled_action_id_orders of this ReorderScheduledActionsDetails.
        List of action resources in a specific order.
        Example: [{actionOrder: 1, actionResourceId: \"resourceId1\"}, {actionOrder: 2, actionResourceId: \"resourceId2\"}]


        :param scheduled_action_id_orders: The scheduled_action_id_orders of this ReorderScheduledActionsDetails.
        :type: list[oci.database.models.ActionOrderDetails]
        """
        self._scheduled_action_id_orders = scheduled_action_id_orders

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
