# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RecommendedScheduledActionSummary(object):
    """
    Details of the scheduled action that is used in getRecommendedScheduledActions.
    """

    #: A constant which can be used with the action_type property of a RecommendedScheduledActionSummary.
    #: This constant has a value of "DB_SERVER_FULL_SOFTWARE_UPDATE"
    ACTION_TYPE_DB_SERVER_FULL_SOFTWARE_UPDATE = "DB_SERVER_FULL_SOFTWARE_UPDATE"

    #: A constant which can be used with the action_type property of a RecommendedScheduledActionSummary.
    #: This constant has a value of "STORAGE_SERVER_FULL_SOFTWARE_UPDATE"
    ACTION_TYPE_STORAGE_SERVER_FULL_SOFTWARE_UPDATE = "STORAGE_SERVER_FULL_SOFTWARE_UPDATE"

    #: A constant which can be used with the action_type property of a RecommendedScheduledActionSummary.
    #: This constant has a value of "NETWORK_SWITCH_FULL_SOFTWARE_UPDATE"
    ACTION_TYPE_NETWORK_SWITCH_FULL_SOFTWARE_UPDATE = "NETWORK_SWITCH_FULL_SOFTWARE_UPDATE"

    def __init__(self, **kwargs):
        """
        Initializes a new RecommendedScheduledActionSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param action_order:
            The value to assign to the action_order property of this RecommendedScheduledActionSummary.
        :type action_order: int

        :param action_type:
            The value to assign to the action_type property of this RecommendedScheduledActionSummary.
            Allowed values for this property are: "DB_SERVER_FULL_SOFTWARE_UPDATE", "STORAGE_SERVER_FULL_SOFTWARE_UPDATE", "NETWORK_SWITCH_FULL_SOFTWARE_UPDATE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type action_type: str

        :param display_name:
            The value to assign to the display_name property of this RecommendedScheduledActionSummary.
        :type display_name: str

        :param scheduling_window_id:
            The value to assign to the scheduling_window_id property of this RecommendedScheduledActionSummary.
        :type scheduling_window_id: str

        :param estimated_time_in_mins:
            The value to assign to the estimated_time_in_mins property of this RecommendedScheduledActionSummary.
        :type estimated_time_in_mins: int

        :param action_members:
            The value to assign to the action_members property of this RecommendedScheduledActionSummary.
        :type action_members: list[oci.database.models.ActionMember]

        :param action_params:
            The value to assign to the action_params property of this RecommendedScheduledActionSummary.
        :type action_params: dict(str, str)

        """
        self.swagger_types = {
            'action_order': 'int',
            'action_type': 'str',
            'display_name': 'str',
            'scheduling_window_id': 'str',
            'estimated_time_in_mins': 'int',
            'action_members': 'list[ActionMember]',
            'action_params': 'dict(str, str)'
        }

        self.attribute_map = {
            'action_order': 'actionOrder',
            'action_type': 'actionType',
            'display_name': 'displayName',
            'scheduling_window_id': 'schedulingWindowId',
            'estimated_time_in_mins': 'estimatedTimeInMins',
            'action_members': 'actionMembers',
            'action_params': 'actionParams'
        }

        self._action_order = None
        self._action_type = None
        self._display_name = None
        self._scheduling_window_id = None
        self._estimated_time_in_mins = None
        self._action_members = None
        self._action_params = None

    @property
    def action_order(self):
        """
        **[Required]** Gets the action_order of this RecommendedScheduledActionSummary.
        The order of the scheduled action.


        :return: The action_order of this RecommendedScheduledActionSummary.
        :rtype: int
        """
        return self._action_order

    @action_order.setter
    def action_order(self, action_order):
        """
        Sets the action_order of this RecommendedScheduledActionSummary.
        The order of the scheduled action.


        :param action_order: The action_order of this RecommendedScheduledActionSummary.
        :type: int
        """
        self._action_order = action_order

    @property
    def action_type(self):
        """
        **[Required]** Gets the action_type of this RecommendedScheduledActionSummary.
        The type of the scheduled action being performed

        Allowed values for this property are: "DB_SERVER_FULL_SOFTWARE_UPDATE", "STORAGE_SERVER_FULL_SOFTWARE_UPDATE", "NETWORK_SWITCH_FULL_SOFTWARE_UPDATE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The action_type of this RecommendedScheduledActionSummary.
        :rtype: str
        """
        return self._action_type

    @action_type.setter
    def action_type(self, action_type):
        """
        Sets the action_type of this RecommendedScheduledActionSummary.
        The type of the scheduled action being performed


        :param action_type: The action_type of this RecommendedScheduledActionSummary.
        :type: str
        """
        allowed_values = ["DB_SERVER_FULL_SOFTWARE_UPDATE", "STORAGE_SERVER_FULL_SOFTWARE_UPDATE", "NETWORK_SWITCH_FULL_SOFTWARE_UPDATE"]
        if not value_allowed_none_or_none_sentinel(action_type, allowed_values):
            action_type = 'UNKNOWN_ENUM_VALUE'
        self._action_type = action_type

    @property
    def display_name(self):
        """
        Gets the display_name of this RecommendedScheduledActionSummary.
        Description of the scheduled action being performed, i.e. apply full update to DB Servers 1,2,3,4.


        :return: The display_name of this RecommendedScheduledActionSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this RecommendedScheduledActionSummary.
        Description of the scheduled action being performed, i.e. apply full update to DB Servers 1,2,3,4.


        :param display_name: The display_name of this RecommendedScheduledActionSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def scheduling_window_id(self):
        """
        **[Required]** Gets the scheduling_window_id of this RecommendedScheduledActionSummary.
        The id of the scheduling window this scheduled action belongs to.


        :return: The scheduling_window_id of this RecommendedScheduledActionSummary.
        :rtype: str
        """
        return self._scheduling_window_id

    @scheduling_window_id.setter
    def scheduling_window_id(self, scheduling_window_id):
        """
        Sets the scheduling_window_id of this RecommendedScheduledActionSummary.
        The id of the scheduling window this scheduled action belongs to.


        :param scheduling_window_id: The scheduling_window_id of this RecommendedScheduledActionSummary.
        :type: str
        """
        self._scheduling_window_id = scheduling_window_id

    @property
    def estimated_time_in_mins(self):
        """
        Gets the estimated_time_in_mins of this RecommendedScheduledActionSummary.
        The estimated patching time in minutes for the entire scheduled action.


        :return: The estimated_time_in_mins of this RecommendedScheduledActionSummary.
        :rtype: int
        """
        return self._estimated_time_in_mins

    @estimated_time_in_mins.setter
    def estimated_time_in_mins(self, estimated_time_in_mins):
        """
        Sets the estimated_time_in_mins of this RecommendedScheduledActionSummary.
        The estimated patching time in minutes for the entire scheduled action.


        :param estimated_time_in_mins: The estimated_time_in_mins of this RecommendedScheduledActionSummary.
        :type: int
        """
        self._estimated_time_in_mins = estimated_time_in_mins

    @property
    def action_members(self):
        """
        Gets the action_members of this RecommendedScheduledActionSummary.
        The list of action members in a scheduled action.


        :return: The action_members of this RecommendedScheduledActionSummary.
        :rtype: list[oci.database.models.ActionMember]
        """
        return self._action_members

    @action_members.setter
    def action_members(self, action_members):
        """
        Sets the action_members of this RecommendedScheduledActionSummary.
        The list of action members in a scheduled action.


        :param action_members: The action_members of this RecommendedScheduledActionSummary.
        :type: list[oci.database.models.ActionMember]
        """
        self._action_members = action_members

    @property
    def action_params(self):
        """
        Gets the action_params of this RecommendedScheduledActionSummary.
        Map<ParamName, ParamValue> where a key value pair describes the specific action parameter.
        Example: `{\"count\": \"3\"}`


        :return: The action_params of this RecommendedScheduledActionSummary.
        :rtype: dict(str, str)
        """
        return self._action_params

    @action_params.setter
    def action_params(self, action_params):
        """
        Sets the action_params of this RecommendedScheduledActionSummary.
        Map<ParamName, ParamValue> where a key value pair describes the specific action parameter.
        Example: `{\"count\": \"3\"}`


        :param action_params: The action_params of this RecommendedScheduledActionSummary.
        :type: dict(str, str)
        """
        self._action_params = action_params

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
