# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RetentionOperationDetails(object):
    """
    Retention operation details for the model.
    """

    #: A constant which can be used with the archive_state property of a RetentionOperationDetails.
    #: This constant has a value of "PENDING"
    ARCHIVE_STATE_PENDING = "PENDING"

    #: A constant which can be used with the archive_state property of a RetentionOperationDetails.
    #: This constant has a value of "FAILED"
    ARCHIVE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the archive_state property of a RetentionOperationDetails.
    #: This constant has a value of "SUCCEEDED"
    ARCHIVE_STATE_SUCCEEDED = "SUCCEEDED"

    #: A constant which can be used with the delete_state property of a RetentionOperationDetails.
    #: This constant has a value of "PENDING"
    DELETE_STATE_PENDING = "PENDING"

    #: A constant which can be used with the delete_state property of a RetentionOperationDetails.
    #: This constant has a value of "FAILED"
    DELETE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the delete_state property of a RetentionOperationDetails.
    #: This constant has a value of "SUCCEEDED"
    DELETE_STATE_SUCCEEDED = "SUCCEEDED"

    def __init__(self, **kwargs):
        """
        Initializes a new RetentionOperationDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param archive_state:
            The value to assign to the archive_state property of this RetentionOperationDetails.
            Allowed values for this property are: "PENDING", "FAILED", "SUCCEEDED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type archive_state: str

        :param archive_state_details:
            The value to assign to the archive_state_details property of this RetentionOperationDetails.
        :type archive_state_details: str

        :param time_archival_scheduled:
            The value to assign to the time_archival_scheduled property of this RetentionOperationDetails.
        :type time_archival_scheduled: datetime

        :param delete_state:
            The value to assign to the delete_state property of this RetentionOperationDetails.
            Allowed values for this property are: "PENDING", "FAILED", "SUCCEEDED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type delete_state: str

        :param delete_state_details:
            The value to assign to the delete_state_details property of this RetentionOperationDetails.
        :type delete_state_details: str

        :param time_deletion_scheduled:
            The value to assign to the time_deletion_scheduled property of this RetentionOperationDetails.
        :type time_deletion_scheduled: datetime

        """
        self.swagger_types = {
            'archive_state': 'str',
            'archive_state_details': 'str',
            'time_archival_scheduled': 'datetime',
            'delete_state': 'str',
            'delete_state_details': 'str',
            'time_deletion_scheduled': 'datetime'
        }

        self.attribute_map = {
            'archive_state': 'archiveState',
            'archive_state_details': 'archiveStateDetails',
            'time_archival_scheduled': 'timeArchivalScheduled',
            'delete_state': 'deleteState',
            'delete_state_details': 'deleteStateDetails',
            'time_deletion_scheduled': 'timeDeletionScheduled'
        }

        self._archive_state = None
        self._archive_state_details = None
        self._time_archival_scheduled = None
        self._delete_state = None
        self._delete_state_details = None
        self._time_deletion_scheduled = None

    @property
    def archive_state(self):
        """
        **[Required]** Gets the archive_state of this RetentionOperationDetails.
        The archival status of model.

        Allowed values for this property are: "PENDING", "FAILED", "SUCCEEDED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The archive_state of this RetentionOperationDetails.
        :rtype: str
        """
        return self._archive_state

    @archive_state.setter
    def archive_state(self, archive_state):
        """
        Sets the archive_state of this RetentionOperationDetails.
        The archival status of model.


        :param archive_state: The archive_state of this RetentionOperationDetails.
        :type: str
        """
        allowed_values = ["PENDING", "FAILED", "SUCCEEDED"]
        if not value_allowed_none_or_none_sentinel(archive_state, allowed_values):
            archive_state = 'UNKNOWN_ENUM_VALUE'
        self._archive_state = archive_state

    @property
    def archive_state_details(self):
        """
        **[Required]** Gets the archive_state_details of this RetentionOperationDetails.
        The archival state details of the model.


        :return: The archive_state_details of this RetentionOperationDetails.
        :rtype: str
        """
        return self._archive_state_details

    @archive_state_details.setter
    def archive_state_details(self, archive_state_details):
        """
        Sets the archive_state_details of this RetentionOperationDetails.
        The archival state details of the model.


        :param archive_state_details: The archive_state_details of this RetentionOperationDetails.
        :type: str
        """
        self._archive_state_details = archive_state_details

    @property
    def time_archival_scheduled(self):
        """
        **[Required]** Gets the time_archival_scheduled of this RetentionOperationDetails.
        The estimated archival time of the model based on the provided retention setting.


        :return: The time_archival_scheduled of this RetentionOperationDetails.
        :rtype: datetime
        """
        return self._time_archival_scheduled

    @time_archival_scheduled.setter
    def time_archival_scheduled(self, time_archival_scheduled):
        """
        Sets the time_archival_scheduled of this RetentionOperationDetails.
        The estimated archival time of the model based on the provided retention setting.


        :param time_archival_scheduled: The time_archival_scheduled of this RetentionOperationDetails.
        :type: datetime
        """
        self._time_archival_scheduled = time_archival_scheduled

    @property
    def delete_state(self):
        """
        **[Required]** Gets the delete_state of this RetentionOperationDetails.
        The deletion status of the archived model.

        Allowed values for this property are: "PENDING", "FAILED", "SUCCEEDED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The delete_state of this RetentionOperationDetails.
        :rtype: str
        """
        return self._delete_state

    @delete_state.setter
    def delete_state(self, delete_state):
        """
        Sets the delete_state of this RetentionOperationDetails.
        The deletion status of the archived model.


        :param delete_state: The delete_state of this RetentionOperationDetails.
        :type: str
        """
        allowed_values = ["PENDING", "FAILED", "SUCCEEDED"]
        if not value_allowed_none_or_none_sentinel(delete_state, allowed_values):
            delete_state = 'UNKNOWN_ENUM_VALUE'
        self._delete_state = delete_state

    @property
    def delete_state_details(self):
        """
        **[Required]** Gets the delete_state_details of this RetentionOperationDetails.
        The deletion status details of the archived model.


        :return: The delete_state_details of this RetentionOperationDetails.
        :rtype: str
        """
        return self._delete_state_details

    @delete_state_details.setter
    def delete_state_details(self, delete_state_details):
        """
        Sets the delete_state_details of this RetentionOperationDetails.
        The deletion status details of the archived model.


        :param delete_state_details: The delete_state_details of this RetentionOperationDetails.
        :type: str
        """
        self._delete_state_details = delete_state_details

    @property
    def time_deletion_scheduled(self):
        """
        **[Required]** Gets the time_deletion_scheduled of this RetentionOperationDetails.
        The estimated deletion time of the model based on the provided retention setting.


        :return: The time_deletion_scheduled of this RetentionOperationDetails.
        :rtype: datetime
        """
        return self._time_deletion_scheduled

    @time_deletion_scheduled.setter
    def time_deletion_scheduled(self, time_deletion_scheduled):
        """
        Sets the time_deletion_scheduled of this RetentionOperationDetails.
        The estimated deletion time of the model based on the provided retention setting.


        :param time_deletion_scheduled: The time_deletion_scheduled of this RetentionOperationDetails.
        :type: datetime
        """
        self._time_deletion_scheduled = time_deletion_scheduled

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
