# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Model(object):
    """
    Models are mathematical representations of the relationships between data. Models are represented by their associated metadata and artifacts.
    """

    #: A constant which can be used with the lifecycle_state property of a Model.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a Model.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a Model.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the lifecycle_state property of a Model.
    #: This constant has a value of "INACTIVE"
    LIFECYCLE_STATE_INACTIVE = "INACTIVE"

    def __init__(self, **kwargs):
        """
        Initializes a new Model object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this Model.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this Model.
        :type compartment_id: str

        :param project_id:
            The value to assign to the project_id property of this Model.
        :type project_id: str

        :param display_name:
            The value to assign to the display_name property of this Model.
        :type display_name: str

        :param description:
            The value to assign to the description property of this Model.
        :type description: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this Model.
            Allowed values for this property are: "ACTIVE", "DELETED", "FAILED", "INACTIVE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this Model.
        :type lifecycle_details: str

        :param time_created:
            The value to assign to the time_created property of this Model.
        :type time_created: datetime

        :param created_by:
            The value to assign to the created_by property of this Model.
        :type created_by: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this Model.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this Model.
        :type defined_tags: dict(str, dict(str, object))

        :param custom_metadata_list:
            The value to assign to the custom_metadata_list property of this Model.
        :type custom_metadata_list: list[oci.data_science.models.Metadata]

        :param defined_metadata_list:
            The value to assign to the defined_metadata_list property of this Model.
        :type defined_metadata_list: list[oci.data_science.models.Metadata]

        :param input_schema:
            The value to assign to the input_schema property of this Model.
        :type input_schema: str

        :param output_schema:
            The value to assign to the output_schema property of this Model.
        :type output_schema: str

        :param model_version_set_id:
            The value to assign to the model_version_set_id property of this Model.
        :type model_version_set_id: str

        :param model_version_set_name:
            The value to assign to the model_version_set_name property of this Model.
        :type model_version_set_name: str

        :param version_id:
            The value to assign to the version_id property of this Model.
        :type version_id: int

        :param version_label:
            The value to assign to the version_label property of this Model.
        :type version_label: str

        :param retention_setting:
            The value to assign to the retention_setting property of this Model.
        :type retention_setting: oci.data_science.models.RetentionSetting

        :param backup_setting:
            The value to assign to the backup_setting property of this Model.
        :type backup_setting: oci.data_science.models.BackupSetting

        :param retention_operation_details:
            The value to assign to the retention_operation_details property of this Model.
        :type retention_operation_details: oci.data_science.models.RetentionOperationDetails

        :param backup_operation_details:
            The value to assign to the backup_operation_details property of this Model.
        :type backup_operation_details: oci.data_science.models.BackupOperationDetails

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'project_id': 'str',
            'display_name': 'str',
            'description': 'str',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'time_created': 'datetime',
            'created_by': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'custom_metadata_list': 'list[Metadata]',
            'defined_metadata_list': 'list[Metadata]',
            'input_schema': 'str',
            'output_schema': 'str',
            'model_version_set_id': 'str',
            'model_version_set_name': 'str',
            'version_id': 'int',
            'version_label': 'str',
            'retention_setting': 'RetentionSetting',
            'backup_setting': 'BackupSetting',
            'retention_operation_details': 'RetentionOperationDetails',
            'backup_operation_details': 'BackupOperationDetails'
        }

        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'project_id': 'projectId',
            'display_name': 'displayName',
            'description': 'description',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'time_created': 'timeCreated',
            'created_by': 'createdBy',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'custom_metadata_list': 'customMetadataList',
            'defined_metadata_list': 'definedMetadataList',
            'input_schema': 'inputSchema',
            'output_schema': 'outputSchema',
            'model_version_set_id': 'modelVersionSetId',
            'model_version_set_name': 'modelVersionSetName',
            'version_id': 'versionId',
            'version_label': 'versionLabel',
            'retention_setting': 'retentionSetting',
            'backup_setting': 'backupSetting',
            'retention_operation_details': 'retentionOperationDetails',
            'backup_operation_details': 'backupOperationDetails'
        }

        self._id = None
        self._compartment_id = None
        self._project_id = None
        self._display_name = None
        self._description = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._time_created = None
        self._created_by = None
        self._freeform_tags = None
        self._defined_tags = None
        self._custom_metadata_list = None
        self._defined_metadata_list = None
        self._input_schema = None
        self._output_schema = None
        self._model_version_set_id = None
        self._model_version_set_name = None
        self._version_id = None
        self._version_label = None
        self._retention_setting = None
        self._backup_setting = None
        self._retention_operation_details = None
        self._backup_operation_details = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this Model.
        The `OCID`__ of the model.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this Model.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Model.
        The `OCID`__ of the model.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this Model.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this Model.
        The `OCID`__ of the model's compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this Model.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this Model.
        The `OCID`__ of the model's compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this Model.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def project_id(self):
        """
        **[Required]** Gets the project_id of this Model.
        The `OCID`__ of the project associated with the model.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The project_id of this Model.
        :rtype: str
        """
        return self._project_id

    @project_id.setter
    def project_id(self, project_id):
        """
        Sets the project_id of this Model.
        The `OCID`__ of the project associated with the model.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param project_id: The project_id of this Model.
        :type: str
        """
        self._project_id = project_id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this Model.
        A user-friendly display name for the resource. It does not have to be unique and can be modified. Avoid entering confidential information.


        :return: The display_name of this Model.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this Model.
        A user-friendly display name for the resource. It does not have to be unique and can be modified. Avoid entering confidential information.


        :param display_name: The display_name of this Model.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this Model.
        A short description of the model.


        :return: The description of this Model.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this Model.
        A short description of the model.


        :param description: The description of this Model.
        :type: str
        """
        self._description = description

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this Model.
        The state of the model.

        Allowed values for this property are: "ACTIVE", "DELETED", "FAILED", "INACTIVE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this Model.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this Model.
        The state of the model.


        :param lifecycle_state: The lifecycle_state of this Model.
        :type: str
        """
        allowed_values = ["ACTIVE", "DELETED", "FAILED", "INACTIVE"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        **[Required]** Gets the lifecycle_details of this Model.
        Details about the lifecycle state of the model.


        :return: The lifecycle_details of this Model.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this Model.
        Details about the lifecycle state of the model.


        :param lifecycle_details: The lifecycle_details of this Model.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this Model.
        The date and time the resource was created in the timestamp format defined by `RFC3339`__.
        Example: 2019-08-25T21:10:29.41Z

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this Model.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this Model.
        The date and time the resource was created in the timestamp format defined by `RFC3339`__.
        Example: 2019-08-25T21:10:29.41Z

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this Model.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def created_by(self):
        """
        **[Required]** Gets the created_by of this Model.
        The `OCID`__ of the user who created the model.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The created_by of this Model.
        :rtype: str
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """
        Sets the created_by of this Model.
        The `OCID`__ of the user who created the model.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param created_by: The created_by of this Model.
        :type: str
        """
        self._created_by = created_by

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this Model.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this Model.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this Model.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this Model.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this Model.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. See `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this Model.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this Model.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. See `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this Model.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def custom_metadata_list(self):
        """
        Gets the custom_metadata_list of this Model.
        An array of custom metadata details for the model.


        :return: The custom_metadata_list of this Model.
        :rtype: list[oci.data_science.models.Metadata]
        """
        return self._custom_metadata_list

    @custom_metadata_list.setter
    def custom_metadata_list(self, custom_metadata_list):
        """
        Sets the custom_metadata_list of this Model.
        An array of custom metadata details for the model.


        :param custom_metadata_list: The custom_metadata_list of this Model.
        :type: list[oci.data_science.models.Metadata]
        """
        self._custom_metadata_list = custom_metadata_list

    @property
    def defined_metadata_list(self):
        """
        Gets the defined_metadata_list of this Model.
        An array of defined metadata details for the model.


        :return: The defined_metadata_list of this Model.
        :rtype: list[oci.data_science.models.Metadata]
        """
        return self._defined_metadata_list

    @defined_metadata_list.setter
    def defined_metadata_list(self, defined_metadata_list):
        """
        Sets the defined_metadata_list of this Model.
        An array of defined metadata details for the model.


        :param defined_metadata_list: The defined_metadata_list of this Model.
        :type: list[oci.data_science.models.Metadata]
        """
        self._defined_metadata_list = defined_metadata_list

    @property
    def input_schema(self):
        """
        Gets the input_schema of this Model.
        Input schema file content in String format


        :return: The input_schema of this Model.
        :rtype: str
        """
        return self._input_schema

    @input_schema.setter
    def input_schema(self, input_schema):
        """
        Sets the input_schema of this Model.
        Input schema file content in String format


        :param input_schema: The input_schema of this Model.
        :type: str
        """
        self._input_schema = input_schema

    @property
    def output_schema(self):
        """
        Gets the output_schema of this Model.
        Output schema file content in String format


        :return: The output_schema of this Model.
        :rtype: str
        """
        return self._output_schema

    @output_schema.setter
    def output_schema(self, output_schema):
        """
        Sets the output_schema of this Model.
        Output schema file content in String format


        :param output_schema: The output_schema of this Model.
        :type: str
        """
        self._output_schema = output_schema

    @property
    def model_version_set_id(self):
        """
        **[Required]** Gets the model_version_set_id of this Model.
        The OCID of the model version set that the model is associated to.


        :return: The model_version_set_id of this Model.
        :rtype: str
        """
        return self._model_version_set_id

    @model_version_set_id.setter
    def model_version_set_id(self, model_version_set_id):
        """
        Sets the model_version_set_id of this Model.
        The OCID of the model version set that the model is associated to.


        :param model_version_set_id: The model_version_set_id of this Model.
        :type: str
        """
        self._model_version_set_id = model_version_set_id

    @property
    def model_version_set_name(self):
        """
        **[Required]** Gets the model_version_set_name of this Model.
        The name of the model version set that the model is associated to.


        :return: The model_version_set_name of this Model.
        :rtype: str
        """
        return self._model_version_set_name

    @model_version_set_name.setter
    def model_version_set_name(self, model_version_set_name):
        """
        Sets the model_version_set_name of this Model.
        The name of the model version set that the model is associated to.


        :param model_version_set_name: The model_version_set_name of this Model.
        :type: str
        """
        self._model_version_set_name = model_version_set_name

    @property
    def version_id(self):
        """
        **[Required]** Gets the version_id of this Model.
        Unique identifier assigned to each version of the model.


        :return: The version_id of this Model.
        :rtype: int
        """
        return self._version_id

    @version_id.setter
    def version_id(self, version_id):
        """
        Sets the version_id of this Model.
        Unique identifier assigned to each version of the model.


        :param version_id: The version_id of this Model.
        :type: int
        """
        self._version_id = version_id

    @property
    def version_label(self):
        """
        **[Required]** Gets the version_label of this Model.
        The version label can add an additional description of the lifecycle state of the model or the application using and training the model.


        :return: The version_label of this Model.
        :rtype: str
        """
        return self._version_label

    @version_label.setter
    def version_label(self, version_label):
        """
        Sets the version_label of this Model.
        The version label can add an additional description of the lifecycle state of the model or the application using and training the model.


        :param version_label: The version_label of this Model.
        :type: str
        """
        self._version_label = version_label

    @property
    def retention_setting(self):
        """
        **[Required]** Gets the retention_setting of this Model.

        :return: The retention_setting of this Model.
        :rtype: oci.data_science.models.RetentionSetting
        """
        return self._retention_setting

    @retention_setting.setter
    def retention_setting(self, retention_setting):
        """
        Sets the retention_setting of this Model.

        :param retention_setting: The retention_setting of this Model.
        :type: oci.data_science.models.RetentionSetting
        """
        self._retention_setting = retention_setting

    @property
    def backup_setting(self):
        """
        **[Required]** Gets the backup_setting of this Model.

        :return: The backup_setting of this Model.
        :rtype: oci.data_science.models.BackupSetting
        """
        return self._backup_setting

    @backup_setting.setter
    def backup_setting(self, backup_setting):
        """
        Sets the backup_setting of this Model.

        :param backup_setting: The backup_setting of this Model.
        :type: oci.data_science.models.BackupSetting
        """
        self._backup_setting = backup_setting

    @property
    def retention_operation_details(self):
        """
        **[Required]** Gets the retention_operation_details of this Model.

        :return: The retention_operation_details of this Model.
        :rtype: oci.data_science.models.RetentionOperationDetails
        """
        return self._retention_operation_details

    @retention_operation_details.setter
    def retention_operation_details(self, retention_operation_details):
        """
        Sets the retention_operation_details of this Model.

        :param retention_operation_details: The retention_operation_details of this Model.
        :type: oci.data_science.models.RetentionOperationDetails
        """
        self._retention_operation_details = retention_operation_details

    @property
    def backup_operation_details(self):
        """
        **[Required]** Gets the backup_operation_details of this Model.

        :return: The backup_operation_details of this Model.
        :rtype: oci.data_science.models.BackupOperationDetails
        """
        return self._backup_operation_details

    @backup_operation_details.setter
    def backup_operation_details(self, backup_operation_details):
        """
        Sets the backup_operation_details of this Model.

        :param backup_operation_details: The backup_operation_details of this Model.
        :type: oci.data_science.models.BackupOperationDetails
        """
        self._backup_operation_details = backup_operation_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
