# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210415


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ContainerCapabilities(object):
    """
    Linux Container capabilities to configure capabilities of container.
    """

    #: A constant which can be used with the add_capabilities property of a ContainerCapabilities.
    #: This constant has a value of "CAP_CHOWN"
    ADD_CAPABILITIES_CAP_CHOWN = "CAP_CHOWN"

    #: A constant which can be used with the add_capabilities property of a ContainerCapabilities.
    #: This constant has a value of "CAP_DAC_OVERRIDE"
    ADD_CAPABILITIES_CAP_DAC_OVERRIDE = "CAP_DAC_OVERRIDE"

    #: A constant which can be used with the add_capabilities property of a ContainerCapabilities.
    #: This constant has a value of "CAP_FSETID"
    ADD_CAPABILITIES_CAP_FSETID = "CAP_FSETID"

    #: A constant which can be used with the add_capabilities property of a ContainerCapabilities.
    #: This constant has a value of "CAP_FOWNER"
    ADD_CAPABILITIES_CAP_FOWNER = "CAP_FOWNER"

    #: A constant which can be used with the add_capabilities property of a ContainerCapabilities.
    #: This constant has a value of "CAP_MKNOD"
    ADD_CAPABILITIES_CAP_MKNOD = "CAP_MKNOD"

    #: A constant which can be used with the add_capabilities property of a ContainerCapabilities.
    #: This constant has a value of "CAP_NET_RAW"
    ADD_CAPABILITIES_CAP_NET_RAW = "CAP_NET_RAW"

    #: A constant which can be used with the add_capabilities property of a ContainerCapabilities.
    #: This constant has a value of "CAP_SETGID"
    ADD_CAPABILITIES_CAP_SETGID = "CAP_SETGID"

    #: A constant which can be used with the add_capabilities property of a ContainerCapabilities.
    #: This constant has a value of "CAP_SETUID"
    ADD_CAPABILITIES_CAP_SETUID = "CAP_SETUID"

    #: A constant which can be used with the add_capabilities property of a ContainerCapabilities.
    #: This constant has a value of "CAP_SETFCAP"
    ADD_CAPABILITIES_CAP_SETFCAP = "CAP_SETFCAP"

    #: A constant which can be used with the add_capabilities property of a ContainerCapabilities.
    #: This constant has a value of "CAP_SETPCAP"
    ADD_CAPABILITIES_CAP_SETPCAP = "CAP_SETPCAP"

    #: A constant which can be used with the add_capabilities property of a ContainerCapabilities.
    #: This constant has a value of "CAP_NET_BIND_SERVICE"
    ADD_CAPABILITIES_CAP_NET_BIND_SERVICE = "CAP_NET_BIND_SERVICE"

    #: A constant which can be used with the add_capabilities property of a ContainerCapabilities.
    #: This constant has a value of "CAP_SYS_CHROOT"
    ADD_CAPABILITIES_CAP_SYS_CHROOT = "CAP_SYS_CHROOT"

    #: A constant which can be used with the add_capabilities property of a ContainerCapabilities.
    #: This constant has a value of "CAP_KILL"
    ADD_CAPABILITIES_CAP_KILL = "CAP_KILL"

    #: A constant which can be used with the add_capabilities property of a ContainerCapabilities.
    #: This constant has a value of "CAP_AUDIT_WRITE"
    ADD_CAPABILITIES_CAP_AUDIT_WRITE = "CAP_AUDIT_WRITE"

    #: A constant which can be used with the add_capabilities property of a ContainerCapabilities.
    #: This constant has a value of "ALL"
    ADD_CAPABILITIES_ALL = "ALL"

    #: A constant which can be used with the drop_capabilities property of a ContainerCapabilities.
    #: This constant has a value of "CAP_CHOWN"
    DROP_CAPABILITIES_CAP_CHOWN = "CAP_CHOWN"

    #: A constant which can be used with the drop_capabilities property of a ContainerCapabilities.
    #: This constant has a value of "CAP_DAC_OVERRIDE"
    DROP_CAPABILITIES_CAP_DAC_OVERRIDE = "CAP_DAC_OVERRIDE"

    #: A constant which can be used with the drop_capabilities property of a ContainerCapabilities.
    #: This constant has a value of "CAP_FSETID"
    DROP_CAPABILITIES_CAP_FSETID = "CAP_FSETID"

    #: A constant which can be used with the drop_capabilities property of a ContainerCapabilities.
    #: This constant has a value of "CAP_FOWNER"
    DROP_CAPABILITIES_CAP_FOWNER = "CAP_FOWNER"

    #: A constant which can be used with the drop_capabilities property of a ContainerCapabilities.
    #: This constant has a value of "CAP_MKNOD"
    DROP_CAPABILITIES_CAP_MKNOD = "CAP_MKNOD"

    #: A constant which can be used with the drop_capabilities property of a ContainerCapabilities.
    #: This constant has a value of "CAP_NET_RAW"
    DROP_CAPABILITIES_CAP_NET_RAW = "CAP_NET_RAW"

    #: A constant which can be used with the drop_capabilities property of a ContainerCapabilities.
    #: This constant has a value of "CAP_SETGID"
    DROP_CAPABILITIES_CAP_SETGID = "CAP_SETGID"

    #: A constant which can be used with the drop_capabilities property of a ContainerCapabilities.
    #: This constant has a value of "CAP_SETUID"
    DROP_CAPABILITIES_CAP_SETUID = "CAP_SETUID"

    #: A constant which can be used with the drop_capabilities property of a ContainerCapabilities.
    #: This constant has a value of "CAP_SETFCAP"
    DROP_CAPABILITIES_CAP_SETFCAP = "CAP_SETFCAP"

    #: A constant which can be used with the drop_capabilities property of a ContainerCapabilities.
    #: This constant has a value of "CAP_SETPCAP"
    DROP_CAPABILITIES_CAP_SETPCAP = "CAP_SETPCAP"

    #: A constant which can be used with the drop_capabilities property of a ContainerCapabilities.
    #: This constant has a value of "CAP_NET_BIND_SERVICE"
    DROP_CAPABILITIES_CAP_NET_BIND_SERVICE = "CAP_NET_BIND_SERVICE"

    #: A constant which can be used with the drop_capabilities property of a ContainerCapabilities.
    #: This constant has a value of "CAP_SYS_CHROOT"
    DROP_CAPABILITIES_CAP_SYS_CHROOT = "CAP_SYS_CHROOT"

    #: A constant which can be used with the drop_capabilities property of a ContainerCapabilities.
    #: This constant has a value of "CAP_KILL"
    DROP_CAPABILITIES_CAP_KILL = "CAP_KILL"

    #: A constant which can be used with the drop_capabilities property of a ContainerCapabilities.
    #: This constant has a value of "CAP_AUDIT_WRITE"
    DROP_CAPABILITIES_CAP_AUDIT_WRITE = "CAP_AUDIT_WRITE"

    #: A constant which can be used with the drop_capabilities property of a ContainerCapabilities.
    #: This constant has a value of "ALL"
    DROP_CAPABILITIES_ALL = "ALL"

    def __init__(self, **kwargs):
        """
        Initializes a new ContainerCapabilities object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param add_capabilities:
            The value to assign to the add_capabilities property of this ContainerCapabilities.
            Allowed values for items in this list are: "CAP_CHOWN", "CAP_DAC_OVERRIDE", "CAP_FSETID", "CAP_FOWNER", "CAP_MKNOD", "CAP_NET_RAW", "CAP_SETGID", "CAP_SETUID", "CAP_SETFCAP", "CAP_SETPCAP", "CAP_NET_BIND_SERVICE", "CAP_SYS_CHROOT", "CAP_KILL", "CAP_AUDIT_WRITE", "ALL", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type add_capabilities: list[str]

        :param drop_capabilities:
            The value to assign to the drop_capabilities property of this ContainerCapabilities.
            Allowed values for items in this list are: "CAP_CHOWN", "CAP_DAC_OVERRIDE", "CAP_FSETID", "CAP_FOWNER", "CAP_MKNOD", "CAP_NET_RAW", "CAP_SETGID", "CAP_SETUID", "CAP_SETFCAP", "CAP_SETPCAP", "CAP_NET_BIND_SERVICE", "CAP_SYS_CHROOT", "CAP_KILL", "CAP_AUDIT_WRITE", "ALL", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type drop_capabilities: list[str]

        """
        self.swagger_types = {
            'add_capabilities': 'list[str]',
            'drop_capabilities': 'list[str]'
        }

        self.attribute_map = {
            'add_capabilities': 'addCapabilities',
            'drop_capabilities': 'dropCapabilities'
        }

        self._add_capabilities = None
        self._drop_capabilities = None

    @property
    def add_capabilities(self):
        """
        Gets the add_capabilities of this ContainerCapabilities.
        A list of additional configurable container capabilities.

        Allowed values for items in this list are: "CAP_CHOWN", "CAP_DAC_OVERRIDE", "CAP_FSETID", "CAP_FOWNER", "CAP_MKNOD", "CAP_NET_RAW", "CAP_SETGID", "CAP_SETUID", "CAP_SETFCAP", "CAP_SETPCAP", "CAP_NET_BIND_SERVICE", "CAP_SYS_CHROOT", "CAP_KILL", "CAP_AUDIT_WRITE", "ALL", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The add_capabilities of this ContainerCapabilities.
        :rtype: list[str]
        """
        return self._add_capabilities

    @add_capabilities.setter
    def add_capabilities(self, add_capabilities):
        """
        Sets the add_capabilities of this ContainerCapabilities.
        A list of additional configurable container capabilities.


        :param add_capabilities: The add_capabilities of this ContainerCapabilities.
        :type: list[str]
        """
        allowed_values = ["CAP_CHOWN", "CAP_DAC_OVERRIDE", "CAP_FSETID", "CAP_FOWNER", "CAP_MKNOD", "CAP_NET_RAW", "CAP_SETGID", "CAP_SETUID", "CAP_SETFCAP", "CAP_SETPCAP", "CAP_NET_BIND_SERVICE", "CAP_SYS_CHROOT", "CAP_KILL", "CAP_AUDIT_WRITE", "ALL"]
        if add_capabilities:
            add_capabilities[:] = ['UNKNOWN_ENUM_VALUE' if not value_allowed_none_or_none_sentinel(x, allowed_values) else x for x in add_capabilities]
        self._add_capabilities = add_capabilities

    @property
    def drop_capabilities(self):
        """
        Gets the drop_capabilities of this ContainerCapabilities.
        A list of container capabilities that can be dropped.

        Allowed values for items in this list are: "CAP_CHOWN", "CAP_DAC_OVERRIDE", "CAP_FSETID", "CAP_FOWNER", "CAP_MKNOD", "CAP_NET_RAW", "CAP_SETGID", "CAP_SETUID", "CAP_SETFCAP", "CAP_SETPCAP", "CAP_NET_BIND_SERVICE", "CAP_SYS_CHROOT", "CAP_KILL", "CAP_AUDIT_WRITE", "ALL", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The drop_capabilities of this ContainerCapabilities.
        :rtype: list[str]
        """
        return self._drop_capabilities

    @drop_capabilities.setter
    def drop_capabilities(self, drop_capabilities):
        """
        Sets the drop_capabilities of this ContainerCapabilities.
        A list of container capabilities that can be dropped.


        :param drop_capabilities: The drop_capabilities of this ContainerCapabilities.
        :type: list[str]
        """
        allowed_values = ["CAP_CHOWN", "CAP_DAC_OVERRIDE", "CAP_FSETID", "CAP_FOWNER", "CAP_MKNOD", "CAP_NET_RAW", "CAP_SETGID", "CAP_SETUID", "CAP_SETFCAP", "CAP_SETPCAP", "CAP_NET_BIND_SERVICE", "CAP_SYS_CHROOT", "CAP_KILL", "CAP_AUDIT_WRITE", "ALL"]
        if drop_capabilities:
            drop_capabilities[:] = ['UNKNOWN_ENUM_VALUE' if not value_allowed_none_or_none_sentinel(x, allowed_values) else x for x in drop_capabilities]
        self._drop_capabilities = drop_capabilities

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
