# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200131


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SightingEndpointSummary(object):
    """
    A summary of sighting endpoints.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new SightingEndpointSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this SightingEndpointSummary.
        :type id: str

        :param sighting_id:
            The value to assign to the sighting_id property of this SightingEndpointSummary.
        :type sighting_id: str

        :param problem_id:
            The value to assign to the problem_id property of this SightingEndpointSummary.
        :type problem_id: str

        :param ip_address:
            The value to assign to the ip_address property of this SightingEndpointSummary.
        :type ip_address: str

        :param ip_address_type:
            The value to assign to the ip_address_type property of this SightingEndpointSummary.
        :type ip_address_type: str

        :param ip_classification_type:
            The value to assign to the ip_classification_type property of this SightingEndpointSummary.
        :type ip_classification_type: str

        :param country:
            The value to assign to the country property of this SightingEndpointSummary.
        :type country: str

        :param latitude:
            The value to assign to the latitude property of this SightingEndpointSummary.
        :type latitude: float

        :param longitude:
            The value to assign to the longitude property of this SightingEndpointSummary.
        :type longitude: float

        :param asn_number:
            The value to assign to the asn_number property of this SightingEndpointSummary.
        :type asn_number: str

        :param regions:
            The value to assign to the regions property of this SightingEndpointSummary.
        :type regions: list[str]

        :param services:
            The value to assign to the services property of this SightingEndpointSummary.
        :type services: list[str]

        :param time_first_detected:
            The value to assign to the time_first_detected property of this SightingEndpointSummary.
        :type time_first_detected: datetime

        :param time_last_detected:
            The value to assign to the time_last_detected property of this SightingEndpointSummary.
        :type time_last_detected: datetime

        :param time_first_occurred:
            The value to assign to the time_first_occurred property of this SightingEndpointSummary.
        :type time_first_occurred: datetime

        :param time_last_occurred:
            The value to assign to the time_last_occurred property of this SightingEndpointSummary.
        :type time_last_occurred: datetime

        """
        self.swagger_types = {
            'id': 'str',
            'sighting_id': 'str',
            'problem_id': 'str',
            'ip_address': 'str',
            'ip_address_type': 'str',
            'ip_classification_type': 'str',
            'country': 'str',
            'latitude': 'float',
            'longitude': 'float',
            'asn_number': 'str',
            'regions': 'list[str]',
            'services': 'list[str]',
            'time_first_detected': 'datetime',
            'time_last_detected': 'datetime',
            'time_first_occurred': 'datetime',
            'time_last_occurred': 'datetime'
        }

        self.attribute_map = {
            'id': 'id',
            'sighting_id': 'sightingId',
            'problem_id': 'problemId',
            'ip_address': 'ipAddress',
            'ip_address_type': 'ipAddressType',
            'ip_classification_type': 'ipClassificationType',
            'country': 'country',
            'latitude': 'latitude',
            'longitude': 'longitude',
            'asn_number': 'asnNumber',
            'regions': 'regions',
            'services': 'services',
            'time_first_detected': 'timeFirstDetected',
            'time_last_detected': 'timeLastDetected',
            'time_first_occurred': 'timeFirstOccurred',
            'time_last_occurred': 'timeLastOccurred'
        }

        self._id = None
        self._sighting_id = None
        self._problem_id = None
        self._ip_address = None
        self._ip_address_type = None
        self._ip_classification_type = None
        self._country = None
        self._latitude = None
        self._longitude = None
        self._asn_number = None
        self._regions = None
        self._services = None
        self._time_first_detected = None
        self._time_last_detected = None
        self._time_first_occurred = None
        self._time_last_occurred = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this SightingEndpointSummary.
        Unique identifier for sighting endpoints


        :return: The id of this SightingEndpointSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this SightingEndpointSummary.
        Unique identifier for sighting endpoints


        :param id: The id of this SightingEndpointSummary.
        :type: str
        """
        self._id = id

    @property
    def sighting_id(self):
        """
        **[Required]** Gets the sighting_id of this SightingEndpointSummary.
        Sighting ID for sighting endpoints


        :return: The sighting_id of this SightingEndpointSummary.
        :rtype: str
        """
        return self._sighting_id

    @sighting_id.setter
    def sighting_id(self, sighting_id):
        """
        Sets the sighting_id of this SightingEndpointSummary.
        Sighting ID for sighting endpoints


        :param sighting_id: The sighting_id of this SightingEndpointSummary.
        :type: str
        """
        self._sighting_id = sighting_id

    @property
    def problem_id(self):
        """
        Gets the problem_id of this SightingEndpointSummary.
        Problem ID for sighting endpoints


        :return: The problem_id of this SightingEndpointSummary.
        :rtype: str
        """
        return self._problem_id

    @problem_id.setter
    def problem_id(self, problem_id):
        """
        Sets the problem_id of this SightingEndpointSummary.
        Problem ID for sighting endpoints


        :param problem_id: The problem_id of this SightingEndpointSummary.
        :type: str
        """
        self._problem_id = problem_id

    @property
    def ip_address(self):
        """
        **[Required]** Gets the ip_address of this SightingEndpointSummary.
        IP address involved in sighting


        :return: The ip_address of this SightingEndpointSummary.
        :rtype: str
        """
        return self._ip_address

    @ip_address.setter
    def ip_address(self, ip_address):
        """
        Sets the ip_address of this SightingEndpointSummary.
        IP address involved in sighting


        :param ip_address: The ip_address of this SightingEndpointSummary.
        :type: str
        """
        self._ip_address = ip_address

    @property
    def ip_address_type(self):
        """
        **[Required]** Gets the ip_address_type of this SightingEndpointSummary.
        Type of IP address involved in sighting


        :return: The ip_address_type of this SightingEndpointSummary.
        :rtype: str
        """
        return self._ip_address_type

    @ip_address_type.setter
    def ip_address_type(self, ip_address_type):
        """
        Sets the ip_address_type of this SightingEndpointSummary.
        Type of IP address involved in sighting


        :param ip_address_type: The ip_address_type of this SightingEndpointSummary.
        :type: str
        """
        self._ip_address_type = ip_address_type

    @property
    def ip_classification_type(self):
        """
        Gets the ip_classification_type of this SightingEndpointSummary.
        IP address classification type


        :return: The ip_classification_type of this SightingEndpointSummary.
        :rtype: str
        """
        return self._ip_classification_type

    @ip_classification_type.setter
    def ip_classification_type(self, ip_classification_type):
        """
        Sets the ip_classification_type of this SightingEndpointSummary.
        IP address classification type


        :param ip_classification_type: The ip_classification_type of this SightingEndpointSummary.
        :type: str
        """
        self._ip_classification_type = ip_classification_type

    @property
    def country(self):
        """
        Gets the country of this SightingEndpointSummary.
        Country involved in sighting


        :return: The country of this SightingEndpointSummary.
        :rtype: str
        """
        return self._country

    @country.setter
    def country(self, country):
        """
        Sets the country of this SightingEndpointSummary.
        Country involved in sighting


        :param country: The country of this SightingEndpointSummary.
        :type: str
        """
        self._country = country

    @property
    def latitude(self):
        """
        Gets the latitude of this SightingEndpointSummary.
        Latitude of sighting


        :return: The latitude of this SightingEndpointSummary.
        :rtype: float
        """
        return self._latitude

    @latitude.setter
    def latitude(self, latitude):
        """
        Sets the latitude of this SightingEndpointSummary.
        Latitude of sighting


        :param latitude: The latitude of this SightingEndpointSummary.
        :type: float
        """
        self._latitude = latitude

    @property
    def longitude(self):
        """
        Gets the longitude of this SightingEndpointSummary.
        Longitude of sighting


        :return: The longitude of this SightingEndpointSummary.
        :rtype: float
        """
        return self._longitude

    @longitude.setter
    def longitude(self, longitude):
        """
        Sets the longitude of this SightingEndpointSummary.
        Longitude of sighting


        :param longitude: The longitude of this SightingEndpointSummary.
        :type: float
        """
        self._longitude = longitude

    @property
    def asn_number(self):
        """
        Gets the asn_number of this SightingEndpointSummary.
        ASN number of sighting


        :return: The asn_number of this SightingEndpointSummary.
        :rtype: str
        """
        return self._asn_number

    @asn_number.setter
    def asn_number(self, asn_number):
        """
        Sets the asn_number of this SightingEndpointSummary.
        ASN number of sighting


        :param asn_number: The asn_number of this SightingEndpointSummary.
        :type: str
        """
        self._asn_number = asn_number

    @property
    def regions(self):
        """
        Gets the regions of this SightingEndpointSummary.
        List of regions where activities were performed from this IP address


        :return: The regions of this SightingEndpointSummary.
        :rtype: list[str]
        """
        return self._regions

    @regions.setter
    def regions(self, regions):
        """
        Sets the regions of this SightingEndpointSummary.
        List of regions where activities were performed from this IP address


        :param regions: The regions of this SightingEndpointSummary.
        :type: list[str]
        """
        self._regions = regions

    @property
    def services(self):
        """
        Gets the services of this SightingEndpointSummary.
        List of services where activities were performed from this IP address


        :return: The services of this SightingEndpointSummary.
        :rtype: list[str]
        """
        return self._services

    @services.setter
    def services(self, services):
        """
        Sets the services of this SightingEndpointSummary.
        List of services where activities were performed from this IP address


        :param services: The services of this SightingEndpointSummary.
        :type: list[str]
        """
        self._services = services

    @property
    def time_first_detected(self):
        """
        Gets the time_first_detected of this SightingEndpointSummary.
        Time the activities were first detected.


        :return: The time_first_detected of this SightingEndpointSummary.
        :rtype: datetime
        """
        return self._time_first_detected

    @time_first_detected.setter
    def time_first_detected(self, time_first_detected):
        """
        Sets the time_first_detected of this SightingEndpointSummary.
        Time the activities were first detected.


        :param time_first_detected: The time_first_detected of this SightingEndpointSummary.
        :type: datetime
        """
        self._time_first_detected = time_first_detected

    @property
    def time_last_detected(self):
        """
        **[Required]** Gets the time_last_detected of this SightingEndpointSummary.
        Time the activities were last detected.


        :return: The time_last_detected of this SightingEndpointSummary.
        :rtype: datetime
        """
        return self._time_last_detected

    @time_last_detected.setter
    def time_last_detected(self, time_last_detected):
        """
        Sets the time_last_detected of this SightingEndpointSummary.
        Time the activities were last detected.


        :param time_last_detected: The time_last_detected of this SightingEndpointSummary.
        :type: datetime
        """
        self._time_last_detected = time_last_detected

    @property
    def time_first_occurred(self):
        """
        Gets the time_first_occurred of this SightingEndpointSummary.
        Time the activities were first performed.


        :return: The time_first_occurred of this SightingEndpointSummary.
        :rtype: datetime
        """
        return self._time_first_occurred

    @time_first_occurred.setter
    def time_first_occurred(self, time_first_occurred):
        """
        Sets the time_first_occurred of this SightingEndpointSummary.
        Time the activities were first performed.


        :param time_first_occurred: The time_first_occurred of this SightingEndpointSummary.
        :type: datetime
        """
        self._time_first_occurred = time_first_occurred

    @property
    def time_last_occurred(self):
        """
        Gets the time_last_occurred of this SightingEndpointSummary.
        Time the activities were last performed.


        :return: The time_last_occurred of this SightingEndpointSummary.
        :rtype: datetime
        """
        return self._time_last_occurred

    @time_last_occurred.setter
    def time_last_occurred(self, time_last_occurred):
        """
        Sets the time_last_occurred of this SightingEndpointSummary.
        Time the activities were last performed.


        :param time_last_occurred: The time_last_occurred of this SightingEndpointSummary.
        :type: datetime
        """
        self._time_last_occurred = time_last_occurred

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
