# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220509

from .update_asset_source_details import UpdateAssetSourceDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateAwsAssetSourceDetails(UpdateAssetSourceDetails):
    """
    AWS asset source update request.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateAwsAssetSourceDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.cloud_bridge.models.UpdateAwsAssetSourceDetails.type` attribute
        of this class is ``AWS`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this UpdateAwsAssetSourceDetails.
            Allowed values for this property are: "VMWARE", "AWS"
        :type type: str

        :param display_name:
            The value to assign to the display_name property of this UpdateAwsAssetSourceDetails.
        :type display_name: str

        :param assets_compartment_id:
            The value to assign to the assets_compartment_id property of this UpdateAwsAssetSourceDetails.
        :type assets_compartment_id: str

        :param discovery_schedule_id:
            The value to assign to the discovery_schedule_id property of this UpdateAwsAssetSourceDetails.
        :type discovery_schedule_id: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateAwsAssetSourceDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateAwsAssetSourceDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this UpdateAwsAssetSourceDetails.
        :type system_tags: dict(str, dict(str, object))

        :param discovery_credentials:
            The value to assign to the discovery_credentials property of this UpdateAwsAssetSourceDetails.
        :type discovery_credentials: oci.cloud_bridge.models.AssetSourceCredentials

        :param replication_credentials:
            The value to assign to the replication_credentials property of this UpdateAwsAssetSourceDetails.
        :type replication_credentials: oci.cloud_bridge.models.AssetSourceCredentials

        :param are_historical_metrics_collected:
            The value to assign to the are_historical_metrics_collected property of this UpdateAwsAssetSourceDetails.
        :type are_historical_metrics_collected: bool

        :param are_realtime_metrics_collected:
            The value to assign to the are_realtime_metrics_collected property of this UpdateAwsAssetSourceDetails.
        :type are_realtime_metrics_collected: bool

        :param is_cost_information_collected:
            The value to assign to the is_cost_information_collected property of this UpdateAwsAssetSourceDetails.
        :type is_cost_information_collected: bool

        """
        self.swagger_types = {
            'type': 'str',
            'display_name': 'str',
            'assets_compartment_id': 'str',
            'discovery_schedule_id': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))',
            'discovery_credentials': 'AssetSourceCredentials',
            'replication_credentials': 'AssetSourceCredentials',
            'are_historical_metrics_collected': 'bool',
            'are_realtime_metrics_collected': 'bool',
            'is_cost_information_collected': 'bool'
        }

        self.attribute_map = {
            'type': 'type',
            'display_name': 'displayName',
            'assets_compartment_id': 'assetsCompartmentId',
            'discovery_schedule_id': 'discoveryScheduleId',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags',
            'discovery_credentials': 'discoveryCredentials',
            'replication_credentials': 'replicationCredentials',
            'are_historical_metrics_collected': 'areHistoricalMetricsCollected',
            'are_realtime_metrics_collected': 'areRealtimeMetricsCollected',
            'is_cost_information_collected': 'isCostInformationCollected'
        }

        self._type = None
        self._display_name = None
        self._assets_compartment_id = None
        self._discovery_schedule_id = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None
        self._discovery_credentials = None
        self._replication_credentials = None
        self._are_historical_metrics_collected = None
        self._are_realtime_metrics_collected = None
        self._is_cost_information_collected = None
        self._type = 'AWS'

    @property
    def discovery_credentials(self):
        """
        Gets the discovery_credentials of this UpdateAwsAssetSourceDetails.

        :return: The discovery_credentials of this UpdateAwsAssetSourceDetails.
        :rtype: oci.cloud_bridge.models.AssetSourceCredentials
        """
        return self._discovery_credentials

    @discovery_credentials.setter
    def discovery_credentials(self, discovery_credentials):
        """
        Sets the discovery_credentials of this UpdateAwsAssetSourceDetails.

        :param discovery_credentials: The discovery_credentials of this UpdateAwsAssetSourceDetails.
        :type: oci.cloud_bridge.models.AssetSourceCredentials
        """
        self._discovery_credentials = discovery_credentials

    @property
    def replication_credentials(self):
        """
        Gets the replication_credentials of this UpdateAwsAssetSourceDetails.

        :return: The replication_credentials of this UpdateAwsAssetSourceDetails.
        :rtype: oci.cloud_bridge.models.AssetSourceCredentials
        """
        return self._replication_credentials

    @replication_credentials.setter
    def replication_credentials(self, replication_credentials):
        """
        Sets the replication_credentials of this UpdateAwsAssetSourceDetails.

        :param replication_credentials: The replication_credentials of this UpdateAwsAssetSourceDetails.
        :type: oci.cloud_bridge.models.AssetSourceCredentials
        """
        self._replication_credentials = replication_credentials

    @property
    def are_historical_metrics_collected(self):
        """
        Gets the are_historical_metrics_collected of this UpdateAwsAssetSourceDetails.
        Flag indicating whether historical metrics are collected for assets, originating from this asset source.


        :return: The are_historical_metrics_collected of this UpdateAwsAssetSourceDetails.
        :rtype: bool
        """
        return self._are_historical_metrics_collected

    @are_historical_metrics_collected.setter
    def are_historical_metrics_collected(self, are_historical_metrics_collected):
        """
        Sets the are_historical_metrics_collected of this UpdateAwsAssetSourceDetails.
        Flag indicating whether historical metrics are collected for assets, originating from this asset source.


        :param are_historical_metrics_collected: The are_historical_metrics_collected of this UpdateAwsAssetSourceDetails.
        :type: bool
        """
        self._are_historical_metrics_collected = are_historical_metrics_collected

    @property
    def are_realtime_metrics_collected(self):
        """
        Gets the are_realtime_metrics_collected of this UpdateAwsAssetSourceDetails.
        Flag indicating whether real-time metrics are collected for assets, originating from this asset source.


        :return: The are_realtime_metrics_collected of this UpdateAwsAssetSourceDetails.
        :rtype: bool
        """
        return self._are_realtime_metrics_collected

    @are_realtime_metrics_collected.setter
    def are_realtime_metrics_collected(self, are_realtime_metrics_collected):
        """
        Sets the are_realtime_metrics_collected of this UpdateAwsAssetSourceDetails.
        Flag indicating whether real-time metrics are collected for assets, originating from this asset source.


        :param are_realtime_metrics_collected: The are_realtime_metrics_collected of this UpdateAwsAssetSourceDetails.
        :type: bool
        """
        self._are_realtime_metrics_collected = are_realtime_metrics_collected

    @property
    def is_cost_information_collected(self):
        """
        Gets the is_cost_information_collected of this UpdateAwsAssetSourceDetails.
        Flag indicating whether cost data collection is enabled for assets, originating from this asset source.


        :return: The is_cost_information_collected of this UpdateAwsAssetSourceDetails.
        :rtype: bool
        """
        return self._is_cost_information_collected

    @is_cost_information_collected.setter
    def is_cost_information_collected(self, is_cost_information_collected):
        """
        Sets the is_cost_information_collected of this UpdateAwsAssetSourceDetails.
        Flag indicating whether cost data collection is enabled for assets, originating from this asset source.


        :param is_cost_information_collected: The is_cost_information_collected of this UpdateAwsAssetSourceDetails.
        :type: bool
        """
        self._is_cost_information_collected = is_cost_information_collected

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
