# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220509


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class InstanceState(object):
    """
    Describes the current state of an instance.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new InstanceState object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param code:
            The value to assign to the code property of this InstanceState.
        :type code: int

        :param name:
            The value to assign to the name property of this InstanceState.
        :type name: str

        """
        self.swagger_types = {
            'code': 'int',
            'name': 'str'
        }

        self.attribute_map = {
            'code': 'code',
            'name': 'name'
        }

        self._code = None
        self._name = None

    @property
    def code(self):
        """
        Gets the code of this InstanceState.
        The state of the instance as a 16-bit unsigned integer.


        :return: The code of this InstanceState.
        :rtype: int
        """
        return self._code

    @code.setter
    def code(self, code):
        """
        Sets the code of this InstanceState.
        The state of the instance as a 16-bit unsigned integer.


        :param code: The code of this InstanceState.
        :type: int
        """
        self._code = code

    @property
    def name(self):
        """
        Gets the name of this InstanceState.
        The current state of the instance.


        :return: The name of this InstanceState.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this InstanceState.
        The current state of the instance.


        :param name: The name of this InstanceState.
        :type: str
        """
        self._name = name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
