# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181231


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SubscriptionInfo(object):
    """
    SubscriptionInfo model.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new SubscriptionInfo object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param csi:
            The value to assign to the csi property of this SubscriptionInfo.
        :type csi: str

        :param subscription_type:
            The value to assign to the subscription_type property of this SubscriptionInfo.
        :type subscription_type: str

        """
        self.swagger_types = {
            'csi': 'str',
            'subscription_type': 'str'
        }

        self.attribute_map = {
            'csi': 'csi',
            'subscription_type': 'subscriptionType'
        }

        self._csi = None
        self._subscription_type = None

    @property
    def csi(self):
        """
        Gets the csi of this SubscriptionInfo.
        customer support identifier issued for a subscription


        :return: The csi of this SubscriptionInfo.
        :rtype: str
        """
        return self._csi

    @csi.setter
    def csi(self, csi):
        """
        Sets the csi of this SubscriptionInfo.
        customer support identifier issued for a subscription


        :param csi: The csi of this SubscriptionInfo.
        :type: str
        """
        self._csi = csi

    @property
    def subscription_type(self):
        """
        Gets the subscription_type of this SubscriptionInfo.
        subscription type of customer which determines payment profile


        :return: The subscription_type of this SubscriptionInfo.
        :rtype: str
        """
        return self._subscription_type

    @subscription_type.setter
    def subscription_type(self, subscription_type):
        """
        Sets the subscription_type of this SubscriptionInfo.
        subscription type of customer which determines payment profile


        :param subscription_type: The subscription_type of this SubscriptionInfo.
        :type: str
        """
        self._subscription_type = subscription_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
