# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231107


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OccCapacityRequestBaseDetails(object):
    """
    The details of the create capacity request. This model serves as a base for different namespaces.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new OccCapacityRequestBaseDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param resource_type:
            The value to assign to the resource_type property of this OccCapacityRequestBaseDetails.
        :type resource_type: str

        :param workload_type:
            The value to assign to the workload_type property of this OccCapacityRequestBaseDetails.
        :type workload_type: str

        :param source_workload_type:
            The value to assign to the source_workload_type property of this OccCapacityRequestBaseDetails.
        :type source_workload_type: str

        :param expected_handover_quantity:
            The value to assign to the expected_handover_quantity property of this OccCapacityRequestBaseDetails.
        :type expected_handover_quantity: int

        :param date_expected_handover:
            The value to assign to the date_expected_handover property of this OccCapacityRequestBaseDetails.
        :type date_expected_handover: datetime

        :param actual_handover_quantity:
            The value to assign to the actual_handover_quantity property of this OccCapacityRequestBaseDetails.
        :type actual_handover_quantity: int

        :param date_actual_handover:
            The value to assign to the date_actual_handover property of this OccCapacityRequestBaseDetails.
        :type date_actual_handover: datetime

        :param availability_domain:
            The value to assign to the availability_domain property of this OccCapacityRequestBaseDetails.
        :type availability_domain: str

        :param associated_occ_handover_resource_block_list:
            The value to assign to the associated_occ_handover_resource_block_list property of this OccCapacityRequestBaseDetails.
        :type associated_occ_handover_resource_block_list: list[oci.capacity_management.models.AssociatedOccHandoverResourceBlock]

        :param resource_name:
            The value to assign to the resource_name property of this OccCapacityRequestBaseDetails.
        :type resource_name: str

        :param demand_quantity:
            The value to assign to the demand_quantity property of this OccCapacityRequestBaseDetails.
        :type demand_quantity: int

        """
        self.swagger_types = {
            'resource_type': 'str',
            'workload_type': 'str',
            'source_workload_type': 'str',
            'expected_handover_quantity': 'int',
            'date_expected_handover': 'datetime',
            'actual_handover_quantity': 'int',
            'date_actual_handover': 'datetime',
            'availability_domain': 'str',
            'associated_occ_handover_resource_block_list': 'list[AssociatedOccHandoverResourceBlock]',
            'resource_name': 'str',
            'demand_quantity': 'int'
        }

        self.attribute_map = {
            'resource_type': 'resourceType',
            'workload_type': 'workloadType',
            'source_workload_type': 'sourceWorkloadType',
            'expected_handover_quantity': 'expectedHandoverQuantity',
            'date_expected_handover': 'dateExpectedHandover',
            'actual_handover_quantity': 'actualHandoverQuantity',
            'date_actual_handover': 'dateActualHandover',
            'availability_domain': 'availabilityDomain',
            'associated_occ_handover_resource_block_list': 'associatedOccHandoverResourceBlockList',
            'resource_name': 'resourceName',
            'demand_quantity': 'demandQuantity'
        }

        self._resource_type = None
        self._workload_type = None
        self._source_workload_type = None
        self._expected_handover_quantity = None
        self._date_expected_handover = None
        self._actual_handover_quantity = None
        self._date_actual_handover = None
        self._availability_domain = None
        self._associated_occ_handover_resource_block_list = None
        self._resource_name = None
        self._demand_quantity = None

    @property
    def resource_type(self):
        """
        **[Required]** Gets the resource_type of this OccCapacityRequestBaseDetails.
        The type of the resource against which the user wants to place a capacity request.


        :return: The resource_type of this OccCapacityRequestBaseDetails.
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """
        Sets the resource_type of this OccCapacityRequestBaseDetails.
        The type of the resource against which the user wants to place a capacity request.


        :param resource_type: The resource_type of this OccCapacityRequestBaseDetails.
        :type: str
        """
        self._resource_type = resource_type

    @property
    def workload_type(self):
        """
        **[Required]** Gets the workload_type of this OccCapacityRequestBaseDetails.
        The type of the workload (Generic/ROW).


        :return: The workload_type of this OccCapacityRequestBaseDetails.
        :rtype: str
        """
        return self._workload_type

    @workload_type.setter
    def workload_type(self, workload_type):
        """
        Sets the workload_type of this OccCapacityRequestBaseDetails.
        The type of the workload (Generic/ROW).


        :param workload_type: The workload_type of this OccCapacityRequestBaseDetails.
        :type: str
        """
        self._workload_type = workload_type

    @property
    def source_workload_type(self):
        """
        Gets the source_workload_type of this OccCapacityRequestBaseDetails.
        The WorkloadType from where capacity request are to be transferred.


        :return: The source_workload_type of this OccCapacityRequestBaseDetails.
        :rtype: str
        """
        return self._source_workload_type

    @source_workload_type.setter
    def source_workload_type(self, source_workload_type):
        """
        Sets the source_workload_type of this OccCapacityRequestBaseDetails.
        The WorkloadType from where capacity request are to be transferred.


        :param source_workload_type: The source_workload_type of this OccCapacityRequestBaseDetails.
        :type: str
        """
        self._source_workload_type = source_workload_type

    @property
    def expected_handover_quantity(self):
        """
        Gets the expected_handover_quantity of this OccCapacityRequestBaseDetails.
        The incremental quantity of resources supplied as the provisioning is underway.


        :return: The expected_handover_quantity of this OccCapacityRequestBaseDetails.
        :rtype: int
        """
        return self._expected_handover_quantity

    @expected_handover_quantity.setter
    def expected_handover_quantity(self, expected_handover_quantity):
        """
        Sets the expected_handover_quantity of this OccCapacityRequestBaseDetails.
        The incremental quantity of resources supplied as the provisioning is underway.


        :param expected_handover_quantity: The expected_handover_quantity of this OccCapacityRequestBaseDetails.
        :type: int
        """
        self._expected_handover_quantity = expected_handover_quantity

    @property
    def date_expected_handover(self):
        """
        Gets the date_expected_handover of this OccCapacityRequestBaseDetails.
        The date on which the latest increment to supplied quantity of resources was delivered.


        :return: The date_expected_handover of this OccCapacityRequestBaseDetails.
        :rtype: datetime
        """
        return self._date_expected_handover

    @date_expected_handover.setter
    def date_expected_handover(self, date_expected_handover):
        """
        Sets the date_expected_handover of this OccCapacityRequestBaseDetails.
        The date on which the latest increment to supplied quantity of resources was delivered.


        :param date_expected_handover: The date_expected_handover of this OccCapacityRequestBaseDetails.
        :type: datetime
        """
        self._date_expected_handover = date_expected_handover

    @property
    def actual_handover_quantity(self):
        """
        Gets the actual_handover_quantity of this OccCapacityRequestBaseDetails.
        The actual handed over quantity of resources at the time of request resolution.


        :return: The actual_handover_quantity of this OccCapacityRequestBaseDetails.
        :rtype: int
        """
        return self._actual_handover_quantity

    @actual_handover_quantity.setter
    def actual_handover_quantity(self, actual_handover_quantity):
        """
        Sets the actual_handover_quantity of this OccCapacityRequestBaseDetails.
        The actual handed over quantity of resources at the time of request resolution.


        :param actual_handover_quantity: The actual_handover_quantity of this OccCapacityRequestBaseDetails.
        :type: int
        """
        self._actual_handover_quantity = actual_handover_quantity

    @property
    def date_actual_handover(self):
        """
        Gets the date_actual_handover of this OccCapacityRequestBaseDetails.
        The date on which the actual handover quantity of resources is delivered.


        :return: The date_actual_handover of this OccCapacityRequestBaseDetails.
        :rtype: datetime
        """
        return self._date_actual_handover

    @date_actual_handover.setter
    def date_actual_handover(self, date_actual_handover):
        """
        Sets the date_actual_handover of this OccCapacityRequestBaseDetails.
        The date on which the actual handover quantity of resources is delivered.


        :param date_actual_handover: The date_actual_handover of this OccCapacityRequestBaseDetails.
        :type: datetime
        """
        self._date_actual_handover = date_actual_handover

    @property
    def availability_domain(self):
        """
        Gets the availability_domain of this OccCapacityRequestBaseDetails.
        The availability domain of the resource which is to be transferred. Note that this is only required for Capacity Request Transfer requests.


        :return: The availability_domain of this OccCapacityRequestBaseDetails.
        :rtype: str
        """
        return self._availability_domain

    @availability_domain.setter
    def availability_domain(self, availability_domain):
        """
        Sets the availability_domain of this OccCapacityRequestBaseDetails.
        The availability domain of the resource which is to be transferred. Note that this is only required for Capacity Request Transfer requests.


        :param availability_domain: The availability_domain of this OccCapacityRequestBaseDetails.
        :type: str
        """
        self._availability_domain = availability_domain

    @property
    def associated_occ_handover_resource_block_list(self):
        """
        Gets the associated_occ_handover_resource_block_list of this OccCapacityRequestBaseDetails.
        A list containing details about occHandoverResourceBlocks which were handed over for the corresponding resource name.


        :return: The associated_occ_handover_resource_block_list of this OccCapacityRequestBaseDetails.
        :rtype: list[oci.capacity_management.models.AssociatedOccHandoverResourceBlock]
        """
        return self._associated_occ_handover_resource_block_list

    @associated_occ_handover_resource_block_list.setter
    def associated_occ_handover_resource_block_list(self, associated_occ_handover_resource_block_list):
        """
        Sets the associated_occ_handover_resource_block_list of this OccCapacityRequestBaseDetails.
        A list containing details about occHandoverResourceBlocks which were handed over for the corresponding resource name.


        :param associated_occ_handover_resource_block_list: The associated_occ_handover_resource_block_list of this OccCapacityRequestBaseDetails.
        :type: list[oci.capacity_management.models.AssociatedOccHandoverResourceBlock]
        """
        self._associated_occ_handover_resource_block_list = associated_occ_handover_resource_block_list

    @property
    def resource_name(self):
        """
        **[Required]** Gets the resource_name of this OccCapacityRequestBaseDetails.
        The name of the COMPUTE server shape for which the request is made. Do not use CAPACITY_CONSTRAINT as the resource name.


        :return: The resource_name of this OccCapacityRequestBaseDetails.
        :rtype: str
        """
        return self._resource_name

    @resource_name.setter
    def resource_name(self, resource_name):
        """
        Sets the resource_name of this OccCapacityRequestBaseDetails.
        The name of the COMPUTE server shape for which the request is made. Do not use CAPACITY_CONSTRAINT as the resource name.


        :param resource_name: The resource_name of this OccCapacityRequestBaseDetails.
        :type: str
        """
        self._resource_name = resource_name

    @property
    def demand_quantity(self):
        """
        **[Required]** Gets the demand_quantity of this OccCapacityRequestBaseDetails.
        The number of compute server's with name <resourceName> required by the user.


        :return: The demand_quantity of this OccCapacityRequestBaseDetails.
        :rtype: int
        """
        return self._demand_quantity

    @demand_quantity.setter
    def demand_quantity(self, demand_quantity):
        """
        Sets the demand_quantity of this OccCapacityRequestBaseDetails.
        The number of compute server's with name <resourceName> required by the user.


        :param demand_quantity: The demand_quantity of this OccCapacityRequestBaseDetails.
        :type: int
        """
        self._demand_quantity = demand_quantity

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
