# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ResourcePrincipalConfigurationSummary(object):
    """
    Resource Principal Session Token Details.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ResourcePrincipalConfigurationSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this ResourcePrincipalConfigurationSummary.
        :type id: str

        :param bds_instance_id:
            The value to assign to the bds_instance_id property of this ResourcePrincipalConfigurationSummary.
        :type bds_instance_id: str

        :param display_name:
            The value to assign to the display_name property of this ResourcePrincipalConfigurationSummary.
        :type display_name: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this ResourcePrincipalConfigurationSummary.
        :type lifecycle_state: str

        :param time_token_refreshed:
            The value to assign to the time_token_refreshed property of this ResourcePrincipalConfigurationSummary.
        :type time_token_refreshed: datetime

        :param time_token_expiry:
            The value to assign to the time_token_expiry property of this ResourcePrincipalConfigurationSummary.
        :type time_token_expiry: datetime

        :param time_created:
            The value to assign to the time_created property of this ResourcePrincipalConfigurationSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this ResourcePrincipalConfigurationSummary.
        :type time_updated: datetime

        """
        self.swagger_types = {
            'id': 'str',
            'bds_instance_id': 'str',
            'display_name': 'str',
            'lifecycle_state': 'str',
            'time_token_refreshed': 'datetime',
            'time_token_expiry': 'datetime',
            'time_created': 'datetime',
            'time_updated': 'datetime'
        }

        self.attribute_map = {
            'id': 'id',
            'bds_instance_id': 'bdsInstanceId',
            'display_name': 'displayName',
            'lifecycle_state': 'lifecycleState',
            'time_token_refreshed': 'timeTokenRefreshed',
            'time_token_expiry': 'timeTokenExpiry',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated'
        }

        self._id = None
        self._bds_instance_id = None
        self._display_name = None
        self._lifecycle_state = None
        self._time_token_refreshed = None
        self._time_token_expiry = None
        self._time_created = None
        self._time_updated = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this ResourcePrincipalConfigurationSummary.
        the ID of the ResourcePrincipalConfiguration.


        :return: The id of this ResourcePrincipalConfigurationSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ResourcePrincipalConfigurationSummary.
        the ID of the ResourcePrincipalConfiguration.


        :param id: The id of this ResourcePrincipalConfigurationSummary.
        :type: str
        """
        self._id = id

    @property
    def bds_instance_id(self):
        """
        **[Required]** Gets the bds_instance_id of this ResourcePrincipalConfigurationSummary.
        the OCID of the bdsInstance which is the parent resource id.


        :return: The bds_instance_id of this ResourcePrincipalConfigurationSummary.
        :rtype: str
        """
        return self._bds_instance_id

    @bds_instance_id.setter
    def bds_instance_id(self, bds_instance_id):
        """
        Sets the bds_instance_id of this ResourcePrincipalConfigurationSummary.
        the OCID of the bdsInstance which is the parent resource id.


        :param bds_instance_id: The bds_instance_id of this ResourcePrincipalConfigurationSummary.
        :type: str
        """
        self._bds_instance_id = bds_instance_id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this ResourcePrincipalConfigurationSummary.
        a user-friendly name. only ascii alphanumeric characters with no spaces allowed. the name does not have to be unique, and it may be changed. avoid entering confidential information.


        :return: The display_name of this ResourcePrincipalConfigurationSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this ResourcePrincipalConfigurationSummary.
        a user-friendly name. only ascii alphanumeric characters with no spaces allowed. the name does not have to be unique, and it may be changed. avoid entering confidential information.


        :param display_name: The display_name of this ResourcePrincipalConfigurationSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this ResourcePrincipalConfigurationSummary.
        the state of the ResourcePrincipalConfiguration.


        :return: The lifecycle_state of this ResourcePrincipalConfigurationSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this ResourcePrincipalConfigurationSummary.
        the state of the ResourcePrincipalConfiguration.


        :param lifecycle_state: The lifecycle_state of this ResourcePrincipalConfigurationSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def time_token_refreshed(self):
        """
        Gets the time_token_refreshed of this ResourcePrincipalConfigurationSummary.
        the time the resource principal session token was refreshed, shown as an rfc 3339 formatted datetime string.


        :return: The time_token_refreshed of this ResourcePrincipalConfigurationSummary.
        :rtype: datetime
        """
        return self._time_token_refreshed

    @time_token_refreshed.setter
    def time_token_refreshed(self, time_token_refreshed):
        """
        Sets the time_token_refreshed of this ResourcePrincipalConfigurationSummary.
        the time the resource principal session token was refreshed, shown as an rfc 3339 formatted datetime string.


        :param time_token_refreshed: The time_token_refreshed of this ResourcePrincipalConfigurationSummary.
        :type: datetime
        """
        self._time_token_refreshed = time_token_refreshed

    @property
    def time_token_expiry(self):
        """
        Gets the time_token_expiry of this ResourcePrincipalConfigurationSummary.
        the time the resource principal session token will expired, shown as an rfc 3339 formatted datetime string.


        :return: The time_token_expiry of this ResourcePrincipalConfigurationSummary.
        :rtype: datetime
        """
        return self._time_token_expiry

    @time_token_expiry.setter
    def time_token_expiry(self, time_token_expiry):
        """
        Sets the time_token_expiry of this ResourcePrincipalConfigurationSummary.
        the time the resource principal session token will expired, shown as an rfc 3339 formatted datetime string.


        :param time_token_expiry: The time_token_expiry of this ResourcePrincipalConfigurationSummary.
        :type: datetime
        """
        self._time_token_expiry = time_token_expiry

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this ResourcePrincipalConfigurationSummary.
        the time the ResourcePrincipalConfiguration was created, shown as an rfc 3339 formatted datetime string.


        :return: The time_created of this ResourcePrincipalConfigurationSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this ResourcePrincipalConfigurationSummary.
        the time the ResourcePrincipalConfiguration was created, shown as an rfc 3339 formatted datetime string.


        :param time_created: The time_created of this ResourcePrincipalConfigurationSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this ResourcePrincipalConfigurationSummary.
        the time the ResourcePrincipalConfiguration was updated, shown as an rfc 3339 formatted datetime string.


        :return: The time_updated of this ResourcePrincipalConfigurationSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this ResourcePrincipalConfigurationSummary.
        the time the ResourcePrincipalConfiguration was updated, shown as an rfc 3339 formatted datetime string.


        :param time_updated: The time_updated of this ResourcePrincipalConfigurationSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
