# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OsPatchDetails(object):
    """
    Details of an os patch.
    """

    #: A constant which can be used with the patch_type property of a OsPatchDetails.
    #: This constant has a value of "REGULAR"
    PATCH_TYPE_REGULAR = "REGULAR"

    #: A constant which can be used with the patch_type property of a OsPatchDetails.
    #: This constant has a value of "CUSTOM"
    PATCH_TYPE_CUSTOM = "CUSTOM"

    #: A constant which can be used with the patch_type property of a OsPatchDetails.
    #: This constant has a value of "EMERGENT"
    PATCH_TYPE_EMERGENT = "EMERGENT"

    def __init__(self, **kwargs):
        """
        Initializes a new OsPatchDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param os_patch_version:
            The value to assign to the os_patch_version property of this OsPatchDetails.
        :type os_patch_version: str

        :param min_bds_version:
            The value to assign to the min_bds_version property of this OsPatchDetails.
        :type min_bds_version: str

        :param min_compatible_odh_version_map:
            The value to assign to the min_compatible_odh_version_map property of this OsPatchDetails.
        :type min_compatible_odh_version_map: dict(str, str)

        :param target_packages:
            The value to assign to the target_packages property of this OsPatchDetails.
        :type target_packages: list[oci.bds.models.OsPatchPackageSummary]

        :param release_date:
            The value to assign to the release_date property of this OsPatchDetails.
        :type release_date: datetime

        :param patch_type:
            The value to assign to the patch_type property of this OsPatchDetails.
            Allowed values for this property are: "REGULAR", "CUSTOM", "EMERGENT", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type patch_type: str

        """
        self.swagger_types = {
            'os_patch_version': 'str',
            'min_bds_version': 'str',
            'min_compatible_odh_version_map': 'dict(str, str)',
            'target_packages': 'list[OsPatchPackageSummary]',
            'release_date': 'datetime',
            'patch_type': 'str'
        }

        self.attribute_map = {
            'os_patch_version': 'osPatchVersion',
            'min_bds_version': 'minBdsVersion',
            'min_compatible_odh_version_map': 'minCompatibleOdhVersionMap',
            'target_packages': 'targetPackages',
            'release_date': 'releaseDate',
            'patch_type': 'patchType'
        }

        self._os_patch_version = None
        self._min_bds_version = None
        self._min_compatible_odh_version_map = None
        self._target_packages = None
        self._release_date = None
        self._patch_type = None

    @property
    def os_patch_version(self):
        """
        **[Required]** Gets the os_patch_version of this OsPatchDetails.
        Version of the os patch.


        :return: The os_patch_version of this OsPatchDetails.
        :rtype: str
        """
        return self._os_patch_version

    @os_patch_version.setter
    def os_patch_version(self, os_patch_version):
        """
        Sets the os_patch_version of this OsPatchDetails.
        Version of the os patch.


        :param os_patch_version: The os_patch_version of this OsPatchDetails.
        :type: str
        """
        self._os_patch_version = os_patch_version

    @property
    def min_bds_version(self):
        """
        **[Required]** Gets the min_bds_version of this OsPatchDetails.
        Minimum BDS version required to install current OS patch.


        :return: The min_bds_version of this OsPatchDetails.
        :rtype: str
        """
        return self._min_bds_version

    @min_bds_version.setter
    def min_bds_version(self, min_bds_version):
        """
        Sets the min_bds_version of this OsPatchDetails.
        Minimum BDS version required to install current OS patch.


        :param min_bds_version: The min_bds_version of this OsPatchDetails.
        :type: str
        """
        self._min_bds_version = min_bds_version

    @property
    def min_compatible_odh_version_map(self):
        """
        **[Required]** Gets the min_compatible_odh_version_map of this OsPatchDetails.
        Map of major ODH version to minimum ODH version required to install current OS patch. e.g. {ODH0.9: 0.9.1}


        :return: The min_compatible_odh_version_map of this OsPatchDetails.
        :rtype: dict(str, str)
        """
        return self._min_compatible_odh_version_map

    @min_compatible_odh_version_map.setter
    def min_compatible_odh_version_map(self, min_compatible_odh_version_map):
        """
        Sets the min_compatible_odh_version_map of this OsPatchDetails.
        Map of major ODH version to minimum ODH version required to install current OS patch. e.g. {ODH0.9: 0.9.1}


        :param min_compatible_odh_version_map: The min_compatible_odh_version_map of this OsPatchDetails.
        :type: dict(str, str)
        """
        self._min_compatible_odh_version_map = min_compatible_odh_version_map

    @property
    def target_packages(self):
        """
        **[Required]** Gets the target_packages of this OsPatchDetails.
        List of summaries of individual target packages.


        :return: The target_packages of this OsPatchDetails.
        :rtype: list[oci.bds.models.OsPatchPackageSummary]
        """
        return self._target_packages

    @target_packages.setter
    def target_packages(self, target_packages):
        """
        Sets the target_packages of this OsPatchDetails.
        List of summaries of individual target packages.


        :param target_packages: The target_packages of this OsPatchDetails.
        :type: list[oci.bds.models.OsPatchPackageSummary]
        """
        self._target_packages = target_packages

    @property
    def release_date(self):
        """
        **[Required]** Gets the release_date of this OsPatchDetails.
        Released date of the OS patch.


        :return: The release_date of this OsPatchDetails.
        :rtype: datetime
        """
        return self._release_date

    @release_date.setter
    def release_date(self, release_date):
        """
        Sets the release_date of this OsPatchDetails.
        Released date of the OS patch.


        :param release_date: The release_date of this OsPatchDetails.
        :type: datetime
        """
        self._release_date = release_date

    @property
    def patch_type(self):
        """
        **[Required]** Gets the patch_type of this OsPatchDetails.
        Type of a specific os patch.
        REGULAR means standard released os patches.
        CUSTOM means os patches with some customizations.
        EMERGENT means os patches with some emergency fixes that should be prioritized.

        Allowed values for this property are: "REGULAR", "CUSTOM", "EMERGENT", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The patch_type of this OsPatchDetails.
        :rtype: str
        """
        return self._patch_type

    @patch_type.setter
    def patch_type(self, patch_type):
        """
        Sets the patch_type of this OsPatchDetails.
        Type of a specific os patch.
        REGULAR means standard released os patches.
        CUSTOM means os patches with some customizations.
        EMERGENT means os patches with some emergency fixes that should be prioritized.


        :param patch_type: The patch_type of this OsPatchDetails.
        :type: str
        """
        allowed_values = ["REGULAR", "CUSTOM", "EMERGENT"]
        if not value_allowed_none_or_none_sentinel(patch_type, allowed_values):
            patch_type = 'UNKNOWN_ENUM_VALUE'
        self._patch_type = patch_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
