# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MonitorConfiguration(object):
    """
    Details of monitor configuration.
    """

    #: A constant which can be used with the config_type property of a MonitorConfiguration.
    #: This constant has a value of "BROWSER_CONFIG"
    CONFIG_TYPE_BROWSER_CONFIG = "BROWSER_CONFIG"

    #: A constant which can be used with the config_type property of a MonitorConfiguration.
    #: This constant has a value of "SCRIPTED_BROWSER_CONFIG"
    CONFIG_TYPE_SCRIPTED_BROWSER_CONFIG = "SCRIPTED_BROWSER_CONFIG"

    #: A constant which can be used with the config_type property of a MonitorConfiguration.
    #: This constant has a value of "REST_CONFIG"
    CONFIG_TYPE_REST_CONFIG = "REST_CONFIG"

    #: A constant which can be used with the config_type property of a MonitorConfiguration.
    #: This constant has a value of "SCRIPTED_REST_CONFIG"
    CONFIG_TYPE_SCRIPTED_REST_CONFIG = "SCRIPTED_REST_CONFIG"

    #: A constant which can be used with the config_type property of a MonitorConfiguration.
    #: This constant has a value of "NETWORK_CONFIG"
    CONFIG_TYPE_NETWORK_CONFIG = "NETWORK_CONFIG"

    #: A constant which can be used with the config_type property of a MonitorConfiguration.
    #: This constant has a value of "DNS_SERVER_CONFIG"
    CONFIG_TYPE_DNS_SERVER_CONFIG = "DNS_SERVER_CONFIG"

    #: A constant which can be used with the config_type property of a MonitorConfiguration.
    #: This constant has a value of "DNS_TRACE_CONFIG"
    CONFIG_TYPE_DNS_TRACE_CONFIG = "DNS_TRACE_CONFIG"

    #: A constant which can be used with the config_type property of a MonitorConfiguration.
    #: This constant has a value of "DNSSEC_CONFIG"
    CONFIG_TYPE_DNSSEC_CONFIG = "DNSSEC_CONFIG"

    #: A constant which can be used with the config_type property of a MonitorConfiguration.
    #: This constant has a value of "FTP_CONFIG"
    CONFIG_TYPE_FTP_CONFIG = "FTP_CONFIG"

    #: A constant which can be used with the config_type property of a MonitorConfiguration.
    #: This constant has a value of "SQL_CONFIG"
    CONFIG_TYPE_SQL_CONFIG = "SQL_CONFIG"

    def __init__(self, **kwargs):
        """
        Initializes a new MonitorConfiguration object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.apm_synthetics.models.FtpMonitorConfiguration`
        * :class:`~oci.apm_synthetics.models.DnsSecMonitorConfiguration`
        * :class:`~oci.apm_synthetics.models.DnsTraceMonitorConfiguration`
        * :class:`~oci.apm_synthetics.models.SqlMonitorConfiguration`
        * :class:`~oci.apm_synthetics.models.ScriptedRestMonitorConfiguration`
        * :class:`~oci.apm_synthetics.models.DnsServerMonitorConfiguration`
        * :class:`~oci.apm_synthetics.models.ScriptedBrowserMonitorConfiguration`
        * :class:`~oci.apm_synthetics.models.RestMonitorConfiguration`
        * :class:`~oci.apm_synthetics.models.BrowserMonitorConfiguration`
        * :class:`~oci.apm_synthetics.models.NetworkMonitorConfiguration`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param config_type:
            The value to assign to the config_type property of this MonitorConfiguration.
            Allowed values for this property are: "BROWSER_CONFIG", "SCRIPTED_BROWSER_CONFIG", "REST_CONFIG", "SCRIPTED_REST_CONFIG", "NETWORK_CONFIG", "DNS_SERVER_CONFIG", "DNS_TRACE_CONFIG", "DNSSEC_CONFIG", "FTP_CONFIG", "SQL_CONFIG", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type config_type: str

        :param is_failure_retried:
            The value to assign to the is_failure_retried property of this MonitorConfiguration.
        :type is_failure_retried: bool

        :param dns_configuration:
            The value to assign to the dns_configuration property of this MonitorConfiguration.
        :type dns_configuration: oci.apm_synthetics.models.DnsConfiguration

        """
        self.swagger_types = {
            'config_type': 'str',
            'is_failure_retried': 'bool',
            'dns_configuration': 'DnsConfiguration'
        }

        self.attribute_map = {
            'config_type': 'configType',
            'is_failure_retried': 'isFailureRetried',
            'dns_configuration': 'dnsConfiguration'
        }

        self._config_type = None
        self._is_failure_retried = None
        self._dns_configuration = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['configType']

        if type == 'FTP_CONFIG':
            return 'FtpMonitorConfiguration'

        if type == 'DNSSEC_CONFIG':
            return 'DnsSecMonitorConfiguration'

        if type == 'DNS_TRACE_CONFIG':
            return 'DnsTraceMonitorConfiguration'

        if type == 'SQL_CONFIG':
            return 'SqlMonitorConfiguration'

        if type == 'SCRIPTED_REST_CONFIG':
            return 'ScriptedRestMonitorConfiguration'

        if type == 'DNS_SERVER_CONFIG':
            return 'DnsServerMonitorConfiguration'

        if type == 'SCRIPTED_BROWSER_CONFIG':
            return 'ScriptedBrowserMonitorConfiguration'

        if type == 'REST_CONFIG':
            return 'RestMonitorConfiguration'

        if type == 'BROWSER_CONFIG':
            return 'BrowserMonitorConfiguration'

        if type == 'NETWORK_CONFIG':
            return 'NetworkMonitorConfiguration'
        else:
            return 'MonitorConfiguration'

    @property
    def config_type(self):
        """
        Gets the config_type of this MonitorConfiguration.
        Type of configuration.

        Allowed values for this property are: "BROWSER_CONFIG", "SCRIPTED_BROWSER_CONFIG", "REST_CONFIG", "SCRIPTED_REST_CONFIG", "NETWORK_CONFIG", "DNS_SERVER_CONFIG", "DNS_TRACE_CONFIG", "DNSSEC_CONFIG", "FTP_CONFIG", "SQL_CONFIG", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The config_type of this MonitorConfiguration.
        :rtype: str
        """
        return self._config_type

    @config_type.setter
    def config_type(self, config_type):
        """
        Sets the config_type of this MonitorConfiguration.
        Type of configuration.


        :param config_type: The config_type of this MonitorConfiguration.
        :type: str
        """
        allowed_values = ["BROWSER_CONFIG", "SCRIPTED_BROWSER_CONFIG", "REST_CONFIG", "SCRIPTED_REST_CONFIG", "NETWORK_CONFIG", "DNS_SERVER_CONFIG", "DNS_TRACE_CONFIG", "DNSSEC_CONFIG", "FTP_CONFIG", "SQL_CONFIG"]
        if not value_allowed_none_or_none_sentinel(config_type, allowed_values):
            config_type = 'UNKNOWN_ENUM_VALUE'
        self._config_type = config_type

    @property
    def is_failure_retried(self):
        """
        Gets the is_failure_retried of this MonitorConfiguration.
        If isFailureRetried is enabled, then a failed call will be retried.


        :return: The is_failure_retried of this MonitorConfiguration.
        :rtype: bool
        """
        return self._is_failure_retried

    @is_failure_retried.setter
    def is_failure_retried(self, is_failure_retried):
        """
        Sets the is_failure_retried of this MonitorConfiguration.
        If isFailureRetried is enabled, then a failed call will be retried.


        :param is_failure_retried: The is_failure_retried of this MonitorConfiguration.
        :type: bool
        """
        self._is_failure_retried = is_failure_retried

    @property
    def dns_configuration(self):
        """
        Gets the dns_configuration of this MonitorConfiguration.

        :return: The dns_configuration of this MonitorConfiguration.
        :rtype: oci.apm_synthetics.models.DnsConfiguration
        """
        return self._dns_configuration

    @dns_configuration.setter
    def dns_configuration(self, dns_configuration):
        """
        Sets the dns_configuration of this MonitorConfiguration.

        :param dns_configuration: The dns_configuration of this MonitorConfiguration.
        :type: oci.apm_synthetics.models.DnsConfiguration
        """
        self._dns_configuration = dns_configuration

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
