# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210201

from .test_details import TestDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class TestSpanEnrichmentDetails(TestDetails):
    """
    Run a set of span enrichment rules on a given span to see the result.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new TestSpanEnrichmentDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.apm_config.models.TestSpanEnrichmentDetails.test_type` attribute
        of this class is ``SPAN_ENRICHMENT`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param test_type:
            The value to assign to the test_type property of this TestSpanEnrichmentDetails.
            Allowed values for this property are: "SPAN_ENRICHMENT"
        :type test_type: str

        :param options:
            The value to assign to the options property of this TestSpanEnrichmentDetails.
        :type options: object

        :param filters:
            The value to assign to the filters property of this TestSpanEnrichmentDetails.
        :type filters: list[oci.apm_config.models.FilterTextOrId]

        :param span:
            The value to assign to the span property of this TestSpanEnrichmentDetails.
        :type span: object

        """
        self.swagger_types = {
            'test_type': 'str',
            'options': 'object',
            'filters': 'list[FilterTextOrId]',
            'span': 'object'
        }

        self.attribute_map = {
            'test_type': 'testType',
            'options': 'options',
            'filters': 'filters',
            'span': 'span'
        }

        self._test_type = None
        self._options = None
        self._filters = None
        self._span = None
        self._test_type = 'SPAN_ENRICHMENT'

    @property
    def options(self):
        """
        **[Required]** Gets the options of this TestSpanEnrichmentDetails.
        The span enrichment rules to test in the format of an Options resource.


        :return: The options of this TestSpanEnrichmentDetails.
        :rtype: object
        """
        return self._options

    @options.setter
    def options(self, options):
        """
        Sets the options of this TestSpanEnrichmentDetails.
        The span enrichment rules to test in the format of an Options resource.


        :param options: The options of this TestSpanEnrichmentDetails.
        :type: object
        """
        self._options = options

    @property
    def filters(self):
        """
        Gets the filters of this TestSpanEnrichmentDetails.
        A list of filters to try against the given span.


        :return: The filters of this TestSpanEnrichmentDetails.
        :rtype: list[oci.apm_config.models.FilterTextOrId]
        """
        return self._filters

    @filters.setter
    def filters(self, filters):
        """
        Sets the filters of this TestSpanEnrichmentDetails.
        A list of filters to try against the given span.


        :param filters: The filters of this TestSpanEnrichmentDetails.
        :type: list[oci.apm_config.models.FilterTextOrId]
        """
        self._filters = filters

    @property
    def span(self):
        """
        **[Required]** Gets the span of this TestSpanEnrichmentDetails.
        The span to test the rules on. This should be a valid JSON object that follows one
        of the formats used by distributed tracing frameworks, such as OpenTelemetry, Zipkin, or
        Oracle Application Performance Monitoring.


        :return: The span of this TestSpanEnrichmentDetails.
        :rtype: object
        """
        return self._span

    @span.setter
    def span(self, span):
        """
        Sets the span of this TestSpanEnrichmentDetails.
        The span to test the rules on. This should be a valid JSON object that follows one
        of the formats used by distributed tracing frameworks, such as OpenTelemetry, Zipkin, or
        Oracle Application Performance Monitoring.


        :param span: The span of this TestSpanEnrichmentDetails.
        :type: object
        """
        self._span = span

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
