# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class TtsOracleModelDetails(object):
    """
    Model specific properties to use with Oracle model for TTS.
    """

    #: A constant which can be used with the model_name property of a TtsOracleModelDetails.
    #: This constant has a value of "TTS_1_STANDARD"
    MODEL_NAME_TTS_1_STANDARD = "TTS_1_STANDARD"

    #: A constant which can be used with the model_name property of a TtsOracleModelDetails.
    #: This constant has a value of "TTS_2_NATURAL"
    MODEL_NAME_TTS_2_NATURAL = "TTS_2_NATURAL"

    def __init__(self, **kwargs):
        """
        Initializes a new TtsOracleModelDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.ai_speech.models.TtsOracleTts2NaturalModelDetails`
        * :class:`~oci.ai_speech.models.TtsOracleTts1StandardModelDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param model_name:
            The value to assign to the model_name property of this TtsOracleModelDetails.
            Allowed values for this property are: "TTS_1_STANDARD", "TTS_2_NATURAL"
        :type model_name: str

        """
        self.swagger_types = {
            'model_name': 'str'
        }

        self.attribute_map = {
            'model_name': 'modelName'
        }

        self._model_name = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['modelName']

        if type == 'TTS_2_NATURAL':
            return 'TtsOracleTts2NaturalModelDetails'

        if type == 'TTS_1_STANDARD':
            return 'TtsOracleTts1StandardModelDetails'
        else:
            return 'TtsOracleModelDetails'

    @property
    def model_name(self):
        """
        **[Required]** Gets the model_name of this TtsOracleModelDetails.
        The fully qualified name of model to use for speech generation. The available models are:
        - TTS_1_STANDARD
        - TTS_2_NATURAL

        Allowed values for this property are: "TTS_1_STANDARD", "TTS_2_NATURAL"


        :return: The model_name of this TtsOracleModelDetails.
        :rtype: str
        """
        return self._model_name

    @model_name.setter
    def model_name(self, model_name):
        """
        Sets the model_name of this TtsOracleModelDetails.
        The fully qualified name of model to use for speech generation. The available models are:
        - TTS_1_STANDARD
        - TTS_2_NATURAL


        :param model_name: The model_name of this TtsOracleModelDetails.
        :type: str
        """
        allowed_values = ["TTS_1_STANDARD", "TTS_2_NATURAL"]
        if not value_allowed_none_or_none_sentinel(model_name, allowed_values):
            raise ValueError(
                f"Invalid value for `model_name`, must be None or one of {allowed_values}"
            )
        self._model_name = model_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
