# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CustomizationInferenceEntity(object):
    """
    Entity Object for customization inference payload
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CustomizationInferenceEntity object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param entity_type:
            The value to assign to the entity_type property of this CustomizationInferenceEntity.
        :type entity_type: str

        :param customization_id:
            The value to assign to the customization_id property of this CustomizationInferenceEntity.
        :type customization_id: str

        :param customization_alias:
            The value to assign to the customization_alias property of this CustomizationInferenceEntity.
        :type customization_alias: str

        """
        self.swagger_types = {
            'entity_type': 'str',
            'customization_id': 'str',
            'customization_alias': 'str'
        }

        self.attribute_map = {
            'entity_type': 'entityType',
            'customization_id': 'customizationId',
            'customization_alias': 'customizationAlias'
        }

        self._entity_type = None
        self._customization_id = None
        self._customization_alias = None

    @property
    def entity_type(self):
        """
        Gets the entity_type of this CustomizationInferenceEntity.
        Entity type


        :return: The entity_type of this CustomizationInferenceEntity.
        :rtype: str
        """
        return self._entity_type

    @entity_type.setter
    def entity_type(self, entity_type):
        """
        Sets the entity_type of this CustomizationInferenceEntity.
        Entity type


        :param entity_type: The entity_type of this CustomizationInferenceEntity.
        :type: str
        """
        self._entity_type = entity_type

    @property
    def customization_id(self):
        """
        Gets the customization_id of this CustomizationInferenceEntity.
        The `OCID`__ of the customization to use.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The customization_id of this CustomizationInferenceEntity.
        :rtype: str
        """
        return self._customization_id

    @customization_id.setter
    def customization_id(self, customization_id):
        """
        Sets the customization_id of this CustomizationInferenceEntity.
        The `OCID`__ of the customization to use.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param customization_id: The customization_id of this CustomizationInferenceEntity.
        :type: str
        """
        self._customization_id = customization_id

    @property
    def customization_alias(self):
        """
        Gets the customization_alias of this CustomizationInferenceEntity.
        Alias of the customization


        :return: The customization_alias of this CustomizationInferenceEntity.
        :rtype: str
        """
        return self._customization_alias

    @customization_alias.setter
    def customization_alias(self, customization_alias):
        """
        Sets the customization_alias of this CustomizationInferenceEntity.
        Alias of the customization


        :param customization_alias: The customization_alias of this CustomizationInferenceEntity.
        :type: str
        """
        self._customization_alias = customization_alias

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
