/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.jniutils;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.graalvm.compiler.serviceprovider.IsolateUtil;
import org.graalvm.jniutils.HSObject;
import org.graalvm.jniutils.JNI;
import org.graalvm.jniutils.JNIExceptionWrapper;
import org.graalvm.jniutils.JNIMethodScope;
import org.graalvm.jniutils.NativeBridgeSupport;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CDoublePointer;
import org.graalvm.nativeimage.c.type.CFloatPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.CLongPointer;
import org.graalvm.nativeimage.c.type.CShortPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.c.type.VoidPointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

public final class JNIUtil {
    private static final String[] METHOD_GET_PLATFORM_CLASS_LOADER = new String[]{"getPlatformClassLoader", "()Ljava/lang/ClassLoader;"};
    private static final String[] METHOD_GET_SYSTEM_CLASS_LOADER = new String[]{"getSystemClassLoader", "()Ljava/lang/ClassLoader;"};
    private static final String[] METHOD_LOAD_CLASS = new String[]{"loadClass", "(Ljava/lang/String;)Ljava/lang/Class;"};
    private static final int ARRAY_COPY_STATIC_BUFFER_SIZE = 8192;

    public static boolean IsSameObject(JNI.JNIEnv env, JNI.JObject ref1, JNI.JObject ref2) {
        JNIUtil.traceJNI("IsSameObject");
        return env.getFunctions().getIsSameObject().call(env, ref1, ref2);
    }

    public static void DeleteLocalRef(JNI.JNIEnv env, JNI.JObject ref) {
        JNIUtil.traceJNI("DeleteLocalRef");
        env.getFunctions().getDeleteLocalRef().call(env, ref);
    }

    public static int PushLocalFrame(JNI.JNIEnv env, int capacity) {
        JNIUtil.traceJNI("PushLocalFrame");
        return env.getFunctions().getPushLocalFrame().call(env, capacity);
    }

    public static JNI.JObject PopLocalFrame(JNI.JNIEnv env, JNI.JObject result) {
        JNIUtil.traceJNI("PopLocalFrame");
        return env.getFunctions().getPopLocalFrame().call(env, result);
    }

    public static JNI.JClass DefineClass(JNI.JNIEnv env, CCharPointer name, JNI.JObject loader, CCharPointer buf, int bufLen) {
        return env.getFunctions().getDefineClass().call(env, name, loader, buf, bufLen);
    }

    public static JNI.JClass FindClass(JNI.JNIEnv env, CCharPointer name) {
        JNIUtil.traceJNI("FindClass");
        return env.getFunctions().getFindClass().call(env, name);
    }

    public static JNI.JClass GetObjectClass(JNI.JNIEnv env, JNI.JObject object) {
        JNIUtil.traceJNI("GetObjectClass");
        return env.getFunctions().getGetObjectClass().call(env, object);
    }

    public static JNI.JMethodID GetStaticMethodID(JNI.JNIEnv env, JNI.JClass clazz, CCharPointer name, CCharPointer sig) {
        JNIUtil.traceJNI("GetStaticMethodID");
        return env.getFunctions().getGetStaticMethodID().call(env, clazz, name, sig);
    }

    public static JNI.JMethodID GetMethodID(JNI.JNIEnv env, JNI.JClass clazz, CCharPointer name, CCharPointer sig) {
        JNIUtil.traceJNI("GetMethodID");
        return env.getFunctions().getGetMethodID().call(env, clazz, name, sig);
    }

    public static JNI.JFieldID GetStaticFieldID(JNI.JNIEnv env, JNI.JClass clazz, CCharPointer name, CCharPointer sig) {
        JNIUtil.traceJNI("GetStaticFieldID");
        return env.getFunctions().getGetStaticFieldID().call(env, clazz, name, sig);
    }

    public static JNI.JFieldID GetFieldID(JNI.JNIEnv env, JNI.JClass clazz, CCharPointer name, CCharPointer signature) {
        JNIUtil.traceJNI("GetFieldID");
        return env.getFunctions().getGetFieldID().call(env, clazz, name, signature);
    }

    public static JNI.JObject GetStaticObjectField(JNI.JNIEnv env, JNI.JClass clazz, JNI.JFieldID fieldID) {
        JNIUtil.traceJNI("GetFieldID");
        return env.getFunctions().getGetStaticObjectField().call(env, clazz, fieldID);
    }

    public static int GetIntField(JNI.JNIEnv env, JNI.JObject object, JNI.JFieldID fieldID) {
        JNIUtil.traceJNI("GetIntField");
        return env.getFunctions().getGetIntField().call(env, object, fieldID);
    }

    public static JNI.JObjectArray NewObjectArray(JNI.JNIEnv env, int len, JNI.JClass componentClass, JNI.JObject initialElement) {
        JNIUtil.traceJNI("NewObjectArray");
        return env.getFunctions().getNewObjectArray().call(env, len, componentClass, initialElement);
    }

    public static JNI.JBooleanArray NewBooleanArray(JNI.JNIEnv env, int len) {
        JNIUtil.traceJNI("NewBooleanArray");
        return env.getFunctions().getNewBooleanArray().call(env, len);
    }

    public static JNI.JByteArray NewByteArray(JNI.JNIEnv env, int len) {
        JNIUtil.traceJNI("NewByteArray");
        return env.getFunctions().getNewByteArray().call(env, len);
    }

    public static JNI.JCharArray NewCharArray(JNI.JNIEnv env, int len) {
        JNIUtil.traceJNI("NewCharArray");
        return env.getFunctions().getNewCharArray().call(env, len);
    }

    public static JNI.JShortArray NewShortArray(JNI.JNIEnv env, int len) {
        JNIUtil.traceJNI("NewShortArray");
        return env.getFunctions().getNewShortArray().call(env, len);
    }

    public static JNI.JIntArray NewIntArray(JNI.JNIEnv env, int len) {
        JNIUtil.traceJNI("NewIntArray");
        return env.getFunctions().getNewIntArray().call(env, len);
    }

    public static JNI.JLongArray NewLongArray(JNI.JNIEnv env, int len) {
        JNIUtil.traceJNI("NewLongArray");
        return env.getFunctions().getNewLongArray().call(env, len);
    }

    public static JNI.JFloatArray NewFloatArray(JNI.JNIEnv env, int len) {
        JNIUtil.traceJNI("NewFloatArray");
        return env.getFunctions().getNewFloatArray().call(env, len);
    }

    public static JNI.JDoubleArray NewDoubleArray(JNI.JNIEnv env, int len) {
        JNIUtil.traceJNI("NewDoubleArray");
        return env.getFunctions().getNewDoubleArray().call(env, len);
    }

    public static int GetArrayLength(JNI.JNIEnv env, JNI.JArray array) {
        JNIUtil.traceJNI("GetArrayLength");
        return env.getFunctions().getGetArrayLength().call(env, array);
    }

    public static void SetObjectArrayElement(JNI.JNIEnv env, JNI.JObjectArray array, int index, JNI.JObject value) {
        JNIUtil.traceJNI("SetObjectArrayElement");
        env.getFunctions().getSetObjectArrayElement().call(env, array, index, value);
    }

    public static JNI.JObject GetObjectArrayElement(JNI.JNIEnv env, JNI.JObjectArray array, int index) {
        JNIUtil.traceJNI("GetObjectArrayElement");
        return env.getFunctions().getGetObjectArrayElement().call(env, array, index);
    }

    public static CCharPointer GetBooleanArrayElements(JNI.JNIEnv env, JNI.JBooleanArray array, JNI.JValue isCopy) {
        JNIUtil.traceJNI("GetBooleanArrayElements");
        return env.getFunctions().getGetBooleanArrayElements().call(env, array, isCopy);
    }

    public static CCharPointer GetByteArrayElements(JNI.JNIEnv env, JNI.JByteArray array, JNI.JValue isCopy) {
        JNIUtil.traceJNI("GetByteArrayElements");
        return env.getFunctions().getGetByteArrayElements().call(env, array, isCopy);
    }

    public static CShortPointer GetCharArrayElements(JNI.JNIEnv env, JNI.JCharArray array, JNI.JValue isCopy) {
        JNIUtil.traceJNI("GetCharArrayElements");
        return env.getFunctions().getGetCharArrayElements().call(env, array, isCopy);
    }

    public static CShortPointer GetShortArrayElements(JNI.JNIEnv env, JNI.JShortArray array, JNI.JValue isCopy) {
        JNIUtil.traceJNI("GetShortArrayElements");
        return env.getFunctions().getGetShortArrayElements().call(env, array, isCopy);
    }

    public static CIntPointer GetIntArrayElements(JNI.JNIEnv env, JNI.JIntArray array, JNI.JValue isCopy) {
        JNIUtil.traceJNI("GetIntArrayElements");
        return env.getFunctions().getGetIntArrayElements().call(env, array, isCopy);
    }

    public static CLongPointer GetLongArrayElements(JNI.JNIEnv env, JNI.JLongArray array, JNI.JValue isCopy) {
        JNIUtil.traceJNI("GetLongArrayElements");
        return env.getFunctions().getGetLongArrayElements().call(env, array, isCopy);
    }

    public static CFloatPointer GetFloatArrayElements(JNI.JNIEnv env, JNI.JFloatArray array, JNI.JValue isCopy) {
        JNIUtil.traceJNI("GetFloatArrayElements");
        return env.getFunctions().getGetFloatArrayElements().call(env, array, isCopy);
    }

    public static CDoublePointer GetDoubleArrayElements(JNI.JNIEnv env, JNI.JDoubleArray array, JNI.JValue isCopy) {
        JNIUtil.traceJNI("GetFloatArrayElements");
        return env.getFunctions().getGetDoubleArrayElements().call(env, array, isCopy);
    }

    public static void ReleaseBooleanArrayElements(JNI.JNIEnv env, JNI.JBooleanArray array, CCharPointer elems, int mode) {
        JNIUtil.traceJNI("ReleaseBooleanArrayElements");
        env.getFunctions().getReleaseBooleanArrayElements().call(env, array, elems, mode);
    }

    public static void ReleaseByteArrayElements(JNI.JNIEnv env, JNI.JByteArray array, CCharPointer elems, int mode) {
        JNIUtil.traceJNI("ReleaseByteArrayElements");
        env.getFunctions().getReleaseByteArrayElements().call(env, array, elems, mode);
    }

    public static void ReleaseCharArrayElements(JNI.JNIEnv env, JNI.JCharArray array, CShortPointer elems, int mode) {
        JNIUtil.traceJNI("ReleaseCharArrayElements");
        env.getFunctions().getReleaseCharArrayElements().call(env, array, elems, mode);
    }

    public static void ReleaseShortArrayElements(JNI.JNIEnv env, JNI.JShortArray array, CShortPointer elems, int mode) {
        JNIUtil.traceJNI("ReleaseShortArrayElements");
        env.getFunctions().getReleaseShortArrayElements().call(env, array, elems, mode);
    }

    public static void ReleaseIntArrayElements(JNI.JNIEnv env, JNI.JIntArray array, CIntPointer elems, int mode) {
        JNIUtil.traceJNI("ReleaseIntArrayElements");
        env.getFunctions().getReleaseIntArrayElements().call(env, array, elems, mode);
    }

    public static void ReleaseLongArrayElements(JNI.JNIEnv env, JNI.JLongArray array, CLongPointer elems, int mode) {
        JNIUtil.traceJNI("ReleaseLongArrayElements");
        env.getFunctions().getReleaseLongArrayElements().call(env, array, elems, mode);
    }

    public static void ReleaseFloatArrayElements(JNI.JNIEnv env, JNI.JFloatArray array, CFloatPointer elems, int mode) {
        JNIUtil.traceJNI("ReleaseFloatArrayElements");
        env.getFunctions().getReleaseFloatArrayElements().call(env, array, elems, mode);
    }

    public static void ReleaseDoubleArrayElements(JNI.JNIEnv env, JNI.JDoubleArray array, CDoublePointer elems, int mode) {
        JNIUtil.traceJNI("ReleaseDoubleArrayElements");
        env.getFunctions().getReleaseDoubleArrayElements().call(env, array, elems, mode);
    }

    public static void GetBooleanArrayRegion(JNI.JNIEnv env, JNI.JBooleanArray array, int offset, int len, CCharPointer buff) {
        JNIUtil.traceJNI("GetBooleanArrayRegion");
        env.getFunctions().getGetBooleanArrayRegion().call(env, array, offset, len, buff);
    }

    public static void GetByteArrayRegion(JNI.JNIEnv env, JNI.JByteArray array, int offset, int len, CCharPointer buff) {
        JNIUtil.traceJNI("GetByteArrayRegion");
        env.getFunctions().getGetByteArrayRegion().call(env, array, offset, len, buff);
    }

    public static void GetCharArrayRegion(JNI.JNIEnv env, JNI.JCharArray array, int offset, int len, CShortPointer buff) {
        JNIUtil.traceJNI("GetCharArrayRegion");
        env.getFunctions().getGetCharArrayRegion().call(env, array, offset, len, buff);
    }

    public static void GetShortArrayRegion(JNI.JNIEnv env, JNI.JShortArray array, int offset, int len, CShortPointer buff) {
        JNIUtil.traceJNI("GetShortArrayRegion");
        env.getFunctions().getGetShortArrayRegion().call(env, array, offset, len, buff);
    }

    public static void GetIntArrayRegion(JNI.JNIEnv env, JNI.JIntArray array, int offset, int len, CIntPointer buff) {
        JNIUtil.traceJNI("GetIntArrayRegion");
        env.getFunctions().getGetIntArrayRegion().call(env, array, offset, len, buff);
    }

    public static void GetLongArrayRegion(JNI.JNIEnv env, JNI.JLongArray array, int offset, int len, CLongPointer buff) {
        JNIUtil.traceJNI("GetLongArrayRegion");
        env.getFunctions().getGetLongArrayRegion().call(env, array, offset, len, buff);
    }

    public static void GetFloatArrayRegion(JNI.JNIEnv env, JNI.JFloatArray array, int offset, int len, CFloatPointer buff) {
        JNIUtil.traceJNI("GetFloatArrayRegion");
        env.getFunctions().getGetFloatArrayRegion().call(env, array, offset, len, buff);
    }

    public static void GetDoubleArrayRegion(JNI.JNIEnv env, JNI.JDoubleArray array, int offset, int len, CDoublePointer buff) {
        JNIUtil.traceJNI("GetDoubleArrayRegion");
        env.getFunctions().getGetDoubleArrayRegion().call(env, array, offset, len, buff);
    }

    public static void SetBooleanArrayRegion(JNI.JNIEnv env, JNI.JBooleanArray array, int offset, int len, CCharPointer buff) {
        JNIUtil.traceJNI("SetBooleanArrayRegion");
        env.getFunctions().getSetBooleanArrayRegion().call(env, array, offset, len, buff);
    }

    public static void SetByteArrayRegion(JNI.JNIEnv env, JNI.JByteArray array, int offset, int len, CCharPointer buff) {
        JNIUtil.traceJNI("SetByteArrayRegion");
        env.getFunctions().getSetByteArrayRegion().call(env, array, offset, len, buff);
    }

    public static void SetCharArrayRegion(JNI.JNIEnv env, JNI.JCharArray array, int offset, int len, CShortPointer buff) {
        JNIUtil.traceJNI("SetCharArrayRegion");
        env.getFunctions().getSetCharArrayRegion().call(env, array, offset, len, buff);
    }

    public static void SetShortArrayRegion(JNI.JNIEnv env, JNI.JShortArray array, int offset, int len, CShortPointer buff) {
        JNIUtil.traceJNI("SetShortArrayRegion");
        env.getFunctions().getSetShortArrayRegion().call(env, array, offset, len, buff);
    }

    public static void SetIntArrayRegion(JNI.JNIEnv env, JNI.JIntArray array, int offset, int len, CIntPointer buff) {
        JNIUtil.traceJNI("SetIntArrayRegion");
        env.getFunctions().getSetIntArrayRegion().call(env, array, offset, len, buff);
    }

    public static void SetLongArrayRegion(JNI.JNIEnv env, JNI.JLongArray array, int offset, int len, CLongPointer buff) {
        JNIUtil.traceJNI("SetLongArrayRegion");
        env.getFunctions().getSetLongArrayRegion().call(env, array, offset, len, buff);
    }

    public static void SetFloatArrayRegion(JNI.JNIEnv env, JNI.JFloatArray array, int offset, int len, CFloatPointer buff) {
        JNIUtil.traceJNI("SetFloatArrayRegion");
        env.getFunctions().getSetFloatArrayRegion().call(env, array, offset, len, buff);
    }

    public static void SetDoubleArrayRegion(JNI.JNIEnv env, JNI.JDoubleArray array, int offset, int len, CDoublePointer buff) {
        JNIUtil.traceJNI("SetDoubleArrayRegion");
        env.getFunctions().getSetDoubleArrayRegion().call(env, array, offset, len, buff);
    }

    public static JNI.JavaVM GetJavaVM(JNI.JNIEnv env) {
        JNIUtil.traceJNI("GetJavaVM");
        JNI.JavaVMPointer javaVMPointer = (JNI.JavaVMPointer)StackValue.get(JNI.JavaVMPointer.class);
        if (env.getFunctions().getGetJavaVM().call(env, javaVMPointer) == 0) {
            return javaVMPointer.readJavaVM();
        }
        return (JNI.JavaVM)WordFactory.nullPointer();
    }

    public static JNI.JNIEnv GetEnv(JNI.JavaVM vm) {
        JNIUtil.traceJNI("GetEnv");
        JNI.JNIEnvPointer envPointer = (JNI.JNIEnvPointer)StackValue.get(JNI.JNIEnvPointer.class);
        if (vm.getFunctions().getGetEnv().call(vm, envPointer, 655360) == 0) {
            return envPointer.readJNIEnv();
        }
        return (JNI.JNIEnv)WordFactory.nullPointer();
    }

    public static JNI.JNIEnv AttachCurrentThread(JNI.JavaVM vm, JNI.JavaVMAttachArgs args) {
        JNIUtil.traceJNI("AttachCurrentThread");
        JNI.JNIEnvPointer envPointer = (JNI.JNIEnvPointer)StackValue.get(JNI.JNIEnvPointer.class);
        if (vm.getFunctions().getAttachCurrentThread().call(vm, envPointer, args) == 0) {
            return envPointer.readJNIEnv();
        }
        return (JNI.JNIEnv)WordFactory.nullPointer();
    }

    public static JNI.JNIEnv AttachCurrentThreadAsDaemon(JNI.JavaVM vm, JNI.JavaVMAttachArgs args) {
        JNIUtil.traceJNI("AttachCurrentThreadAsDaemon");
        JNI.JNIEnvPointer envPointer = (JNI.JNIEnvPointer)StackValue.get(JNI.JNIEnvPointer.class);
        if (vm.getFunctions().getAttachCurrentThreadAsDaemon().call(vm, envPointer, args) == 0) {
            return envPointer.readJNIEnv();
        }
        return (JNI.JNIEnv)WordFactory.nullPointer();
    }

    public static boolean DetachCurrentThread(JNI.JavaVM vm) {
        JNIUtil.traceJNI("DetachCurrentThread");
        return vm.getFunctions().getDetachCurrentThread().call(vm) == 0;
    }

    public static void Throw(JNI.JNIEnv env, JNI.JThrowable throwable) {
        JNIUtil.traceJNI("Throw");
        env.getFunctions().getThrow().call(env, throwable);
    }

    public static boolean ExceptionCheck(JNI.JNIEnv env) {
        JNIUtil.traceJNI("ExceptionCheck");
        return env.getFunctions().getExceptionCheck().call(env);
    }

    public static void ExceptionClear(JNI.JNIEnv env) {
        JNIUtil.traceJNI("ExceptionClear");
        env.getFunctions().getExceptionClear().call(env);
    }

    public static void ExceptionDescribe(JNI.JNIEnv env) {
        JNIUtil.traceJNI("ExceptionDescribe");
        env.getFunctions().getExceptionDescribe().call(env);
    }

    public static JNI.JThrowable ExceptionOccurred(JNI.JNIEnv env) {
        JNIUtil.traceJNI("ExceptionOccurred");
        return env.getFunctions().getExceptionOccurred().call(env);
    }

    public static <T extends JNI.JObject> T NewGlobalRef(JNI.JNIEnv env, T ref, String type) {
        JNIUtil.traceJNI("NewGlobalRef");
        JNI.JObject res = env.getFunctions().getNewGlobalRef().call(env, ref);
        if (JNIUtil.tracingAt(3)) {
            JNIUtil.trace(3, "New global reference for 0x%x of type %s -> 0x%x", ref.rawValue(), type, res.rawValue());
        }
        return (T)res;
    }

    public static void DeleteGlobalRef(JNI.JNIEnv env, JNI.JObject ref) {
        JNIUtil.traceJNI("DeleteGlobalRef");
        if (JNIUtil.tracingAt(3)) {
            JNIUtil.trace(3, "Delete global reference 0x%x", ref.rawValue());
        }
        env.getFunctions().getDeleteGlobalRef().call(env, ref);
    }

    public static JNI.JWeak NewWeakGlobalRef(JNI.JNIEnv env, JNI.JObject ref, String type) {
        JNIUtil.traceJNI("NewWeakGlobalRef");
        JNI.JWeak res = env.getFunctions().getNewWeakGlobalRef().call(env, ref);
        if (JNIUtil.tracingAt(3)) {
            JNIUtil.trace(3, "New weak global reference for 0x%x of type %s -> 0x%x", ref.rawValue(), type, res.rawValue());
        }
        return res;
    }

    public static void DeleteWeakGlobalRef(JNI.JNIEnv env, JNI.JWeak ref) {
        JNIUtil.traceJNI("DeleteWeakGlobalRef");
        if (JNIUtil.tracingAt(3)) {
            JNIUtil.trace(3, "Delete weak global reference 0x%x", ref.rawValue());
        }
        env.getFunctions().getDeleteWeakGlobalRef().call(env, ref);
    }

    public static VoidPointer GetDirectBufferAddress(JNI.JNIEnv env, JNI.JObject buf) {
        JNIUtil.traceJNI("GetDirectBufferAddress");
        return env.getFunctions().getGetDirectBufferAddress().call(env, buf);
    }

    public static boolean IsInstanceOf(JNI.JNIEnv env, JNI.JObject obj, JNI.JClass clazz) {
        JNIUtil.traceJNI("IsInstanceOf");
        return env.getFunctions().getIsInstanceOf().call(env, obj, clazz);
    }

    private static void traceJNI(String function) {
        JNIUtil.trace(2, "%s->JNI: %s", JNIUtil.getFeatureName(), function);
    }

    private JNIUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createString(JNI.JNIEnv env, JNI.JString hsString) {
        if (hsString.isNull()) {
            return null;
        }
        int len = env.getFunctions().getGetStringLength().call(env, hsString);
        CShortPointer unicode = env.getFunctions().getGetStringChars().call(env, hsString, (JNI.JValue)WordFactory.nullPointer());
        try {
            char[] data = new char[len];
            for (int i = 0; i < len; ++i) {
                data[i] = (char)unicode.read(i);
            }
            String string = new String(data);
            return string;
        }
        finally {
            env.getFunctions().getReleaseStringChars().call(env, hsString, unicode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JNI.JString createHSString(JNI.JNIEnv env, String string) {
        if (string == null) {
            return (JNI.JString)WordFactory.nullPointer();
        }
        int len = string.length();
        CShortPointer buffer = (CShortPointer)UnmanagedMemory.malloc((int)(len << 1));
        try {
            for (int i = 0; i < len; ++i) {
                buffer.write(i, (short)string.charAt(i));
            }
            JNI.JString jString = env.getFunctions().getNewString().call(env, buffer, len);
            return jString;
        }
        finally {
            UnmanagedMemory.free((PointerBase)buffer);
        }
    }

    public static boolean[] createArray(JNI.JNIEnv env, JNI.JBooleanArray booleanArray) {
        if (booleanArray.isNull()) {
            return null;
        }
        int len = JNIUtil.GetArrayLength(env, booleanArray);
        boolean[] booleans = new boolean[len];
        JNIUtil.arrayCopy(env, booleanArray, 0, booleans, 0, len);
        return booleans;
    }

    public static JNI.JBooleanArray createHSArray(JNI.JNIEnv jniEnv, boolean[] a) {
        if (a == null) {
            return (JNI.JBooleanArray)WordFactory.nullPointer();
        }
        JNI.JBooleanArray array = JNIUtil.NewBooleanArray(jniEnv, a.length);
        JNIUtil.arrayCopy(jniEnv, a, 0, array, 0, a.length);
        return array;
    }

    public static byte[] createArray(JNI.JNIEnv env, JNI.JByteArray byteArray) {
        if (byteArray.isNull()) {
            return null;
        }
        int len = JNIUtil.GetArrayLength(env, byteArray);
        byte[] bytes = new byte[len];
        JNIUtil.arrayCopy(env, byteArray, 0, bytes, 0, len);
        return bytes;
    }

    public static JNI.JByteArray createHSArray(JNI.JNIEnv jniEnv, byte[] a) {
        if (a == null) {
            return (JNI.JByteArray)WordFactory.nullPointer();
        }
        JNI.JByteArray array = JNIUtil.NewByteArray(jniEnv, a.length);
        JNIUtil.arrayCopy(jniEnv, a, 0, array, 0, a.length);
        return array;
    }

    public static char[] createArray(JNI.JNIEnv env, JNI.JCharArray charArray) {
        if (charArray.isNull()) {
            return null;
        }
        int len = JNIUtil.GetArrayLength(env, charArray);
        char[] chars = new char[len];
        JNIUtil.arrayCopy(env, charArray, 0, chars, 0, len);
        return chars;
    }

    public static JNI.JCharArray createHSArray(JNI.JNIEnv jniEnv, char[] a) {
        if (a == null) {
            return (JNI.JCharArray)WordFactory.nullPointer();
        }
        JNI.JCharArray array = JNIUtil.NewCharArray(jniEnv, a.length);
        JNIUtil.arrayCopy(jniEnv, a, 0, array, 0, a.length);
        return array;
    }

    public static short[] createArray(JNI.JNIEnv env, JNI.JShortArray shortArray) {
        if (shortArray.isNull()) {
            return null;
        }
        int len = JNIUtil.GetArrayLength(env, shortArray);
        short[] shorts = new short[len];
        JNIUtil.arrayCopy(env, shortArray, 0, shorts, 0, len);
        return shorts;
    }

    public static JNI.JShortArray createHSArray(JNI.JNIEnv jniEnv, short[] a) {
        if (a == null) {
            return (JNI.JShortArray)WordFactory.nullPointer();
        }
        JNI.JShortArray array = JNIUtil.NewShortArray(jniEnv, a.length);
        JNIUtil.arrayCopy(jniEnv, a, 0, array, 0, a.length);
        return array;
    }

    public static int[] createArray(JNI.JNIEnv env, JNI.JIntArray intArray) {
        if (intArray.isNull()) {
            return null;
        }
        int len = JNIUtil.GetArrayLength(env, intArray);
        int[] ints = new int[len];
        JNIUtil.arrayCopy(env, intArray, 0, ints, 0, len);
        return ints;
    }

    public static JNI.JIntArray createHSArray(JNI.JNIEnv jniEnv, int[] a) {
        if (a == null) {
            return (JNI.JIntArray)WordFactory.nullPointer();
        }
        JNI.JIntArray array = JNIUtil.NewIntArray(jniEnv, a.length);
        JNIUtil.arrayCopy(jniEnv, a, 0, array, 0, a.length);
        return array;
    }

    public static long[] createArray(JNI.JNIEnv env, JNI.JLongArray longArray) {
        if (longArray.isNull()) {
            return null;
        }
        int len = JNIUtil.GetArrayLength(env, longArray);
        long[] longs = new long[len];
        JNIUtil.arrayCopy(env, longArray, 0, longs, 0, len);
        return longs;
    }

    public static JNI.JLongArray createHSArray(JNI.JNIEnv jniEnv, long[] a) {
        if (a == null) {
            return (JNI.JLongArray)WordFactory.nullPointer();
        }
        JNI.JLongArray array = JNIUtil.NewLongArray(jniEnv, a.length);
        JNIUtil.arrayCopy(jniEnv, a, 0, array, 0, a.length);
        return array;
    }

    public static float[] createArray(JNI.JNIEnv env, JNI.JFloatArray floatArray) {
        if (floatArray.isNull()) {
            return null;
        }
        int len = JNIUtil.GetArrayLength(env, floatArray);
        float[] floats = new float[len];
        JNIUtil.arrayCopy(env, floatArray, 0, floats, 0, len);
        return floats;
    }

    public static JNI.JFloatArray createHSArray(JNI.JNIEnv jniEnv, float[] a) {
        if (a == null) {
            return (JNI.JFloatArray)WordFactory.nullPointer();
        }
        JNI.JFloatArray array = JNIUtil.NewFloatArray(jniEnv, a.length);
        JNIUtil.arrayCopy(jniEnv, a, 0, array, 0, a.length);
        return array;
    }

    public static double[] createArray(JNI.JNIEnv env, JNI.JDoubleArray doubleArray) {
        if (doubleArray.isNull()) {
            return null;
        }
        int len = JNIUtil.GetArrayLength(env, doubleArray);
        double[] doubles = new double[len];
        JNIUtil.arrayCopy(env, doubleArray, 0, doubles, 0, len);
        return doubles;
    }

    public static JNI.JDoubleArray createHSArray(JNI.JNIEnv jniEnv, double[] a) {
        if (a == null) {
            return (JNI.JDoubleArray)WordFactory.nullPointer();
        }
        JNI.JDoubleArray array = JNIUtil.NewDoubleArray(jniEnv, a.length);
        JNIUtil.arrayCopy(jniEnv, a, 0, array, 0, a.length);
        return array;
    }

    public static JNI.JObjectArray createHSArray(JNI.JNIEnv jniEnv, Object[] array, int sourcePosition, int length, String componentTypeBinaryName) {
        JNI.JObjectArray hsArray;
        if (array != null) {
            hsArray = JNIUtil.NewObjectArray(jniEnv, length, JNIUtil.findClass(jniEnv, (JNI.JObject)WordFactory.nullPointer(), componentTypeBinaryName, true), (JNI.JObject)WordFactory.nullPointer());
            for (int i = 0; i < length; ++i) {
                HSObject element = (HSObject)array[sourcePosition + i];
                JNI.JObject hsElement = element != null ? element.getHandle() : (JNI.JObject)WordFactory.nullPointer();
                JNIUtil.SetObjectArrayElement(jniEnv, hsArray, i, hsElement);
            }
        } else {
            hsArray = (JNI.JObjectArray)WordFactory.nullPointer();
        }
        return hsArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void arrayCopy(JNI.JNIEnv jniEnv, JNI.JBooleanArray src, int srcPos, boolean[] dest, int destPos, int length) {
        CCharPointer staticBuffer = (CCharPointer)StackValue.get((int)8192);
        CCharPointer booleanPointer = length <= 8192 ? staticBuffer : (CCharPointer)UnmanagedMemory.malloc((int)length);
        try {
            JNIUtil.GetBooleanArrayRegion(jniEnv, src, srcPos, length, booleanPointer);
            for (int i = 0; i < length; ++i) {
                dest[destPos + i] = booleanPointer.addressOf(i).read() != 0;
            }
        }
        finally {
            if (booleanPointer != staticBuffer) {
                UnmanagedMemory.free((PointerBase)booleanPointer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void arrayCopy(JNI.JNIEnv jniEnv, boolean[] src, int srcPos, JNI.JBooleanArray dest, int destPos, int length) {
        CCharPointer staticBuffer = (CCharPointer)StackValue.get((int)8192);
        CCharPointer booleanPointer = length <= 8192 ? staticBuffer : (CCharPointer)UnmanagedMemory.malloc((int)length);
        try {
            for (int i = 0; i < length; ++i) {
                booleanPointer.write(i, src[srcPos + i] ? (byte)1 : 0);
            }
            JNIUtil.SetBooleanArrayRegion(jniEnv, dest, destPos, length, booleanPointer);
        }
        finally {
            if (booleanPointer != staticBuffer) {
                UnmanagedMemory.free((PointerBase)booleanPointer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void arrayCopy(JNI.JNIEnv jniEnv, JNI.JByteArray src, int srcPos, byte[] dest, int destPos, int length) {
        CCharPointer staticBuffer = (CCharPointer)StackValue.get((int)8192);
        CCharPointer bytePointer = length <= 8192 ? staticBuffer : (CCharPointer)UnmanagedMemory.malloc((int)length);
        try {
            JNIUtil.GetByteArrayRegion(jniEnv, src, srcPos, length, bytePointer);
            CTypeConversion.asByteBuffer((PointerBase)bytePointer, (int)length).get(dest, destPos, length);
        }
        finally {
            if (bytePointer != staticBuffer) {
                UnmanagedMemory.free((PointerBase)bytePointer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void arrayCopy(JNI.JNIEnv jniEnv, byte[] src, int srcPos, JNI.JByteArray dest, int destPos, int length) {
        CCharPointer staticBuffer = (CCharPointer)StackValue.get((int)8192);
        CCharPointer bytePointer = length <= 8192 ? staticBuffer : (CCharPointer)UnmanagedMemory.malloc((int)length);
        try {
            CTypeConversion.asByteBuffer((PointerBase)bytePointer, (int)length).put(src, srcPos, length);
            JNIUtil.SetByteArrayRegion(jniEnv, dest, destPos, length, bytePointer);
        }
        finally {
            if (bytePointer != staticBuffer) {
                UnmanagedMemory.free((PointerBase)bytePointer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void arrayCopy(JNI.JNIEnv jniEnv, JNI.JCharArray src, int srcPos, char[] dest, int destPos, int length) {
        CShortPointer staticBuffer = (CShortPointer)StackValue.get((int)8192);
        int bytesLength = length * 2;
        CShortPointer shortPointer = bytesLength <= 8192 ? staticBuffer : (CShortPointer)UnmanagedMemory.malloc((int)bytesLength);
        try {
            JNIUtil.GetCharArrayRegion(jniEnv, src, srcPos, length, shortPointer);
            CTypeConversion.asByteBuffer((PointerBase)shortPointer, (int)bytesLength).asCharBuffer().get(dest, destPos, length);
        }
        finally {
            if (shortPointer != staticBuffer) {
                UnmanagedMemory.free((PointerBase)shortPointer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void arrayCopy(JNI.JNIEnv jniEnv, char[] src, int srcPos, JNI.JCharArray dest, int destPos, int length) {
        CShortPointer staticBuffer = (CShortPointer)StackValue.get((int)8192);
        int bytesLength = length * 2;
        CShortPointer shortPointer = bytesLength <= 8192 ? staticBuffer : (CShortPointer)UnmanagedMemory.malloc((int)bytesLength);
        try {
            CTypeConversion.asByteBuffer((PointerBase)shortPointer, (int)bytesLength).asCharBuffer().put(src, srcPos, length);
            JNIUtil.SetCharArrayRegion(jniEnv, dest, destPos, length, shortPointer);
        }
        finally {
            if (shortPointer != staticBuffer) {
                UnmanagedMemory.free((PointerBase)shortPointer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void arrayCopy(JNI.JNIEnv jniEnv, JNI.JShortArray src, int srcPos, short[] dest, int destPos, int length) {
        CShortPointer staticBuffer = (CShortPointer)StackValue.get((int)8192);
        int bytesLength = length * 2;
        CShortPointer shortPointer = bytesLength <= 8192 ? staticBuffer : (CShortPointer)UnmanagedMemory.malloc((int)bytesLength);
        try {
            JNIUtil.GetShortArrayRegion(jniEnv, src, srcPos, length, shortPointer);
            CTypeConversion.asByteBuffer((PointerBase)shortPointer, (int)bytesLength).asShortBuffer().get(dest, destPos, length);
        }
        finally {
            if (shortPointer != staticBuffer) {
                UnmanagedMemory.free((PointerBase)shortPointer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void arrayCopy(JNI.JNIEnv jniEnv, short[] src, int srcPos, JNI.JShortArray dest, int destPos, int length) {
        CShortPointer staticBuffer = (CShortPointer)StackValue.get((int)8192);
        int bytesLength = length * 2;
        CShortPointer shortPointer = bytesLength <= 8192 ? staticBuffer : (CShortPointer)UnmanagedMemory.malloc((int)bytesLength);
        try {
            CTypeConversion.asByteBuffer((PointerBase)shortPointer, (int)bytesLength).asShortBuffer().put(src, srcPos, length);
            JNIUtil.SetShortArrayRegion(jniEnv, dest, destPos, length, shortPointer);
        }
        finally {
            if (shortPointer != staticBuffer) {
                UnmanagedMemory.free((PointerBase)shortPointer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void arrayCopy(JNI.JNIEnv jniEnv, JNI.JIntArray src, int srcPos, int[] dest, int destPos, int length) {
        CIntPointer staticBuffer = (CIntPointer)StackValue.get((int)8192);
        int bytesLength = length * 4;
        CIntPointer intPointer = bytesLength <= 8192 ? staticBuffer : (CIntPointer)UnmanagedMemory.malloc((int)bytesLength);
        try {
            JNIUtil.GetIntArrayRegion(jniEnv, src, srcPos, length, intPointer);
            CTypeConversion.asByteBuffer((PointerBase)intPointer, (int)bytesLength).asIntBuffer().get(dest, destPos, length);
        }
        finally {
            if (intPointer != staticBuffer) {
                UnmanagedMemory.free((PointerBase)intPointer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void arrayCopy(JNI.JNIEnv jniEnv, int[] src, int srcPos, JNI.JIntArray dest, int destPos, int length) {
        CIntPointer staticBuffer = (CIntPointer)StackValue.get((int)8192);
        int bytesLength = length * 4;
        CIntPointer intPointer = bytesLength <= 8192 ? staticBuffer : (CIntPointer)UnmanagedMemory.malloc((int)bytesLength);
        try {
            CTypeConversion.asByteBuffer((PointerBase)intPointer, (int)bytesLength).asIntBuffer().put(src, srcPos, length);
            JNIUtil.SetIntArrayRegion(jniEnv, dest, destPos, length, intPointer);
        }
        finally {
            if (intPointer != staticBuffer) {
                UnmanagedMemory.free((PointerBase)intPointer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void arrayCopy(JNI.JNIEnv jniEnv, JNI.JLongArray src, int srcPos, long[] dest, int destPos, int length) {
        CLongPointer staticBuffer = (CLongPointer)StackValue.get((int)8192);
        int bytesLength = length * 8;
        CLongPointer longPointer = bytesLength <= 8192 ? staticBuffer : (CLongPointer)UnmanagedMemory.malloc((int)bytesLength);
        try {
            JNIUtil.GetLongArrayRegion(jniEnv, src, srcPos, length, longPointer);
            CTypeConversion.asByteBuffer((PointerBase)longPointer, (int)bytesLength).asLongBuffer().get(dest, destPos, length);
        }
        finally {
            if (longPointer != staticBuffer) {
                UnmanagedMemory.free((PointerBase)longPointer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void arrayCopy(JNI.JNIEnv jniEnv, long[] src, int srcPos, JNI.JLongArray dest, int destPos, int length) {
        CLongPointer staticBuffer = (CLongPointer)StackValue.get((int)8192);
        int bytesLength = length * 8;
        CLongPointer longPointer = bytesLength <= 8192 ? staticBuffer : (CLongPointer)UnmanagedMemory.malloc((int)bytesLength);
        try {
            CTypeConversion.asByteBuffer((PointerBase)longPointer, (int)bytesLength).asLongBuffer().put(src, srcPos, length);
            JNIUtil.SetLongArrayRegion(jniEnv, dest, destPos, length, longPointer);
        }
        finally {
            if (longPointer != staticBuffer) {
                UnmanagedMemory.free((PointerBase)longPointer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void arrayCopy(JNI.JNIEnv jniEnv, JNI.JFloatArray src, int srcPos, float[] dest, int destPos, int length) {
        CFloatPointer staticBuffer = (CFloatPointer)StackValue.get((int)8192);
        int bytesLength = length * 4;
        CFloatPointer floatPointer = bytesLength <= 8192 ? staticBuffer : (CFloatPointer)UnmanagedMemory.malloc((int)bytesLength);
        try {
            JNIUtil.GetFloatArrayRegion(jniEnv, src, srcPos, length, floatPointer);
            CTypeConversion.asByteBuffer((PointerBase)floatPointer, (int)bytesLength).asFloatBuffer().get(dest, destPos, length);
        }
        finally {
            if (floatPointer != staticBuffer) {
                UnmanagedMemory.free((PointerBase)floatPointer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void arrayCopy(JNI.JNIEnv jniEnv, float[] src, int srcPos, JNI.JFloatArray dest, int destPos, int length) {
        CFloatPointer staticBuffer = (CFloatPointer)StackValue.get((int)8192);
        int bytesLength = length * 4;
        CFloatPointer floatPointer = bytesLength <= 8192 ? staticBuffer : (CFloatPointer)UnmanagedMemory.malloc((int)bytesLength);
        try {
            CTypeConversion.asByteBuffer((PointerBase)floatPointer, (int)bytesLength).asFloatBuffer().put(src, srcPos, length);
            JNIUtil.SetFloatArrayRegion(jniEnv, dest, destPos, length, floatPointer);
        }
        finally {
            if (floatPointer != staticBuffer) {
                UnmanagedMemory.free((PointerBase)floatPointer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void arrayCopy(JNI.JNIEnv jniEnv, JNI.JDoubleArray src, int srcPos, double[] dest, int destPos, int length) {
        CDoublePointer staticBuffer = (CDoublePointer)StackValue.get((int)8192);
        int bytesLength = length * 8;
        CDoublePointer doublePointer = bytesLength <= 8192 ? staticBuffer : (CDoublePointer)UnmanagedMemory.malloc((int)bytesLength);
        try {
            JNIUtil.GetDoubleArrayRegion(jniEnv, src, srcPos, length, doublePointer);
            CTypeConversion.asByteBuffer((PointerBase)doublePointer, (int)bytesLength).asDoubleBuffer().get(dest, destPos, length);
        }
        finally {
            if (doublePointer != staticBuffer) {
                UnmanagedMemory.free((PointerBase)doublePointer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void arrayCopy(JNI.JNIEnv jniEnv, double[] src, int srcPos, JNI.JDoubleArray dest, int destPos, int length) {
        CDoublePointer staticBuffer = (CDoublePointer)StackValue.get((int)8192);
        int bytesLength = length * 8;
        CDoublePointer doublePointer = bytesLength <= 8192 ? staticBuffer : (CDoublePointer)UnmanagedMemory.malloc((int)bytesLength);
        try {
            CTypeConversion.asByteBuffer((PointerBase)doublePointer, (int)bytesLength).asDoubleBuffer().put(src, srcPos, length);
            JNIUtil.SetDoubleArrayRegion(jniEnv, dest, destPos, length, doublePointer);
        }
        finally {
            if (doublePointer != staticBuffer) {
                UnmanagedMemory.free((PointerBase)doublePointer);
            }
        }
    }

    public static String getInternalName(String fqn) {
        return "L" + JNIUtil.getBinaryName(fqn) + ";";
    }

    public static String getBinaryName(String fqn) {
        return fqn.replace('.', '/');
    }

    public static String encodeMethodSignature(Class<?> returnType, Class<?> ... parameterTypes) {
        StringBuilder builder = new StringBuilder("(");
        for (Class<?> type : parameterTypes) {
            JNIUtil.encodeType(type, builder);
        }
        builder.append(")");
        JNIUtil.encodeType(returnType, builder);
        return builder.toString();
    }

    public static String encodeFieldSignature(Class<?> type) {
        StringBuilder res = new StringBuilder();
        JNIUtil.encodeType(type, res);
        return res.toString();
    }

    private static void encodeType(Class<?> type, StringBuilder buf) {
        Object desc;
        if (type == Boolean.TYPE) {
            desc = "Z";
        } else if (type == Byte.TYPE) {
            desc = "B";
        } else if (type == Character.TYPE) {
            desc = "C";
        } else if (type == Short.TYPE) {
            desc = "S";
        } else if (type == Integer.TYPE) {
            desc = "I";
        } else if (type == Long.TYPE) {
            desc = "J";
        } else if (type == Float.TYPE) {
            desc = "F";
        } else if (type == Double.TYPE) {
            desc = "D";
        } else if (type == Void.TYPE) {
            desc = "V";
        } else {
            if (type.isArray()) {
                buf.append('[');
                JNIUtil.encodeType(type.getComponentType(), buf);
                return;
            }
            desc = "L" + type.getName().replace('.', '/') + ";";
        }
        buf.append((String)desc);
    }

    public static JNI.JClass findClass(JNI.JNIEnv env, String binaryName) {
        JNIUtil.trace(1, "%s->HS: findClass %s", JNIUtil.getFeatureName(), binaryName);
        try (CTypeConversion.CCharPointerHolder name = CTypeConversion.toCString((CharSequence)binaryName);){
            JNI.JClass jClass = JNIUtil.FindClass(env, name.get());
            return jClass;
        }
    }

    public static JNI.JClass findClass(JNI.JNIEnv env, JNI.JObject classLoader, String binaryName) {
        if (classLoader.isNull()) {
            throw new IllegalArgumentException("ClassLoader must be non null.");
        }
        JNIUtil.trace(1, "%s->HS: findClass %s", JNIUtil.getFeatureName(), binaryName);
        JNI.JMethodID findClassId = JNIUtil.findMethod(env, JNIUtil.GetObjectClass(env, classLoader), false, false, METHOD_LOAD_CLASS[0], METHOD_LOAD_CLASS[1]);
        JNI.JValue params = (JNI.JValue)StackValue.get((int)1, JNI.JValue.class);
        params.addressOf(0).setJObject(JNIUtil.createHSString(env, binaryName.replace('/', '.')));
        return (JNI.JClass)env.getFunctions().getCallObjectMethodA().call(env, classLoader, findClassId, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JNI.JClass findClass(JNI.JNIEnv env, JNI.JObject classLoader, String binaryName, boolean required) {
        Class allowedException;
        block3: {
            JNI.JClass jClass;
            allowedException = null;
            try {
                if (!classLoader.isNonNull()) break block3;
                allowedException = required ? null : ClassNotFoundException.class;
                jClass = JNIUtil.findClass(env, classLoader, binaryName);
                JNIExceptionWrapper.wrapAndThrowPendingJNIException(env, allowedException == null ? JNIExceptionWrapper.ExceptionHandler.DEFAULT : JNIExceptionWrapper.ExceptionHandler.allowExceptions(allowedException));
            }
            catch (Throwable throwable) {
                JNIExceptionWrapper.wrapAndThrowPendingJNIException(env, allowedException == null ? JNIExceptionWrapper.ExceptionHandler.DEFAULT : JNIExceptionWrapper.ExceptionHandler.allowExceptions(allowedException));
                throw throwable;
            }
            return jClass;
        }
        allowedException = required ? null : NoClassDefFoundError.class;
        JNI.JClass jClass = JNIUtil.findClass(env, binaryName);
        JNIExceptionWrapper.wrapAndThrowPendingJNIException(env, allowedException == null ? JNIExceptionWrapper.ExceptionHandler.DEFAULT : JNIExceptionWrapper.ExceptionHandler.allowExceptions(allowedException));
        return jClass;
    }

    public static JNI.JObject getJVMCIClassLoader(JNI.JNIEnv env) {
        JNI.JClass clazz;
        try (CTypeConversion.CCharPointerHolder className = CTypeConversion.toCString((CharSequence)JNIUtil.getBinaryName(ClassLoader.class.getName()));){
            clazz = JNIUtil.FindClass(env, className.get());
        }
        if (clazz.isNull()) {
            throw new InternalError("No such class " + ClassLoader.class.getName());
        }
        JNI.JMethodID getClassLoaderId = JNIUtil.findMethod(env, clazz, true, true, METHOD_GET_PLATFORM_CLASS_LOADER[0], METHOD_GET_PLATFORM_CLASS_LOADER[1]);
        if (getClassLoaderId.isNull()) {
            throw new InternalError(String.format("Cannot find method %s in class %s.", METHOD_GET_PLATFORM_CLASS_LOADER[0], ClassLoader.class.getName()));
        }
        return env.getFunctions().getCallStaticObjectMethodA().call(env, clazz, getClassLoaderId, (JNI.JValue)WordFactory.nullPointer());
    }

    public static JNI.JObject getSystemClassLoader(JNI.JNIEnv env) {
        JNI.JClass clazz;
        try (CTypeConversion.CCharPointerHolder className = CTypeConversion.toCString((CharSequence)JNIUtil.getBinaryName(ClassLoader.class.getName()));){
            clazz = JNIUtil.FindClass(env, className.get());
        }
        if (clazz.isNull()) {
            throw new InternalError("No such class " + ClassLoader.class.getName());
        }
        JNI.JMethodID getClassLoaderId = JNIUtil.findMethod(env, clazz, true, true, METHOD_GET_SYSTEM_CLASS_LOADER[0], METHOD_GET_SYSTEM_CLASS_LOADER[1]);
        if (getClassLoaderId.isNull()) {
            throw new InternalError(String.format("Cannot find method %s in class %s.", METHOD_GET_SYSTEM_CLASS_LOADER[0], ClassLoader.class.getName()));
        }
        return env.getFunctions().getCallStaticObjectMethodA().call(env, clazz, getClassLoaderId, (JNI.JValue)WordFactory.nullPointer());
    }

    public static JNI.JMethodID findMethod(JNI.JNIEnv env, JNI.JClass clazz, boolean staticMethod, String methodName, String methodSignature) {
        return JNIUtil.findMethod(env, clazz, staticMethod, false, methodName, methodSignature);
    }

    static JNI.JMethodID findMethod(JNI.JNIEnv env, JNI.JClass clazz, boolean staticMethod, boolean required, String methodName, String methodSignature) {
        try (CTypeConversion.CCharPointerHolder name = CTypeConversion.toCString((CharSequence)methodName);){
            JNI.JMethodID jMethodID;
            block12: {
                CTypeConversion.CCharPointerHolder sig = CTypeConversion.toCString((CharSequence)methodSignature);
                try {
                    JNI.JMethodID result = staticMethod ? JNIUtil.GetStaticMethodID(env, clazz, name.get(), sig.get()) : JNIUtil.GetMethodID(env, clazz, name.get(), sig.get());
                    JNIExceptionWrapper.wrapAndThrowPendingJNIException(env, required ? JNIExceptionWrapper.ExceptionHandler.DEFAULT : JNIExceptionWrapper.ExceptionHandler.allowExceptions(NoSuchMethodError.class));
                    jMethodID = result;
                    if (sig == null) break block12;
                }
                catch (Throwable throwable) {
                    if (sig != null) {
                        try {
                            sig.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                sig.close();
            }
            return jMethodID;
        }
    }

    public static JNI.JFieldID findField(JNI.JNIEnv env, JNI.JClass clazz, boolean staticField, String fieldName, String fieldSignature) {
        try (CTypeConversion.CCharPointerHolder name = CTypeConversion.toCString((CharSequence)fieldName);){
            JNI.JFieldID jFieldID;
            block12: {
                CTypeConversion.CCharPointerHolder sig = CTypeConversion.toCString((CharSequence)fieldSignature);
                try {
                    JNI.JFieldID result = staticField ? JNIUtil.GetStaticFieldID(env, clazz, name.get(), sig.get()) : JNIUtil.GetFieldID(env, clazz, name.get(), sig.get());
                    JNIExceptionWrapper.wrapAndThrowPendingJNIException(env);
                    jFieldID = result;
                    if (sig == null) break block12;
                }
                catch (Throwable throwable) {
                    if (sig != null) {
                        try {
                            sig.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                sig.close();
            }
            return jFieldID;
        }
    }

    public static JNI.JNIEnv attachCurrentThread(JNI.JavaVM vm, boolean daemon, String name, JNI.JObject threadGroup) {
        try (CTypeConversion.CCharPointerHolder cname = CTypeConversion.toCString((CharSequence)name);){
            JNI.JavaVMAttachArgs args = (JNI.JavaVMAttachArgs)StackValue.get(JNI.JavaVMAttachArgs.class);
            args.setVersion(655360);
            args.setGroup(threadGroup);
            args.setName(cname.get());
            JNI.JNIEnv jNIEnv = daemon ? JNIUtil.AttachCurrentThreadAsDaemon(vm, args) : JNIUtil.AttachCurrentThread(vm, args);
            return jNIEnv;
        }
    }

    public static boolean tracingAt(int level) {
        return NativeBridgeSupport.getInstance().isTracingEnabled(level);
    }

    public static void trace(int level, String format, Object ... args) {
        if (JNIUtil.tracingAt(level)) {
            StringBuilder sb = new StringBuilder();
            sb.append('[').append(IsolateUtil.getIsolateID()).append(':').append(Thread.currentThread().getName()).append(']');
            JNIMethodScope scope = JNIMethodScope.scopeOrNull();
            if (scope != null) {
                sb.append(new String(new char[2 + scope.depth() * 2]).replace('\u0000', ' '));
            }
            NativeBridgeSupport.getInstance().trace(sb.append(String.format(format, args)).toString());
        }
    }

    public static void trace(int level, Throwable throwable) {
        if (JNIUtil.tracingAt(level)) {
            StringWriter stringWriter = new StringWriter();
            try (PrintWriter out = new PrintWriter(stringWriter);){
                throwable.printStackTrace(out);
            }
            JNIUtil.trace(level, stringWriter.toString(), new Object[0]);
        }
    }

    static String getFeatureName() {
        return NativeBridgeSupport.getInstance().getFeatureName();
    }
}

