/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.word;

import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.type.AbstractPointerStamp;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.ConstantValue;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.type.NarrowOopStamp;

@NodeInfo(cycles=NodeCycles.CYCLES_1, size=NodeSize.SIZE_1)
public final class WordCastNode
extends FixedWithNextNode
implements LIRLowerable,
Canonicalizable {
    public static final NodeClass<WordCastNode> TYPE = NodeClass.create(WordCastNode.class);
    @Node.Input
    ValueNode input;
    private final boolean trackedPointer;

    public static WordCastNode wordToObject(ValueNode input, JavaKind wordKind) {
        assert (input.getStackKind() == wordKind);
        return new WordCastNode(WordCastNode.objectStampFor(input), input);
    }

    public static WordCastNode wordToObjectNonNull(ValueNode input, JavaKind wordKind) {
        assert (input.getStackKind() == wordKind);
        return new WordCastNode(StampFactory.objectNonNull(), input);
    }

    public static WordCastNode wordToNarrowObject(ValueNode input, NarrowOopStamp stamp) {
        return new WordCastNode(stamp, input);
    }

    public static WordCastNode addressToWord(ValueNode input, JavaKind wordKind) {
        assert (input.stamp(NodeView.DEFAULT) instanceof AbstractPointerStamp);
        return new WordCastNode(StampFactory.forKind(wordKind), input);
    }

    public static WordCastNode objectToTrackedPointer(ValueNode input, JavaKind wordKind) {
        assert (input.stamp(NodeView.DEFAULT) instanceof ObjectStamp);
        return new WordCastNode(StampFactory.forKind(wordKind), input);
    }

    public static WordCastNode objectToUntrackedPointer(ValueNode input, JavaKind wordKind) {
        assert (input.stamp(NodeView.DEFAULT) instanceof ObjectStamp);
        return new WordCastNode(StampFactory.forKind(wordKind), input, false);
    }

    public static WordCastNode narrowOopToUntrackedWord(ValueNode input, JavaKind wordKind) {
        assert (input.stamp(NodeView.DEFAULT) instanceof NarrowOopStamp);
        return new WordCastNode(StampFactory.forKind(wordKind), input, false);
    }

    private WordCastNode(Stamp stamp, ValueNode input) {
        this(stamp, input, true);
    }

    protected WordCastNode(Stamp stamp, ValueNode input, boolean trackedPointer) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, stamp);
        this.input = input;
        this.trackedPointer = trackedPointer;
    }

    public ValueNode getInput() {
        return this.input;
    }

    private static boolean isZeroConstant(ValueNode value) {
        JavaConstant constant = value.asJavaConstant();
        return constant.getJavaKind().isNumericInteger() && constant.asLong() == 0L;
    }

    private static Stamp objectStampFor(ValueNode input) {
        Stamp inputStamp = input.stamp(NodeView.DEFAULT);
        if (inputStamp instanceof AbstractPointerStamp) {
            AbstractPointerStamp pointerStamp = (AbstractPointerStamp)inputStamp;
            if (pointerStamp.alwaysNull()) {
                return StampFactory.alwaysNull();
            }
            if (pointerStamp.nonNull()) {
                return StampFactory.objectNonNull();
            }
        } else {
            if (inputStamp instanceof IntegerStamp && !((IntegerStamp)inputStamp).contains(0L)) {
                return StampFactory.objectNonNull();
            }
            if (input.isConstant() && WordCastNode.isZeroConstant(input)) {
                return StampFactory.alwaysNull();
            }
        }
        return StampFactory.object();
    }

    @Override
    public boolean inferStamp() {
        AbstractPointerStamp objectStamp;
        if (this.stamp instanceof AbstractPointerStamp && !(objectStamp = (AbstractPointerStamp)this.stamp).alwaysNull() && !objectStamp.nonNull()) {
            Stamp newStamp = this.stamp;
            Stamp inputStamp = this.input.stamp(NodeView.DEFAULT);
            if (inputStamp instanceof AbstractPointerStamp) {
                AbstractPointerStamp pointerStamp = (AbstractPointerStamp)inputStamp;
                if (pointerStamp.alwaysNull()) {
                    newStamp = objectStamp.asAlwaysNull();
                } else if (pointerStamp.nonNull()) {
                    newStamp = objectStamp.asNonNull();
                }
            } else if (inputStamp instanceof IntegerStamp && !((IntegerStamp)inputStamp).contains(0L)) {
                newStamp = objectStamp.asNonNull();
            } else if (this.input.isConstant() && WordCastNode.isZeroConstant(this.input)) {
                newStamp = objectStamp.asAlwaysNull();
            }
            return this.updateStamp(newStamp);
        }
        return false;
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        if (tool.allUsagesAvailable() && this.hasNoUsages()) {
            return this.input;
        }
        assert (!this.stamp.isCompatible(this.input.stamp(NodeView.DEFAULT)));
        if (this.input.isJavaConstant()) {
            if (this.input.asJavaConstant().isNull()) {
                return ConstantNode.forIntegerStamp(this.stamp, 0L);
            }
            if (WordCastNode.isZeroConstant(this.input)) {
                return ConstantNode.forConstant(this.stamp, (Constant)((AbstractPointerStamp)this.stamp).nullConstant(), tool.getMetaAccess());
            }
        }
        return this;
    }

    @Override
    public void generate(NodeLIRBuilderTool generator) {
        Value value = generator.operand(this.input);
        LIRKind kind = generator.getLIRGeneratorTool().getLIRKind(this.stamp(NodeView.DEFAULT));
        assert (kind.getPlatformKind().getSizeInBytes() == value.getPlatformKind().getSizeInBytes());
        if (this.trackedPointer && LIRKind.isValue(kind) && !LIRKind.isValue(value)) {
            kind = value.getValueKind().changeType(kind.getPlatformKind());
        }
        if (((Object)((Object)kind)).equals(value.getValueKind()) && !(value instanceof ConstantValue)) {
            generator.setResult(this, value);
        } else {
            Variable result = generator.getLIRGeneratorTool().newVariable(kind);
            if (this.stamp.equals(StampFactory.object())) {
                generator.getLIRGeneratorTool().emitConvertZeroToNull(result, value);
            } else if (!this.trackedPointer && !((AbstractPointerStamp)this.input.stamp(NodeView.DEFAULT)).nonNull()) {
                generator.getLIRGeneratorTool().emitConvertNullToZero((AllocatableValue)result, (AllocatableValue)value);
            } else {
                generator.getLIRGeneratorTool().emitMove(result, value);
            }
            generator.setResult(this, (Value)result);
        }
    }
}

